
<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('support.menu.title') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="support-container mw-100">
      <div class="row w-100 ml-0 mr-0">
        <!-- Chat header -->
        <div class="col-md-4 support-header">
          <div class="row justify-content-center">
            <h3 style="line-height: 2.5;">{{ mt._('support.header.ticket') }} #{{ ticket.cdtick }}</h3>
          </div>
          <div class="row justify-content-center">
            <div class="col-md-6">
              <select id="current_status" class="form-control" onchange="showSave()">
                {% for stat in status %}
                  <option value="{{ stat['cdstat'] }}" {{ stat['cdstat'] == ticket.cdstat ? 'selected' : '' }}>{{ stat['dsstat'] }}</option>
                {% endfor %}
              </select>
            </div>
            <div class="col-md-2">
              <button id="save_current_status" class="btn btn-primary" style="display:none" onclick="saveState()">{{ mt._('_common.save') }}</button>
              <i id="status_save_check" class="fa fa-check" style="color:#3eec3e;font-size:xx-large;display:none;"></i>
            </div>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.title') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.dstitl }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.order') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.numdoc }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.item') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.cdarti }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.topic') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.cdargo }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.user') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.dsuser }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.status') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6 id="ticket-status">{{ ticket.dsstat }}</h6>
          </div>

          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.created') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.dtcrea }}</h6>
          </div>

          {% if is_open %}
          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.updated') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6 id="ticket-last-update">{{ ticket.update }}</h6>
          </div>
          {% else %}
          <div class="row mx-1 mt-2">
            <h5><b>{{ mt._('support.header.closed') }}</b></h5>
          </div>
          <div class="row mx-3">
            <h6>{{ ticket.dtchiu }}</h6>
          </div>
          {% endif %}
        </div>
        <!-- End of Chat header -->


        <!-- Chat container -->
        <div class="col-md-8 support-chat">
          {#
          #}
          {{ messages }}
          <div id="new-message" class="row align-items-center" style="padding-top: 1%;position: sticky;background: white;bottom: -2%;">
            <div class="col-md-10 text-center">
              <input id="text-new-message" type="text" class="form-control" style="margin-bottom:auto; font-size:16px" placeholder="{{ mt._('chat.write') }}"
              {{ is_open and can_edit ? "" : "disabled" }}>
              <a class="btn btn-sm btn-flat add-attachments" data-toggle="collapse" href="#new-message-attachments" role="button" aria-expanded="false">
                <i class="fa fa-paperclip"></i>
              </a>
            </div>
            <div class="col-md-2 text-center">
              <button id="send-new-message" type="button" class="btn btn-primary capitalize w-100" {{ is_open and can_edit ? "" : "disabled" }} >{{ mt._('_common.send') }}</button>
            </div>
            <div class="col-xs-12">
              <form action="{{ url('support/uploadAttachment') }}" method="post" enctype="multipart/form-data"
                  id="new-message-attachments" class="dropzone collapse"
                    {{ is_open and can_edit ? "" : "disabled" }}></form>
            </div>
          </div>
        </div>
        <!-- End of Chat container -->
      </div>
    </div>
  </div>
</div>
