<div class="container mw-100 p-0">
  <div class="row m-0 mt-10x">
    <div class="col-6"><a href="{{ url('statistics/index') }}"><button type="button" class="btn btn-generic">{{ mt._('statistics.close') }}</button></a></div>
  </div>
  <div class="row m-0">

{% set qtatot_tot = 0 %}
{% set impnet_tot = 0 %}
{% set qtatot_tot2 = 0 %}
{% set impnet_tot2 = 0 %}
{% set qtatot_tot3 = 0 %}
{% set impnet_tot3 = 0 %}
{% for stat in stats %}
  {% if multistats %}
    {% set qtatot_tot = qtatot_tot + stat["qty1"] %}
    {% set impnet_tot = impnet_tot + stat["imp1"] %}
    {% if time2 != "_none" and time2 != "" %}
      {% set qtatot_tot2 = qtatot_tot2 + stat["qty2"] %}
      {% set impnet_tot2 = impnet_tot2 + stat["imp2"] %}
    {% endif %}
    {% if time3 != "_none" and time3 != "" %}
      {% set qtatot_tot3 = qtatot_tot3 + stat["qty3"] %}
      {% set impnet_tot3 = impnet_tot3 + stat["imp3"] %}
    {% endif %}
  {% else %}
    {% set qtatot_tot = qtatot_tot + stat["qtatot1"] %}
    {% set impnet_tot = impnet_tot + stat["impnet1"] %}
  {% endif %}
{% endfor %}

{% if multistats %}
  {# Get max qty, max val, max ratio #}
  {% set max_qtatot = qtatot_tot %}
  {% set max_impnet = impnet_tot / 1000 %}
  {% set max_ratio = qtatot_tot > 0 ? impnet_tot / qtatot_tot : 0 %}

  {% if time2 != "_none" and time2 != "" %}
    {% if qtatot_tot2 > max_qtatot %}
      {% set max_qtatot = qtatot_tot2 %}
    {% endif %}
    {% if impnet_tot2 / 1000 > max_impnet %}
      {% set max_impnet = impnet_tot2 / 1000 %}
    {% endif %}
    {% if qtatot_tot2 > 0 and impnet_tot2 / qtatot_tot2 > max_ratio %}
      {% set max_ratio = impnet_tot2 / qtatot_tot2 %}
    {% endif %}
  {% endif %}

  {% if time3 != "_none" and time3 != "" %}
    {% if qtatot_tot3 > max_qtatot %}
      {% set max_qtatot = qtatot_tot3 %}
    {% endif %}
    {% if impnet_tot3 / 1000 > max_impnet %}
      {% set max_impnet = impnet_tot3 / 1000 %}
    {% endif %}
    {% if qtatot_tot3 > 0 and impnet_tot3 / qtatot_tot3 > max_ratio %}
      {% set max_ratio = impnet_tot3 / qtatot_tot3 %}
    {% endif %}
  {% endif %}

  {# Get styles and info for column 1 #}
  {% set column_width = time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" ? 33.3333 : 50 %}

  {% set ratio1 = qtatot_tot > 0 ? impnet_tot / qtatot_tot : 0 %}
  {% if max_qtatot > 0 %}
    {% set h_qty_1 = 400 * (qtatot_tot / max_qtatot) %}
    {% set mt_qty_1 = 400 - (400 * (qtatot_tot / max_qtatot)) %}
  {% else %}
    {% set h_qty_1 = 0 %}
    {% set mt_qty_1 = 0 %}
  {% endif %}
  {% if max_qtatot > 0 %}
    {% set h_imp_1 = 400 * (impnet_tot / (1000 * max_impnet)) %}
    {% set mt_imp_1 = 400 - (400 * (impnet_tot / (1000 * max_impnet))) %}
  {% else %}
    {% set h_imp_1 = 0 %}
    {% set mt_imp_1 = 0 %}
  {% endif %}
  {% if max_ratio > 0 %}
    {% set h_rat_1 = 400 * (ratio1 / max_ratio) %}
    {% set mt_rat_1 = 400 - (400 * (ratio1 / max_ratio)) %}
  {% else %}
    {% set h_rat_1 = 0 %}
    {% set mt_rat_1 = 0 %}
  {% endif %}

  {# Get styles and info for column 2 #}
  {% if time2 != "_none" and time2 != "" %}
    {% set qtatot_diff2 = qtatot_tot - qtatot_tot2 %}
    {% set impnet_diff2 = (impnet_tot - impnet_tot2) / 1000 %}
    {% set ratio2 = qtatot_tot2 > 0 ? impnet_tot2 / qtatot_tot2 : 0 %}
  {% elseif time3 != "_none" and time3 != "" %}
    {% set qtatot_diff2 = qtatot_tot - qtatot_tot3 %}
    {% set impnet_diff2 = (impnet_tot - impnet_tot3) / 1000 %}
    {% set ratio2 = qtatot_tot3 > 0 ? impnet_tot3 / qtatot_tot3 : 0 %}
  {% else %}
    {% set qtatot_diff2 = 0 %}
    {% set impnet_diff2 = 0 %}
    {% set ratio2 = 0 %}
  {% endif %}

  {% set ratio_diff2 = ratio1 - ratio2 %}

  {% if max_qtatot > 0 %}
    {% set h_qty_2 = 400 * (qtatot_tot2 / max_qtatot) %}
    {% set mt_qty_2 = 400 - (400 * (qtatot_tot2 / max_qtatot)) %}
  {% else %}
    {% set h_qty_2 = 0 %}
    {% set mt_qty_2 = 0 %}
  {% endif %}
  {% if max_impnet > 0 %}
    {% set h_imp_2 = 400 * (impnet_tot2 / (1000 * max_impnet)) %}
    {% set mt_imp_2 = 400 - (400 * (impnet_tot2 / (1000 * max_impnet))) %}
  {% else %}
    {% set h_imp_2 = 0 %}
    {% set mt_imp_2 = 0 %}
  {% endif %}
  {% if max_ratio > 0 %}
    {% set h_rat_2 = 400 * (ratio2 / max_ratio) %}
    {% set mt_rat_2 = 400 - (400 * (ratio2 / max_ratio)) %}
  {% else %}
    {% set h_rat_2 = 0 %}
    {% set mt_rat_2 = 0 %}
  {% endif %}
  {% if qtatot_diff2 > 0 %}
    {% set qty_dif_2 = (qtatot_diff2 > 0 ? '+' : '') ~ qtatot_diff2 %}
    {% set qty_tot_2 = qtatot_tot2 > 0 ? (qtatot_diff2 > 0 ? '+' : '') ~ ((qtatot_diff2 * 100) / qtatot_tot2)|currency ~ ' %' : '-' %}
  {% else %}
    {% set qty_dif_2 = '&nbsp;' %}
    {% set qty_tot_2 = '&nbsp;' %}
  {% endif %}
  {% if impnet_diff2 > 0 %}
    {% set val_dif_2 = (impnet_diff2 > 0 ? '+' : '') ~ impnet_diff2|currency %}
    {% set val_tot_2 = impnet_tot2 > 0 ? (impnet_diff2 > 0 ? '+' : '') ~ ((impnet_diff2 * 100) / (impnet_tot2 / 1000))|currency ~ ' %' : '-' %}
  {% else %}
    {% set val_dif_2 = '&nbsp;' %}
    {% set val_tot_2 = '&nbsp;' %}
  {% endif %}
  {% if ratio_diff2 > 0 %}
    {% set rat_dif_2 = (ratio_diff2 > 0 ? '+' : '') ~ ratio_diff2|currency %}
    {% set rat_tot_2 = ratio2 > 0 ? (ratio_diff2 > 0 ? '+' : '') ~ ((ratio_diff2 * 100) / ratio2)|currency ~ ' %' : '-' %}
  {% else %}
    {% set rat_dif_2 = '&nbsp;' %}
    {% set rat_tot_2 = '&nbsp;' %}
  {% endif %}

  {# Get styles and info for column 3 #}
  {% if time3 != "_none" and time3 != "" %}
    {% set qtatot_diff3 = qtatot_tot - qtatot_tot3 %}
    {% set impnet_diff3 = (impnet_tot - impnet_tot3) / 1000 %}
    {% set ratio3 = qtatot_tot3 > 0 ? impnet_tot3 / qtatot_tot3 : 0 %}
    {% set ratio_diff3 = ratio1 - ratio3 %}

    {% if max_qtatot > 0 %}
      {% set h_qty_3 = 400 * (qtatot_tot3 / max_qtatot) %}
      {% set mt_qty_3 = 400 - (400 * (qtatot_tot3 / max_qtatot)) %}
    {% else %}
      {% set h_qty_3 = 0 %}
      {% set mt_qty_3 = 0 %}
    {% endif %}
    {% if max_impnet > 0 %}
      {% set h_imp_3 = 400 * (impnet_tot3 / (1000 * max_impnet)) %}
      {% set mt_imp_3 = 400 - (400 * (impnet_tot3 / (1000 * max_impnet))) %}
    {% else %}
      {% set h_imp_3 = 0 %}
      {% set mt_imp_3 = 0 %}
    {% endif %}
    {% if max_ratio > 0 %}
      {% set h_rat_3 = 400 * (ratio3 / max_ratio) %}
      {% set mt_rat_3 = 400 - (400 * (ratio3 / max_ratio)) %}
    {% else %}
      {% set h_rat_3 = 0 %}
      {% set mt_rat_3 = 0 %}
    {% endif %}
    {% if qtatot_diff3 > 0 %}
      {% set qty_dif_3 = (qtatot_diff3 > 0 ? '+' : '') ~ qtatot_diff3 %}
      {% set qty_tot_3 = qtatot_tot3 > 0 ? (qtatot_diff3 > 0 ? '+' : '') ~ ((qtatot_diff3 * 100) / qtatot_tot3)|currency ~ ' %' : '-' %}
    {% else %}
      {% set qty_dif_3 = '&nbsp;' %}
      {% set qty_tot_3 = '&nbsp;' %}
    {% endif %}
    {% if impnet_diff3 > 0 %}
      {% set val_dif_3 = (impnet_diff3 > 0 ? '+' : '') ~ impnet_diff3|currency %}
      {% set val_tot_3 = impnet_tot3 > 0 ? (impnet_diff3 > 0 ? '+' : '') ~ ((impnet_diff3 * 100) / (impnet_tot3 / 1000))|currency ~ ' %' : '-' %}
    {% else %}
      {% set val_dif_3 = '&nbsp;' %}
      {% set val_tot_3 = '&nbsp;' %}
    {% endif %}
    {% if ratio_diff3 > 0 %}
      {% set rat_dif_3 = (ratio_diff3 > 0 ? '+' : '') ~ ratio_diff3|currency %}
      {% set rat_tot_3 = ratio3 > 0 ? (ratio_diff3 > 0 ? '+' : '') ~ ((ratio_diff3 * 100) / ratio3)|currency ~ ' %' : '-' %}
    {% else %}
      {% set rat_dif_3 = '&nbsp;' %}
      {% set rat_tot_3 = '&nbsp;' %}
    {% endif %}
  {% endif %}

  {% if max_qtatot > 0 %}
    {% set classTxtQty = 'graph-value-stats' %}
  {% else %}
    {% set classTxtQty = 'text-center' %}
  {% endif %}
  {% if max_impnet > 0 %}
    {% set classTxtVal = 'graph-value-stats' %}
  {% else %}
    {% set classTxtVal = 'text-center' %}
  {% endif %}
  {% if max_ratio > 0 %}
    {% set classTxtRat = 'graph-value-stats' %}
  {% else %}
    {% set classTxtRat = 'text-center' %}
  {% endif %}

{% endif %}

{% if multistats %}
    <!-- Nav Tabs -->
    <ul class="nav nav-tabs multi-nav-tabs" role="tablist">
      <li class="nav-item w-50"><a href="#tab_syn" role="tab" data-toggle="tab" class="active">{{ mt._('statistics.tab.synthesis') }}</a></li>
      <li class="nav-item w-50"><a href="#tab_det" role="tab" data-toggle="tab">{{ mt._('statistics.tab.detail') }}</a></li>
    </ul><!-- .nav-tabs -->
{% endif %}

    <!-- Tab panes -->
    <div class="col-12 {% if multistats %}tab-content{% endif %} account-info pt-10x pb-40x px-0">
      {% if multistats %}
      <div role="tabpanel" class="tab-pane fade show active w-100 mx-0" id="tab_syn">
        <div class="row m-0">
          <div class="col-4 mb-30x">
            <div class="title-column-stats">{{ mt._('statistics.graph.qtyperseason') }}</div>
            <div class="mt-10x">
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtQty }}">{{ qtatot_tot }}</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="column-graph-stats grad-time1" style="height:{{ h_qty_1 }}px;margin-top:{{ mt_qty_1 }}px"></div>
                <div class="footer-column-stats">{{ time1 }}</div>
              </div>
              {% if time2 != "_none" and time2 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtQty }}">{{ qtatot_tot2 }}</div>
                <div class="header-column-stats">{{ qty_dif_2 }}</div>
                <div class="header-column-stats">{{ qty_tot_2 }}</div>
                <div class="column-graph-stats grad-time2" style="height:{{ h_qty_2 }}px;margin-top:{{ mt_qty_2 }}px"></div>
                <div class="footer-column-stats">{{ time2 }}</div>
              </div>
              {% endif %}
              {% if time3 != "_none" and time3 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtQty }}">{{ qtatot_tot3 }}</div>
                <div class="header-column-stats">{{ qty_dif_3 }}</div>
                <div class="header-column-stats">{{ qty_tot_3 }}</div>
                <div class="column-graph-stats grad-time3" style="height:{{ h_qty_3 }}px;margin-top:{{ mt_qty_3 }}px"></div>
                <div class="footer-column-stats">{{ time3 }}</div>
              </div>
              {% endif %}
            </div>
          </div>
          <div class="col-4 mb-30x">
            <div class="title-column-stats">{{ mt._('statistics.graph.valperseason', {'currency': common['currency'] }) }}</div>
            <div class="mt-10x">
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtVal }}">{{ (impnet_tot / 1000)|currency }}</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="column-graph-stats grad-time1" style="height:{{ h_imp_1 }}px;margin-top:{{ mt_imp_1 }}px"></div>
                <div class="footer-column-stats">{{ time1 }}</div>
              </div>
              {% if time2 != "_none" and time2 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtVal }}">{{ (impnet_tot2 / 1000)|currency }}</div>
                <div class="header-column-stats">{{ val_dif_2 }}</div>
                <div class="header-column-stats">{{ val_tot_2 }}</div>
                <div class="column-graph-stats grad-time2" style="height:{{ h_imp_2 }}px;margin-top:{{ mt_imp_2 }}px"></div>
                <div class="footer-column-stats">{{ time2 }}</div>
              </div>
              {% endif %}
              {% if time3 != "_none" and time3 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtVal }}">{{ (impnet_tot3 / 1000)|currency }}</div>
                <div class="header-column-stats">{{ val_dif_3 }}</div>
                <div class="header-column-stats">{{ val_tot_3 }}</div>
                <div class="column-graph-stats grad-time3" style="height:{{ h_imp_3 }}px;margin-top:{{ mt_imp_3 }}px"></div>
                <div class="footer-column-stats">{{ time3 }}</div>
              </div>
              {% endif %}
            </div>
          </div>
          <div class="col-4 mb-30x">
            <div class="title-column-stats">{{ mt._('statistics.graph.avgartval', {'currency': common['currency'] }) }}</div>
            <div class="mt-10x">
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtRat }}">{{ ratio1|currency }}</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="header-column-stats">&nbsp;</div>
                <div class="column-graph-stats grad-time1" style="height:{{ h_rat_1 }}px;margin-top:{{ mt_rat_1 }}px"></div>
                <div class="footer-column-stats">{{ time1 }}</div>
              </div>
              {% if time2 != "_none" and time2 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtRat }}">{{ ratio2|currency }}</div>
                <div class="header-column-stats">{{ rat_dif_2 }}</div>
                <div class="header-column-stats">{{ rat_tot_2 }}</div>
                <div class="column-graph-stats grad-time2" style="height:{{ h_rat_2 }}px;margin-top:{{ mt_rat_2 }}px"></div>
                <div class="footer-column-stats">{{ time2 }}</div>
              </div>
              {% endif %}
              {% if time3 != "_none" and time3 != "" %}
              <div class="float-left" style="width:{{ column_width }}%">
                <div class="{{ classTxtRat }}">{{ ratio3|currency }}</div>
                <div class="header-column-stats">{{ rat_dif_3 }}</div>
                <div class="header-column-stats">{{ rat_tot_3 }}</div>
                <div class="column-graph-stats grad-time3" style="height:{{ h_rat_3 }}px;margin-top:{{ mt_rat_3 }}px"></div>
                <div class="footer-column-stats">{{ time3 }}</div>
              </div>
              {% endif %}
            </div>
          </div>
        </div>
        <div class="row" style="border-top:1px black solid;margin-top:-57px"></div>
      </div>
      {% endif %}

      <div class="mx-0 {{ multistats ? 'tab-pane fade' : '' }}" {{ multistats ? 'role="tabpanel"' : '' }} id="tab_det">
        <a id="pdf-stats" href="#" class="float-right text-uppercase mr-20x" style="margin-top:-70px;color:#606060">{{ mt._('_common.export') }}</a>
        <div class="total-detail-header">
          <div class="st-totr">{{ mt._('_common.totrows') }}: {{ stats|length }}</div>
          <div class="st-info"><a href="#" data-toggle='modal' data-target='.modal-info'>{{ mt._('_common.info') }}<i class="fa fa-info-circle" aria-hidden="true"></i></a></div>
      {% if not multistats %}
          <div class="st-sqty text-right">{{ qtatot_tot }}</div>
          <div class="st-simp text-right">{{ impnet_tot|currency }} {{ common['currency'] }}</div>
      {% else %}
        {% if time2 != '_none' and time2 != '' and time3 != '_none' and time3 != '' %}
          {% set classColQty = 'detail-tot-mlt-qty-3 pr-10x' %}
          {% set classColVal1 = 'detail-tot-mlt-imp-3 pr-10x' %}
          {% set classColVal2 = 'detail-tot-mlt-imp-3 pr-10x' %}
        {% else %}
          {% set classColQty = 'detail-tot-mlt-qty-2 pr-5x' %}
          {% set classColVal1 = 'detail-tot-mlt-imp-2 pr-5x' %}
          {% set classColVal2 = 'detail-tot-mlt-imp-2' %}
        {% endif %}

          <!-- Qty 1 -->
          <div class="{{ classColQty }}" style="border-left:1px solid #bbb">
            <div class="stats-hgt-sml">{{ qtatot_tot }}</div>
            <div class="stats-diff"></div>
            <div class="stats-diff"></div>
          </div>
          <!-- Qty 2 -->
          <div class="{{ classColQty }}">
            <div class="stats-hgt-sml {{ qtatot_diff2 > 0 ? 'col_ov' : 'col_un' }}">{{ qtatot_tot2 }}</div>
            <div class="stats-diff">{{ qty_dif_2 }}</div>
            <div class="stats-diff">{{ qty_tot_2 }}</div>
          </div>
        {% if time2 != '_none' and time2 != '' and time3 != '_none' and time3 != '' %}
          <!-- Qty 3 -->
          <div class="detail-tot-mlt-qty-3 pr-5x">
            <div class="stats-hgt-sml {{ qtatot_diff3 > 0 ? 'col_ov' : 'col_un' }}">{{ qtatot_tot3 }}</div>
            <div class="stats-diff">{{ qty_dif_3 }}</div>
            <div class="stats-diff">{{ qty_tot_3 }}</div>
          </div>
        {% endif %}
          <!-- Val 1 -->
          <div class="{{ classColVal1 }}" style="border-left:1px solid #bbb">
            <div class="stats-hgt-sml">{{ impnet_tot|currency }}</div>
            <div class="stats-diff"></div>
            <div class="stats-diff"></div>
          </div>
          <!-- Val 2 -->
          <div class="{{ classColVal2 }}">
            <div class="stats-hgt-sml {{ impnet_diff2 > 0 ? 'col_ov' : 'col_un' }}">{{ impnet_tot2|currency }}</div>
            <div class="stats-diff">{{ val_dif_2 }}</div>
            <div class="stats-diff">{{ val_tot_2 }}</div>
          </div>
        {% if time2 != '_none' and time2 != '' and time3 != '_none' and time3 != '' %}
          <!-- Val 3 -->
          <div class="detail-tot-mlt-imp-3">
            <div class="stats-hgt-sml {{ impnet_diff3 > 0 ? 'col_ov' : 'col_un' }}">{{ impnet_tot3|currency }}</div>
            <div class="stats-diff">{{ val_dif_3 }}</div>
            <div class="stats-diff">{{ val_tot_3 }}</div>
          </div>
        {% endif %}
      {% endif %}
        </div>

        <div class="detail-stats-header {{ not multistats ? 'stats-hgt-sml' : 'stats-hgt-big' }}">
        {% if typeStats == "group_01" %}
          <div class="st-01-c1">{{ mt._('statistics.group.modtype') }} <span id="mot-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mot-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_02" %}
          <div class="st-02-c1">{{ mt._('statistics.group.modtype') }} <span id="mot-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mot-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-02-c2">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-02-c3">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_03" %}
          <div class="st-03-c1">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-03-c2">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_04" %}
          <div class="st-04-c1">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-04-c2">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-04-c3">{{ mt._('_common.model') }} <span id="mod-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mod-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_05" %}
          <div class="st-05-c1">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-05-c2">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-05-c3">{{ mt._('_common.article') }} <span id="art-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="art-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_06" %}
          <div class="st-06-c1">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-06-c2">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-06-c3">{{ mt._('statistics.group.modtype') }} <span id="mot-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mot-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_07" %}
          <div class="st-07-c1">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-07-c2">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-07-c3">{{ mt._('_common.series') }} <span id="ser-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="ser-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_08" %}
          <div class="st-08-c1">{{ mt._('_common.customer') }} <span id="cus-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="cus-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_09" %}
          <div class="st-09-c1">{{ mt._('_common.customer') }} <span id="cus-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="cus-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-09-c2">{{ mt._('statistics.group.modtype') }} <span id="mot-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mot-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_10" %}
          <div class="st-10-c1">{{ mt._('_common.customer') }} <span id="cus-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="cus-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-10-c2">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-10-c3">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_11" %}
          <div class="st-11-c1">{{ mt._('_common.customer') }} <span id="cus-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="cus-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-11-c2">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-11-c3">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-11-c4">{{ mt._('_common.model') }} <span id="mod-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="mod-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% elseif typeStats == "group_12" %}
          <div class="st-12-c1">{{ mt._('_common.customer') }} <span id="cus-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="cus-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-12-c2">{{ mt._('_common.brand') }} <span id="brn-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="brn-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-12-c3">{{ mt._('_common.line') }} <span id="lin-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="lin-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-12-c4">{{ mt._('_common.article') }} <span id="art-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="art-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% endif %}

        {% if not multistats %}
          <div class="st-sqty text-right">{{ mt._('_common.quantity') }} <span id="qty-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="qty-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
          <div class="st-simp text-right">{{ mt._('_common.amount.net.short') }} ({{ common['currency'] }})<span id="imp-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="imp-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
        {% else %}
          {% if time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" %}
            {% set classCol1 = 'stats-time w-33 pr-5x' %}
            {% set classCol2 = 'stats-time w-33 pr-5x' %}
          {% else %}
            {% set classCol1 = 'stats-time w-50 pr-5x' %}
            {% set classCol2 = 'stats-time w-50' %}
          {% endif %}

          <!-- Quantity header -->
          <div class="st-sqty text-center pr-5x" style="border-left:1px solid #eee">
            <div class="w-100 stats-hgt-mid">{{ mt._('_common.quantity') }} <span id="qty-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="qty-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
            <div class="{{ classCol1 }}" title="{{ time1 }}">{{ mt._('_common.period') }} 1</div>
            <div class="{{ classCol2 }}" title="{{ time2 != '_none' and time2 != '' ? time2 : time3 }}">{{ mt._('_common.period') }} 2</div>
          {% if time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" %}
            <div class="stats-time w-33" title="{{ time3 }}">{{ mt._('_common.period') }} 3</div>
          {% endif %}
          </div>

          <!-- Value header -->
          <div class="st-simp text-center" style="border-left:1px solid #eee">
            <div class="w-100 stats-hgt-mid">{{ mt._('_common.amount.net.short') }} ({{ common['currency'] }})<span id="imp-up"><i class="fa fa-caret-up" aria-hidden="true"></i></span><span id="imp-down"><i class="fa fa-caret-down" aria-hidden="true"></i></span></div>
            <div class="{{ classCol1 }}" title="{{ time1 }}">{{ mt._('_common.period') }} 1</div>
            <div class="{{ classCol2 }}" title="{{ time2 != '_none' and time2 != '' ? time2 : time3 }}">{{ mt._('_common.period') }} 2</div>
          {% if time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" %}
            <div class="stats-time w-33" title="{{ time3 }}">{{ mt._('_common.period') }} 3</div>
          {% endif %}
          </div>
        {% endif %}

        </div>

        <div id="stat-rows" data-ordering="default" data-direction="default" style="overflow:hidden;white-space:nowrap">
        {% for stat in stats %}
          <div class="{{ not multistats ? 'stats-hgt-sml' : 'stats-hgt-big' }} stat-row px-20x fs11" style="border-bottom:1px #bbb solid">
          {% if not multistats %}
            {% if typeStats == "group_01" %}
            <div class="st-01-c1 mot stats-field">{{ stat["tipmod"] }}</div>
            {% elseif typeStats == "group_02" %}
            <div class="st-02-c1 mot stats-field">{{ stat["tipmod"] }}</div>
            <div class="st-02-c2 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-02-c3 lin stats-field">{{ stat["lineam"] }}</div>
            {% elseif typeStats == "group_03" %}
            <div class="st-03-c1 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-03-c2 lin stats-field">{{ stat["lineam"] }}</div>
            {% elseif typeStats == "group_04" %}
            <div class="st-04-c1 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-04-c2 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-04-c3 mod stats-field">{{ stat["codneu"] }} {{ stat["desneu"] }}</div>
            {% elseif typeStats == "group_05" %}
            <div class="st-05-c1 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-05-c2 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-05-c3 art stats-field">{{ stat["codart"] }} {{ stat["desart"] }}</div>
            {% elseif typeStats == "group_06" %}
            <div class="st-06-c1 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-06-c2 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-06-c3 mot stats-field">{{ stat["tipmod"] }}</div>
            {% elseif typeStats == "group_07" %}
            <div class="st-07-c1 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-07-c2 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-07-c3 ser stats-field">{{ stat["seriem"] }}</div>
            {% elseif typeStats == "group_08" %}
            <div class="st-08-c1 cus stats-field">{{ stat["ragsoc"] }} ({{ stat["codana"] }}), {{ stat["nazion"] }}</div>
            {% elseif typeStats == "group_09" %}
            <div class="st-09-c1 cus stats-field">{{ stat["ragsoc"] }} ({{ stat["codana"] }}), {{ stat["nazion"] }}</div>
            <div class="st-09-c2 mot stats-field">{{ stat["tipmod"] }}</div>
            {% elseif typeStats == "group_10" %}
            <div class="st-10-c1 cus stats-field">{{ stat["ragsoc"] }} ({{ stat["codana"] }}), {{ stat["nazion"] }}</div>
            <div class="st-10-c2 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-10-c3 lin stats-field">{{ stat["lineam"] }}</div>
            {% elseif typeStats == "group_11" %}
            <div class="st-11-c1 cus stats-field">{{ stat["ragsoc"] }} ({{ stat["codana"] }}), {{ stat["nazion"] }}</div>
            <div class="st-11-c2 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-11-c3 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-11-c4 mod stats-field">{{ stat["codneu"] }} {{ stat["desneu"] }}</div>
            {% elseif typeStats == "group_12" %}
            <div class="st-12-c1 cus stats-field">{{ stat["ragsoc"] }} ({{ stat["codana"] }}), {{ stat["nazion"] }}</div>
            <div class="st-12-c2 brn stats-field">{{ stat["titlin"] }}</div>
            <div class="st-12-c3 lin stats-field">{{ stat["lineam"] }}</div>
            <div class="st-12-c4 art stats-field">{{ stat["codart"] }} {{ stat["desart"] }}</div>
            {% endif %}
            <div class="st-sqty qty stats-field text-right" title="{{ stat['qtatot1'] }}">{{ stat["qtatot1"] }}</div>
            <div class="st-simp imp stats-field text-right" title="{{ stat['impnet1']|currency }}">{{ stat["impnet1"]|currency }}</div>
          {% else %}
            {% if typeStats == "group_01" %}
            <div class="st-01-c1 mot stats-field">{{ stat["mot"] }}</div>
            {% elseif typeStats == "group_02" %}
            <div class="st-02-c1 mot stats-field">{{ stat["mot"] }}</div>
            <div class="st-02-c2 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-02-c3 lin stats-field">{{ stat["lin"] }}</div>
            {% elseif typeStats == "group_03" %}
            <div class="st-03-c1 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-03-c2 lin stats-field">{{ stat["lin"] }}</div>
            {% elseif typeStats == "group_04" %}
            <div class="st-04-c1 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-04-c2 lin stats-field">{{ stat["lin"] }}</div>
            <div class="st-04-c3 mod stats-field">{{ stat["mod"] }}</div>
            {% elseif typeStats == "group_05" %}
            <div class="st-05-c1 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-05-c2 lin stats-field">{{ stat["lin"] }}</div>
            <div class="st-05-c3 art stats-field">{{ stat["art"] }}</div>
            {% elseif typeStats == "group_06" %}
            <div class="st-06-c1 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-06-c2 lin stats-field">{{ stat["lin"] }}</div>
            <div class="st-06-c3 mot stats-field">{{ stat["mot"] }}</div>
            {% elseif typeStats == "group_07" %}
            <div class="st-07-c1 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-07-c2 lin stats-field">{{ stat["lin"] }}</div>
            <div class="st-07-c3 ser stats-field">{{ stat["ser"] }}</div>
            {% elseif typeStats == "group_08" %}
            <div class="st-08-c1 cus stats-field">{{ stat["cus"] }}</div>
            {% elseif typeStats == "group_09" %}
            <div class="st-09-c1 cus stats-field">{{ stat["cus"] }}</div>
            <div class="st-09-c2 mot stats-field">{{ stat["mot"] }}</div>
            {% elseif typeStats == "group_10" %}
            <div class="st-10-c1 cus stats-field">{{ stat["cus"] }}</div>
            <div class="st-10-c2 brn stats-field">{{ stat["brn"] }}</div>
            <div class="st-10-c3 lin stats-field">{{ stat["lin"] }}</div>
            {% elseif typeStats == "group_11" %}
            <div class="st-11-c1 cus stats-field float-left">{{ stat["cus"] }}</div>
            <div class="st-11-c2 brn stats-field float-left">{{ stat["brn"] }}</div>
            <div class="st-11-c3 lin stats-field float-left">{{ stat["lin"] }}</div>
            <div class="st-11-c4 mod stats-field float-left">{{ stat["mod"] }}</div>
            {% elseif typeStats == "group_12" %}
            <div class="st-12-c1 cus stats-field float-left">{{ stat["cus"] }}</div>
            <div class="st-12-c2 brn stats-field float-left">{{ stat["brn"] }}</div>
            <div class="st-12-c3 lin stats-field float-left">{{ stat["lin"] }}</div>
            <div class="st-12-c4 art stats-field float-left">{{ stat["art"] }}</div>
            {% endif %}

            {% if stat["qty2"] is defined %}
              {% set statQty2 = stat["qty2"] %}
            {% elseif stat["qty3"] is defined %}
              {% set statQty2 = stat["qty3"] %}
            {% else %}
              {% set statQty2 = stat["qty1"] %}
            {% endif %}

            {% if stat["imp2"] is defined %}
              {% set statImp2 = stat["imp2"] %}
            {% elseif stat["imp3"] is defined %}
              {% set statImp2 = stat["imp3"] %}
            {% else %}
              {% set statImp2 = stat["imp1"] %}
            {% endif %}

            {% set stat_qtatot_diff2 = stat["qty1"] - statQty2 %}
            {% set stat_impnet_diff2 = stat["imp1"] - statImp2 %}
            {% set sts_qty_dif_2 = (stat_qtatot_diff2 > 0 ? '+' : '') ~ stat_qtatot_diff2 %}
            {% set sts_qty_tot_2 = stat["qty1"] > 0 and statQty2 > 0 ? (stat_qtatot_diff2 > 0 ? '+' : '') ~ ((stat_qtatot_diff2 * 100) / statQty2)|currency ~ ' %' : '-' %}
            {% set sts_val_dif_2 = (stat_impnet_diff2 > 0 ? '+' : '') ~ stat_impnet_diff2|currency %}
            {% set sts_val_tot_2 = stat["imp1"] > 0 and statImp2 > 0 ? (stat_impnet_diff2 > 0 ? '+' : '') ~ ((stat_impnet_diff2 * 100) / statImp2)|currency ~ ' %' : '-' %}

            {% if time3 != "_none" and time3 != "" %}
              {% set stat_impnet_diff3 = stat["imp1"] - stat["imp3"] %}
              {% set stat_qtatot_diff3 = stat["qty1"] - stat["qty3"] %}
              {% set sts_qty_dif_3 = (stat_qtatot_diff3 > 0 ? '+' : '') ~ stat_qtatot_diff3 %}
              {% set sts_qty_tot_3 = stat["qty1"] > 0 and stat["qty3"] > 0 ? (stat_qtatot_diff3 > 0 ? '+' : '') ~ ((stat_qtatot_diff3 * 100) / stat["qty3"])|currency ~ ' %' : '-' %}
              {% set sts_val_dif_3 = (stat_impnet_diff3 > 0 ? '+' : '') ~ stat_impnet_diff3|currency %}
              {% set sts_val_tot_3 = stat["imp1"] > 0 and stat["imp3"] > 0 ? (stat_impnet_diff3 > 0 ? '+' : '') ~ ((stat_impnet_diff3 * 100) / stat["qty3"])|currency ~ ' %' : '-' %}
            {% endif %}

            {% if stat_qtatot_diff2 > 0 %}
              {% set classDifQty2 = 'col_ov' %}
            {% elseif stat_qtatot_diff2 < 0 %}
              {% set classDifQty2 = 'col_un' %}
            {% else %}
              {% set classDifQty2 = 'col_nn' %}
            {% endif %}

            {% if stat_impnet_diff2 > 0 %}
              {% set classDifVal2 = 'col_ov' %}
            {% elseif stat_impnet_diff2 < 0 %}
              {% set classDifVal2 = 'col_un' %}
            {% else %}
              {% set classDifVal2 = 'col_nn' %}
            {% endif %}

            {% if stat_qtatot_diff3 > 0 %}
              {% set classDifQty3 = 'col_ov' %}
            {% elseif stat_qtatot_diff3 < 0 %}
              {% set classDifQty3 = 'col_un' %}
            {% else %}
              {% set classDifQty3 = 'col_nn' %}
            {% endif %}

            {% if stat_impnet_diff3 > 0 %}
              {% set classDifVal3 = 'col_ov' %}
            {% elseif stat_impnet_diff3 < 0 %}
              {% set classDifVal3 = 'col_un' %}
            {% else %}
              {% set classDifVal3 = 'col_nn' %}
            {% endif %}

            <div class="{{ classColQty }}" style="border-left:1px solid #bbb">
              <div class="stats-val qty stats-field" title="{{ stat['qty1'] }}">{{ stat['qty1'] }}</div>
              <div class="stats-diff"></div>
              <div class="stats-diff"></div>
            </div>
            <div class="{{ classColQty }}">
              <div class="stats-val qty2 {{ classDifQty2 }}">{{ statQty2 }}</div>
              <div class="stats-diff">{{ sts_qty_dif_2 }}</div>
              <div class="stats-diff">{{ sts_qty_tot_2 }}</div>
            </div>
            {% if time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" %}
            <div class="detail-tot-mlt-qty-3 pr-5x">
              <div class="stats-val qty3 {{ classDifQty3 }}">{{ stat["qty3"] }}</div>
              <div class="stats-diff">{{ sts_qty_dif_3 }}</div>
              <div class="stats-diff">{{ sts_qty_tot_3 }}</div>
            </div>
            {% endif %}
            <div class="{{ classColVal1 }}" style="border-left:1px solid #bbb">
              <div class="stats-val imp stats-field" title="{{ stat['imp1']|currency }}">{{ stat['imp1']|currency }}</div>
              <div class="stats-diff"></div>
              <div class="stats-diff"></div>
            </div>
            <div class="{{ classColVal2 }}">
              <div class="stats-val imp2 {{ classDifVal2 }}">{{ stat["imp2"]|currency }}</div>
              <div class="stats-diff">{{ sts_val_dif_2 }}</div>
              <div class="stats-diff">{{ sts_val_tot_2 }}</div>
            </div>
            {% if time2 != "_none" and time2 != "" and time3 != "_none" and time3 != "" %}
            <div class="detail-tot-mlt-imp-3">
              <div class="stats-val imp3 {{ classDifVal3 }}">{{ stat["imp3"]|currency }}</div>
              <div class="stats-diff">{{ sts_val_dif_3 }}</div>
              <div class="stats-diff">{{ sts_val_tot_3 }}</div>
            </div>
            {% endif %}
          {% endif %}
          </div>
        {% endfor %}
        </div>
      </div>
    </div>

  </div>
</div>
