<body class="login">
  <div>
    <div id="login_box">
      <div class="login_wrapper">

        <div class="animate form login_form">
          <div class="text-center mt-5x">{{ image("assets/img/logo_go_management.png", "class": "w-80", "alt": "Logo") }}</div>

          {% if superadmin_available or admin_available or support_available %}
          <section class="login_content">
            <form action="{{ url('session/register') }}" onbeforesubmit="return false" method="post">
              <h1>{{ mt._('session.register') }}</h1>
              <div>
                <label for="username" class="control-label">{{ mt._('session.register.username') }}</label>
                <input type="text" name="username" class="form-control" placeholder="{{ mt._('session.register.username') }}" required="" {% if username is defined %}value="{{ username }}"{% endif %}/>
              </div>
              <div>
                <label for="password" class="control-label">{{ mt._('session.register.password') }}</label>
                <input type="password" name="password" class="form-control" placeholder="{{ mt._('session.register.password') }}" required="" />
              </div>
              <div>
                <label for="repeatPassword" class="control-label">{{ mt._('session.register.confirmpassword') }}</label>
                <input type="password" name="repeatPassword" class="form-control" placeholder="{{ mt._('session.register.confirmpassword') }}" required="" />
              </div>
              {% if error is defined and error == 'password' %}
              <div class="text-danger pb-15x fs11" style="margin-top:-20px">{{ mt._('session.register.errorconfirm') }}</div>
              {% endif %}
              <div class="w-100">
                <div class="float-left w-70">
                  <label for="type" class="control-label float-left" style="margin-top:8px">{{ mt._('session.register.type') }}</label>
                  <select name="type" class="float-left w-50 pl-5x" style="height:32px;margin-left:9px">
                    {% if superadmin_available %}
                    <option value="1" {% if type is defined and type == 1 %}selected{% endif %}>{{ mt._('session.register.superadmin') }}</option>
                    {% endif %}
                    {% if admin_available %}
                    <option value="2" {% if type is defined and type == 2 %}selected{% endif %}>{{ mt._('session.register.admin') }}</option>
                    {% endif %}
                    {% if support_available %}
                    <option value="6" {% if type is defined and type == 6 %}selected{% endif %}>{{ mt._('session.register.support') }}</option>
                    {% endif %}
                  </select>
                </div>
                <div class="float-left w-30"><input type="submit" class="btn btn-main float-right m-0" value="{{ mt._('session.register') }}"/>
                {% if error is defined and error != 'password' %}
                <div class="text-danger pb-15x fs11" style="margin-top:-20px">{{ error }}</div>
                {% endif %}
              </div>

              <div class="clearfix"></div>
            </form>
          </section>
          {% else %}
          {{ mt._('session.register.warning') }}

          {% endif %}
        </div>
      </div>
    </div>

  </div>

  {% include "bottom_scripts.volt" %}

</body>
