<body class='login' {{ login_bg != '' ? 'style="background-image:url(../img/' ~ login_bg ~ ')"': '' }}>
<div class='font-weight-bold text-right w-100 p-10x' style='background-color:#eee'>
    <span class='request-access pointer'>{{ mt._('login.requestaccess') }}</span>
</div>
<div class='container' id='request-access-box' style="display:none">
    <div class='float-right text-center' style='width:200px;background-color:#ddd;'>
        <a href='#'
           class='request-access'>{{ image('assets/img/times.png', "class": "m-0-auto pointer p-5x", 'alt': mt._('_common.close')) }}</a>
    </div>
    <div class='w-100'
         style='clear:both;background-color:#ddd;font-size:14px!important;height:calc(100vh - 36px);overflow:auto;'>
        <div class='row m-0 pt-15x pb-5x'>
            <div class='col-12 font-weight-bold text-uppercase'>{{ mt._('login.requestregistration') }}</div>
        </div>
        <div class='row m-0 p-0-15x mb-30x'>
            <div class='col-12'>{{ mt._('login.requestregistration.text') }}</div>
        </div>
        <div class="row m-0 p-0">
            <div class="col-12">
                <div class="msg-error text-danger">{{ mt._('login.request.error') }}</div>
                <div class="msg-success text-success">{{ mt._('login.request.success') }}</div>
            </div>
        </div>

        <form id="registration-request-form" action="">
            <div class="registration-slider">
                <div class="slide active">
                    <div class="container">
                        <div class='row mx-20x mt-10x justify-content-between'>
                            <div></div>
                            <h4 class="text-center">{{ i18n._('login.ra.section.info') }}</h4>
                            <button type="button" class="btn btn-default next-step">
                                {{ i18n._('_common.next') }}
                                <i class="fa fa-arrow-right" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class='row m-0 pt-10x clear'>
                            <div class='col-12 col-xs-12'>
                                <div class='form-group login-field'>
                                    {% if 'businessname' in mandatoryFields %}
                                        <label for='businessname'>{{ mt._('account.customer.businessname') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('businessname', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='businessname'>{{ mt._('account.customer.businessname') }}</label>
                                        <div class='controls'>{{ text_field('businessname', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                                <div class='form-group login-field'>
                                    {% if 'signboard' in mandatoryFields %}
                                        <label for='signboard'>{{ mt._('account.customer.signboard') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('signboard', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='signboard'>{{ mt._('account.customer.signboard') }}</label>
                                        <div class='controls'>{{ text_field('signboard', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                        </div>
                        <div class='row m-0'>
                            <div class='col-12 col-xs-12'>
                                <div class='form-group login-field'>
                                    {% if 'vatcode' in mandatoryFields %}
                                        <label for='vatcode'>{{ mt._('account.customer.vatcode') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('vatcode', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='vatcode'>{{ mt._('account.customer.vatcode') }}</label>
                                        <div class='controls'>{{ text_field('vatcode', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                            <!-- 9.9.22 Marco -->
                            <div class='col-12 col-md-4'>
                                <div class='form-group login-field'>
                                    {% if 'sidcode' in mandatoryFields %}
                                        <label for='sidcode'>{{ mt._('account.customer.sidcode') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('sidcode', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='sidcode'>{{ mt._('account.customer.sidcode') }}</label>
                                        <div class='controls'>{{ text_field('sidcode', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>

                            <div class='col-12 col-md-8'>
                                <div class='form-group login-field'>
                                    {% if 'emailpec' in mandatoryFields %}
                                        <label for='emailpec'>{{ mt._('account.customer.pec') }} *</label>
                                        <div class='controls'>
                                            {{ email_field('emailpec', 'class': 'form-control') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.email') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='emailpec'>{{ mt._('account.customer.pec') }}</label>
                                        <div class='controls'>{{ email_field('emailpec', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                            <!-- 9.9.22-->
                        </div>
                        {% if useNewCustomerRef %}
                            <div class='row m-0'>
                                <div class='col-12'>
                                    <h5>{{ i18n._('account.customer.referent.main') }}</h5>
                                </div>
                                <div class='col-12 col-md-6'>
                                    <div class='form-group login-field'>
                                        {% if 'refname' in mandatoryFields %}
                                            <label for='refname'>{{ mt._('account.customer.refname') }} *</label>
                                            <div class='controls'>
                                                {{ text_field('refname', 'class': 'form-control', 'required': 'required') }}
                                                <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                            </div>
                                        {% else %}
                                            <label for='refname'>{{ mt._('account.customer.refname') }}</label>
                                            <div class='controls'>{{ text_field('refname', 'class': 'form-control') }}</div>
                                        {% endif %}
                                    </div>
                                </div>
                                <div class='col-12 col-md-6'>
                                    <div class='form-group login-field'>
                                        {% if 'refnote' in mandatoryFields %}
                                            <label for='refnote'>{{ mt._('account.customer.refnote') }} *</label>
                                            <div class='controls'>
                                                {{ text_field('refnote', 'class': 'form-control', 'required': 'required') }}
                                                <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                            </div>
                                        {% else %}
                                            <label for='refnote'>{{ mt._('account.customer.refnote') }}</label>
                                            <div class='controls'>{{ text_field('refnote', 'class': 'form-control') }}</div>
                                        {% endif %}
                                    </div>
                                </div>
                                <div class='col-12 col-md-6'>
                                    <div class='form-group login-field'>
                                        {% if 'refemail' in mandatoryFields %}
                                            <label for='refemail'>{{ mt._('account.customer.refemail') }} *</label>
                                            <div class='controls'>
                                                {{ email_field('refemail', 'class': 'form-control') }}
                                                <div class="invalid-feedback">{{ i18n._('_common.validation.email') }}</div>
                                            </div>
                                        {% else %}
                                            <label for='refemail'>{{ mt._('account.customer.refemail') }}</label>
                                            <div class='controls'>{{ email_field('refemail', 'class': 'form-control') }}</div>
                                        {% endif %}
                                    </div>
                                </div>
                                <div class='col-12 col-md-6'>
                                    <div class='form-group login-field'>
                                        {% if 'refntel' in mandatoryFields %}
                                            <label for='refntel'>{{ mt._('account.customer.refntel') }} *</label>
                                            <div class='controls'>
                                                {{ text_field('refntel', 'class': 'form-control', 'required': 'required') }}
                                                <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                            </div>
                                        {% else %}
                                            <label for='refntel'>{{ mt._('account.customer.refntel') }}</label>
                                            <div class='controls'>{{ text_field('refntel', 'class': 'form-control') }}</div>
                                        {% endif %}
                                    </div>
                                </div>
                            </div>
                        {% endif %}
                    </div><!-- ./container -->
                </div><!-- ./slide -->
                <div class="slide">
                    <div class="container">
                        <div class='row mx-20x mt-10x justify-content-between'>
                            <button type="button" class="btn btn-default prev-step">
                                <i class="fa fa-arrow-left" aria-hidden="true"></i>
                                {{ i18n._('_common.previous') }}
                            </button>
                            <h4 class="text-center">{{ i18n._('login.ra.section.address') }}</h4>
                            <button type="button" class="btn btn-default next-step">
                                {{ i18n._('_common.next') }}
                                <i class="fa fa-arrow-right" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class='row mx-0 mt-10x clear'>
                            <div class='col-12'>
                                <div class='form-group login-field'>
                                    {% if 'email' in mandatoryFields %}
                                        <label for='email'>Email *</label>
                                        <div class='controls'>
                                            {{ email_field('email', 'type': 'email', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.email') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='email'>Email</label>
                                        <div class='controls'>{{ email_field('email', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                                <div class='form-group login-field'>
                                    {% if 'telephone' in mandatoryFields %}
                                        <label for='telephone'>{{ mt._('account.customer.telephone') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('telephone', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='telephone'>{{ mt._('account.customer.telephone') }}</label>
                                        <div class='controls'>{{ text_field('telephone', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                        </div>
                        <div class='row m-0'>
                            <div class='col-12'>
                                <div class='form-group login-field'>
                                    {% if 'address' in mandatoryFields %}
                                        <label for='address'>{{ mt._('account.customer.address') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('address', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='address'>{{ mt._('account.customer.address') }}</label>
                                        <div class='controls'>{{ text_field('address', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                        </div>
                        <div class='row m-0'>
                            <div class='col-9'>
                                <div class='form-group login-field'>
                                    {% if 'city' in mandatoryFields %}
                                        <label for='city'>{{ mt._('account.customer.city') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('city', 'class': 'form-control', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='city'>{{ mt._('account.customer.city') }}</label>
                                        <div class='controls'>{{ text_field('city', 'class': 'form-control') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                            <div class='col-3'>
                                <div class='form-group login-field'>
                                    {% if 'cap' in mandatoryFields %}
                                        <label for='cap'>{{ mt._('account.customer.capzip') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('cap', 'class': 'form-control', 'required': 'required', 'minlength': '5', 'maxlength': '5') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='cap'>{{ mt._('account.customer.capzip') }}</label>
                                        <div class='controls'>{{ text_field('cap', 'class': 'form-control', 'minlength': '5', 'maxlength': '5') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                        </div>
                        <div class='row m-0'>
                            <div class='col-12'>
                                <div class='form-group login-field'>
                                    {% if 'country' in mandatoryFields %}
                                        <label for='country'>{{ mt._('account.customer.country') }} *</label>
                                        <div class='controls'>
                                            <select class='form-control' id='country' name='country' required>
                                                <option value=''></option>
                                                {% for ananaz in countries %}
                                                    <option value='{{ ananaz.cdnazi }}' {{ ananaz.cdnazi in ['i', 'I', 'it', 'IT', 'ita', 'ITA'] ? 'selected' : '' }}>{{ ananaz.dsnazi }}</option>
                                                {% endfor %}
                                            </select>
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='country'>{{ mt._('account.customer.country') }}</label>
                                        <div class='controls'>
                                            <select class='form-control' id='country' name='country'>
                                                <option value=''></option>
                                                {% for ananaz in countries %}
                                                    <option value='{{ ananaz.cdnazi }}' {{ ananaz.cdnazi in ['i', 'I', 'it', 'IT', 'ita', 'ITA'] ? 'selected' : '' }}>{{ ananaz.dsnazi }}</option>
                                                {% endfor %}
                                            </select>
                                        </div>
                                    {% endif %}
                                </div>
                                <div class='form-group login-field'>
                                    {% if 'province' in mandatoryFields %}
                                        <label for='province'>{{ mt._('account.customer.province') }} *</label>
                                        <div class='controls'>
                                            <select class='form-control' id='province' name='province' required>
                                                <option value=''></option>
                                                {% for anaprov in provinces %}
                                                    <option value='{{ anaprov.cdprov }}'>{{ anaprov.dsprov }}</option>
                                                {% endfor %}
                                            </select>
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='province'>{{ mt._('account.customer.province') }}</label>
                                        <div class='controls'>
                                            <select class='form-control' id='province' name='province'>
                                                <option value=''></option>
                                                {% for anaprov in provinces %}
                                                    <option value='{{ anaprov.cdprov }}'>{{ anaprov.dsprov }}</option>
                                                {% endfor %}
                                            </select>
                                        </div>
                                    {% endif %}
                                </div>
                            </div>
                        </div>
                    </div><!-- ./container -->
                </div><!-- ./slide -->
                <div class="slide">
                    <div class="container">
                        <div class='row mx-20x mt-10x justify-content-between'>
                            <button type="button" class="btn btn-default prev-step">
                                <i class="fa fa-arrow-left" aria-hidden="true"></i>
                                {{ i18n._('_common.previous') }}
                            </button>
                            <h4 class="text-center">{{ i18n._('login.ra.section.destinations') }}</h4>
                            <button type="button" id="request-access-btn" class="btn btn-success">
                                {{ mt._('login.sendrequest') }}
                            </button>
                        </div>
                        <div class='row mx-0 mt-10x clear destination-template' data-count="1">
                            <div class='col-12'>
                                <h5 class="destination-title">
                                    {{ i18n._('_common.destination') }} <span
                                            class="var">{{ i18n._('_common.primary') }}</span>
                                    <button type="button" class="btn btn-sm copy-from-business ml-10x">
                                        <i class="fa fa-magic" aria-hidden="true"></i>
                                        {{ i18n._('login.ra.action.copyaddress') }}
                                    </button>
                                </h5>
                            </div>
                            <div class='col-12'>
                                <div class='form-group login-field'>
                                    <label for='desragsoc1'>{{ mt._('account.customer.businessname') }} *</label>
                                    <div class='controls'>
                                        {{ text_field('desragsoc1', 'class': 'form-control control-businessname', 'required': 'required') }}
                                        <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                    </div>
                                </div>
                                <div class='form-group login-field'>
                                    {% if 'address' in mandatoryFields %}
                                        <label for='desindi1'>{{ mt._('account.customer.address') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('desindi1', 'class': 'form-control control-address', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='desindi1'>{{ mt._('account.customer.address') }}</label>
                                        <div class='controls'>{{ text_field('desindi1', 'class': 'form-control control-address') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                            <div class='col-9'>
                                <div class='form-group login-field'>
                                    {% if 'city' in mandatoryFields %}
                                        <label for='descitta1'>{{ mt._('account.customer.city') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('descitta1', 'class': 'form-control control-city', 'required': 'required') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='descitta1'>{{ mt._('account.customer.city') }}</label>
                                        <div class='controls'>{{ text_field('descitta1', 'class': 'form-control control-city') }}</div>
                                    {% endif %}
                                </div>
                            </div>
                            <div class='col-3'>
                                <div class='form-group login-field'>
                                    {% if 'cap' in mandatoryFields %}
                                        <label for='descap1'>{{ mt._('account.customer.capzip') }} *</label>
                                        <div class='controls'>
                                            {{ text_field('descap1', 'class': 'form-control control-cap', 'required': 'required', 'minlength': '5', 'maxlength': '5') }}
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='descap1'>{{ mt._('account.customer.capzip') }}</label>
                                        <div class='controls'>{{ text_field('descap1', 'class': 'form-control control-cap', 'minlength': '5', 'maxlength': '5') }}</div>
                                    {% endif %}

                                </div>
                            </div>
                            <div class='col-12'>
                                <div class='form-group login-field'>
                                    {% if 'country' in mandatoryFields %}
                                        <label for='desdsnazi1'>{{ mt._('account.customer.country') }} *</label>
                                        <div class='controls'>
                                            <select class='form-control control-country' id='desdsnazi1'
                                                    name='desdsnazi1' required>
                                                <option value=''></option>
                                                {% for ananaz in countries %}
                                                    <option value='{{ ananaz.cdnazi }}' {{ ananaz.cdnazi in ['i', 'I', 'it', 'IT', 'ita', 'ITA'] ? 'selected' : '' }}>{{ ananaz.dsnazi }}</option>
                                                {% endfor %}
                                            </select>
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='desdsnazi1'>{{ mt._('account.customer.country') }}</label>
                                        <div class='controls'>
                                            <select class='form-control control-country' id='desdsnazi1'
                                                    name='desdsnazi1'>
                                                <option value=''></option>
                                                {% for ananaz in countries %}
                                                    <option value='{{ ananaz.cdnazi }}' {{ ananaz.cdnazi in ['i', 'I', 'it', 'IT', 'ita', 'ITA'] ? 'selected' : '' }}>{{ ananaz.dsnazi }}</option>
                                                {% endfor %}
                                            </select>
                                        </div>
                                    {% endif %}
                                </div>
                                <div class='form-group login-field'>
                                    {% if 'province' in mandatoryFields %}
                                        <label for='desprov1'>{{ mt._('account.customer.province') }} *</label>
                                        <div class='controls'>
                                            <select class='form-control control-province' id='desprov1' name='desprov1'
                                                    required>
                                                <option value=''></option>
                                                {% for anaprov in provinces %}
                                                    <option value='{{ anaprov.cdprov }}'>{{ anaprov.dsprov }}</option>
                                                {% endfor %}
                                            </select>
                                            <div class="invalid-feedback">{{ i18n._('_common.validation.required') }}</div>
                                        </div>
                                    {% else %}
                                        <label for='desprov1'>{{ mt._('account.customer.province') }}</label>
                                        <div class='controls'>
                                            <select class='form-control control-province' id='desprov1' name='desprov1'>
                                                <option value=''></option>
                                                {% for anaprov in provinces %}
                                                    <option value='{{ anaprov.cdprov }}'>{{ anaprov.dsprov }}</option>
                                                {% endfor %}
                                            </select>
                                        </div>
                                    {% endif %}
                                </div>
                                <hr/>
                            </div>
                        </div>
                        <div class='row'>
                            <div class='col-12 text-center'>
                                <button type="button" id="add-destination" class="btn btn-sm btn-info">
                                    {{ i18n._('login.ra.action.adddestination') }}
                                </button>
                            </div>
                        </div>
                    </div><!-- ./container -->
                </div><!-- ./slide -->
            </div>
        </form>
    </div>
</div>

<div class='container mw-100'>
    {{ form('session/start', 'role': 'form') }}
    <div class='row m-0 p-10x' style='background-color:white'>
        <div class='col-12 col-lg-6'>{{ image(logoimg != '' ? 'img/' ~ logoimg : 'assets/img/logo_home.jpg', 'alt': 'Logo') }}</div>
        <div class='col-12 col-lg-6'>
            <div class='row'>
                <div class='col-6'><a href='#' class='hiddenanchor' id='signup'></a></div>
                <div class='col-6'><a href='#' class='hiddenanchor' id='signin'></a></div>
            </div>
            <div class='row'>
                <div class='col-6 form-group p-15x'>
                    <label for='username'>Username</label>
                    <div class='controls'>{{ text_field('username', 'class': 'form-control') }}</div>
                </div>
                <div class='col-6 form-group p-15x'>
                    <label for='password'>Password</label>
                    <div class='controls'>{{ password_field('password', 'class': 'form-control') }}</div>
                </div>
            </div>
            <div class='row'>
                <div class='col-6'>
                    <input type='hidden' id='country' name='country' value="{{ session.get('language') }}"/>

                    {% set lang_selected = "" %}
                    {% if session.get('language') == 'it' %}{% set lang_selected = "Italiano" %}{% endif %}
                    {% if session.get('language') == 'en' %}{% set lang_selected = "English" %}{% endif %}
                    {% if session.get('language') == 'de' %}{% set lang_selected = "Deutsch" %}{% endif %}
                    {% if session.get('language') == 'es' %}{% set lang_selected = "Español" %}{% endif %}
                    {% if session.get('language') == 'fr' %}{% set lang_selected = "Français" %}{% endif %}
                    <div class='menu-icon lang-switcher'>
                        <div class='lang-toggle'>
                            <span title='{{ mt._("_common.header.changelanguage") }}'>{{ lang_selected }}</span>
                            <i class='material-icons arrow_drop_down'></i>
                            <ul class='lang-dropdown'>
                                {{ (session.get('language') != 'it'
                                ? "<li>
                        <div class='float-left' style='margin-right:2px'>" ~ image('assets/img/it.png', 'style': 'margin: 0 auto') ~ "</div>
                        <div class='float-left'><a href='#' class='change-language' data-lang='it'>Italiano</a></div>
                      </li>"
                                : "") }}
                                {{ (session.get('language') != 'en'
                                ? "<li>
                        <div class='float-left' style='margin-right:2px'>" ~ image('assets/img/en.png', 'style': 'margin: 0 auto') ~ "</div>
                        <div class='float-left'><a href='#' class='change-language' data-lang='en'>English</a></div>
                      </li>"
                                : "") }}
                                {{ (session.get('language') != 'de'
                                ? "<li>
                        <div class='float-left' style='margin-right:2px'>" ~ image('assets/img/de.png', 'style': 'margin: 0 auto') ~ "</div>
                        <div class='float-left'><a href='#' class='change-language' data-lang='de'>Deutsch</a></div>
                      </li>"
                                : "") }}
                                {{ (session.get('language') != 'es'
                                ? "<li>
                        <div class='float-left' style='margin-right:2px'>" ~ image('assets/img/es.png', 'style': 'margin: 0 auto') ~ "</div>
                        <div class='float-left'><a href='#' class='change-language' data-lang='es'>Español</a></div>
                      </li>"
                                : "") }}
                                {{ (session.get('language') != 'fr'
                                ? "<li>
                        <div class='float-left' style='margin-right:2px'>" ~ image('assets/img/fr.png', 'style': 'margin: 0 auto') ~ "</div>
                        <div class='float-left'><a href='#' class='change-language' data-lang='fr'>Français</a></div>
                      </li>"
                                : "") }}
                            </ul>
                        </div>
                    </div>
                </div>
                <div class='col-6 text-right'>{{ submit_button('Login', 'class': 'btn btn-main submit mr-0') }}</div>
            </div>
        </div>
        </form>
    </div>
</div>

<div class="container mt-3">
    <!-- Direct -->
    {{ flash.output() }}
    <!-- Session -->
    {{ flashSession.output() }}
</div>

{% include 'bottom_scripts.volt' %}

</body>
