<!-- DropZone -->
{{ stylesheet_link("vendors/dropzone/dist/min/dropzone.min.css") }}
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}

{{ javascript_include("js/custom.js") }}
<script>
    let cdtick = {{ ticket.cdtick }};
    let loadingMessages = false;
    const intervalData = {
        'intervalId': null,
        'opened': {{ ticket.cdstat < 4 ? 'true' : 'false' }}
    };
    let currentAttachments = [];

    $(window).load(function () {
        startChatInterval({{ ticket.cdstat < 4 ? 'true' : 'false' }});
        addChatEvent();
        $(".support-chat").animate({scrollTop: $(".support-chat").prop("scrollHeight")}, 1000);
    });

    function sendChatMessage() {
        const message = $('#text-new-message').val().trim();
        if (message !== '') {
            $('#new-message :input').prop("disabled", true).attr("disabled", true);
            $.ajax({
                url: '/support/sendchat',
                type: 'POST',
                dataType: 'json',
                data: {
                    message,
                    cdtick,
                    attachments: currentAttachments,
                },
                success: (data) => {
                    if (data['status'] == 'OK') {
                        $('#text-new-message').val('');
                        // $('#new-message').before(data['html']);
                        $('#ticket-last-update').text(data['update']);
                        $(".support-chat").animate({scrollTop: $('.support-chat').prop("scrollHeight")}, 1000);
                        // Rimuovo i riferimento agli allegati precedentemente caricati
                        currentAttachments = [];
                        $('#new-message-attachments .dz-preview').remove();
                        $('#new-message-attachments').removeClass('dz-started').collapse('hide');
                        // Ricarichiamo subito la chat per ottenere il messaggio inviato
                        getChat();
                    } else {
                        $('#new-message').before(data['html']);
                    }
                },
                complete: () => {
                    $('#new-message :input').prop("disabled", false).attr("disabled", false);
                }
            });
        }
    }

    function getChat() {
        if (!loadingMessages) {
            loadingMessages = true;
            const msg_count = $('.support-chat .message').length;
            $.ajax({
                url: '/support/getchat',
                type: 'POST',
                dataType: 'json',
                data: {
                    msg_count,
                    cdtick
                },
                success: (data) => {
                    console.log(data);
                    if (data.hasOwnProperty('error') || data.cdtick !== cdtick) {

                    } else {
                        // Se necessario avviamo/modifichiamo l'interval a seconda dello stato aperto/chiuso
                        startChatInterval(data.opened);
                        if (data.messages && data.messages.length > 0) {
                            $("#new-message").before(data.messages.join());
                            $(".support-chat").animate({scrollTop: $(".support-chat").prop("scrollHeight")}, 1000);
                        }

                        $('#ticket-status').text(data.statusDesc);
                        $('#ticket-last-update').text(data.update);
                        if (data.opened && data.editable) {
                            $('#new-message :input').prop('disabled', false).attr('disabled', false);
                        } else {
                            $('#new-message :input').prop('disabled', true).attr('disabled', true);
                        }
                    }
                },
                complete: () => loadingMessages = false
            });
        }

    }

    function startChatInterval(opened) {
        if (opened !== intervalData.opened) {
            clearInterval(intervalData.intervalId);
            intervalData.intervalId = null;
        }

        if (intervalData.intervalId == null) {
            intervalData.intervalId = setInterval(function () {
                getChat();
            }, opened ? 5000 : 60000);
            intervalData.opened = opened;
        }
    }

    function addChatEvent() {
        $('#text-new-message').keypress(function (e) {
            if (e.which == 13 && !e.shiftKey) {
                sendChatMessage();
            }
        });
        $('#send-new-message').click(function () {
            sendChatMessage();
        });
    }

    Dropzone.options.newMessageAttachments = {
        acceptedFiles: 'image/*,application/pdf',
        dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles') }}",
        dictRemoveFile: "{{ mt._('_common.remove') }}",
        dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
        sending: function (file, xhr, formData) {
            // console.log('sending', file, formData);
            formData.append('cdtick', cdtick);
            $('#new-message button').prop("disabled", true).attr("disabled", true);
        },
        queuecomplete: function (data) {
            $('#new-message button').prop("disabled", false).attr("disabled", false);
            // console.log('queuecomplete', data);
        },
        success: function (file, response, event) {
            const res = JSON.parse(response);
            console.log(res);
            if (res.hasOwnProperty('fileInfo')) {
                currentAttachments.push(res.fileInfo);
            } else {
                alert(res.error ?? '{{ mt._('_common.generic.db.error')|escape }}');
            }
        },
        addRemoveLinks: true,
        maxFiles: 5,
        removedfile: function (file) {
            var _ref; // Remove file on clicking the 'Remove file' button
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
        }
    }

    function showSave() {
        $('#save_current_status').show();
    }

    function saveState() {
        const state = $('#current_status').val();
        $.ajax({
            url: '/support/updatestate',
            type: 'POST',
            data: {
                cdtick: {{ ticket.cdtick }},
                cdstat: state
            },
            success: (data) => {
                if (data == 'OK') {
                    $('#save_current_status').hide();
                    $('#status_save_check').show();
                    setTimeout(() => $('#status_save_check').hide(), 2000);
                }
            }
        });
    }
</script>
