<script>
    $('body').on('change', '.table-ban', function (e) {
        const select = $(e.currentTarget);
        const value = parseInt(select.val()) || 0;
        const cdanag = select.data("cdanag");
        const currInfo = select.closest("tr[data-cdanag='" + cdanag + "']");

        if (value === 0) {
            select.removeClass("disabled").addClass("enabled");
        } else {
            select.removeClass("enabled").addClass("disabled");
        }

        select.prop('disabled', true);
        $.ajax({
            type: 'POST',
            url: "{{ url('admin/modifyStatus') }}",
            dataType: 'json',
            data: {
                cdanag,
                value,
            }
        }).done(function (data) {
            console.log(data);
            currInfo.data('cdblco', value);
            select.prop('disabled', false);
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
            select.prop('disabled', false);
        });
    });

    $('body').on('change', '.table-status', function (e) {
        const select = $(e.currentTarget);
        const idusr = select.data("idusr");
        const type = select.data("type");
        const enabled = parseInt(select.val()) || 0;
        const currInfo = select.closest("tr[data-idusr='" + idusr + "']");

        // senza parseInt non funziona la comparazione sotto
        let currLicenses = parseInt($("#current-licenses").text());
        let totLicenses = parseInt($("#total-licenses").text());

        if (type !== 'enabled' || (enabled === 0 || currLicenses < totLicenses)) {
            if (enabled === 0) {
                select.removeClass("enabled").addClass("disabled");
            } else {
                select.removeClass("disabled").addClass("enabled");
            }

            select.prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/modifyLoginStatus') }}",
                dataType: 'json',
                data: {
                    idusr,
                    type,
                    enabled,
                }
            }).done(function (data) {
                if (type == 'orders_enabled') {
                    currInfo.data("ordersenabled", enabled);
                } else {
                    currInfo.data("enable", enabled);
                }

                $("#current-licenses").text(data.licenses);
                $("#total-licenses").text(data.total_licenses);

                if (data.licenses < data.total_licenses) {
                    $("#licenses-info").removeClass('limit-licenses-reached');
                } else {
                    $("#licenses-info").addClass('limit-licenses-reached');
                }
                select.prop('disabled', false);
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
                select.prop('disabled', false);
            });
        } else if (enabled === 1) {
            select.val(0);
            select.removeClass("enabled").addClass("disabled");
            showMessageTemporary("#login-enabled-error-" + idusr, "{{ mt._('_common.form.licenseslimitreached') }}", 10000);
        }
    });
    $('#bulk-update').click(function (e) {
        e.preventDefault();

        var i = 0;
        var idusrs = new Array();
        $("input[name='status-checkbox[]']:checked").each(function () {
            var currElement = $(this).closest("tr").find(".table-status");
            if (currElement.val() == 0) {
                idusrs.push($(this).val());
            }
        });

        var currLicenses = $("#current-licenses").html();
        var totLicenses = $("#total-licenses").html();

        if ((parseInt(currLicenses) + parseInt(idusrs.length)) > totLicenses) {
            showMessageTemporary("#bulk-error", "{{ mt._('_common.bulkenableerror') }}", 10000);
        } else {
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/bulkstatus') }}",
                dataType: 'json',
                data: {
                    idusrs: idusrs,
                    enable: 1,
                }
            }).done(function (data) {
                location.reload();
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        }
    });

   /*$('#bulk-enable').click(function (e) {
        e.preventDefault();

        var i = 0;
        var idusrs = new Array();
        $("input[name='status-checkbox[]']:checked").each(function () {
            var currElement = $(this).closest("tr").find(".table-status");
            if (currElement.val() == 0) {
                idusrs.push($(this).val());
            }
        });

        var currLicenses = $("#current-licenses").html();
        var totLicenses = $("#total-licenses").html();

        if ((parseInt(currLicenses) + parseInt(idusrs.length)) > totLicenses) {
            showMessageTemporary("#bulk-error", "{{ mt._('_common.bulkenableerror') }}", 10000);
        } else {
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/bulkstatus') }}",
                dataType: 'json',
                data: {
                    idusrs: idusrs,
                    enable: 1,
                }
            }).done(function (data) {
                location.reload();
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        }
    });
    $('#bulk-disable').click(function (e) {
        e.preventDefault();

        var i = 0;
        var idusrs = new Array();
        $("input[name='status-checkbox[]']:checked").each(function () {
            var currElement = $(this).closest("tr").find(".table-status");
            if (currElement.val() == 1) {
                idusrs.push($(this).val());
            }
        });

        $.ajax({
            type: 'POST',
            url: "{{ url('admin/bulkstatus') }}",
            dataType: 'json',
            data: {
                idusrs: idusrs,
                enable: 0,
            }
        }).done(function (data) {
            location.reload();
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
        });
    });*/
    $('#modal-edit-password').change(function () {
        if ($(this).is(":checked")) {
            $('#modal-password-box').hide();
            $('#modal-repeatpassword-box').hide();
        } else {
            $('#modal-password-box').show();
            $('#modal-repeatpassword-box').show();
        }
    });
    $('.modal-login-status').change(function (e) {
        const select = $(e.currentTarget);
        const idusr = select.data("idusr");
        const type = select.data("type");
        const enabled = parseInt(select.val()) || 0;
        // senza parseInt non funziona la camparazione sotto
        let currLicenses = parseInt($("#current-licenses").text());
        let totLicenses = parseInt($("#total-licenses").text());

        if (type !== 'enabled' || (enabled === 0 || currLicenses < totLicenses)) {
            if (enabled === 0) {
                select.removeClass("enabled").addClass("disabled");
            } else {
                select.removeClass("disabled").addClass("enabled");
            }
        } else if (enabled === 1) {
            select.val(0);
            select.removeClass("enabled").addClass("disabled");
            showMessageTemporary("#modal-login-enabled-error", "{{ mt._('_common.form.licenseslimitreached') }}", 10000);
        }
    });

    $('body').on('change', '.modal-bulk-ban-status, .modal-bulk-login-status, .modal-bulk-create-status, .modal-ban-status', function (e) {
        const select = $(e.currentTarget);
        const selected = select.find('option:selected');
        select.removeClass("text-muted enabled disabled").addClass(selected.prop('class'));
    });
</script>
