
$('#visual-mode').on('click', '.btn-quick-shop', function(e){
  e.preventDefault();
  $('#image-and-colors').html('');
  $('#modal-fast-buy-content').html('');
  var parent = $(this).closest('.model-box');
  $('.modal-fast-buy .modal-title').html(parent.data('code') + ' - ' + parent.data('descr'));

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/loadQuickShop') }}",
		dataType: "json",
		data: {
      cdartn: parent.data('code'),
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      $('#image-and-colors').html(data['imageAndColorsHtml']);
      $('#modal-fast-buy-content').html(data['insertQuantityHtml']);
      $('.small-model-color-picker:first').click();
    } else {
      $('#image-and-colors').html('');
      $('#modal-fast-buy-content').html('');
    }

    {% if common['modelDetailStyle'] == 8 %}
    $('#fast-buy-articles-container').hide();
    {% endif %}

    $('.modal-fast-buy').modal('show');
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
$('.modal-fast-buy .modal-content .modal-body').on('click', '.small-model-color-picker', function(){
  var id = $(this).data('id');
  if ($(this).hasClass('selected')) {

    $(this).removeClass('selected');

    $('.color-selected').html("");

    $('.model-gallery').show();
    $('.article-gallery').hide();
    $('.article-gallery .big_article_image').prop('src', '');
    $('.article-gallery .big_article_image').prop('alt', '');

    $('#modal-fast-buy-content').html('');
  } else {
    $('.small-model-color-picker').removeClass('selected');
    $(this).addClass('selected');

    var cdcolo = $(this).data('cdcolo');
    var dscolo = $(this).data('dscolo');
    if (cdcolo != '' && dscolo != '') {
      $('.color-selected').html(cdcolo + " - " + dscolo);
    } else if (cdcolo != '') {
      $('.color-selected').html(cdcolo);
    } else if (dscolo != '') {
      $('.color-selected').html(dscolo);
    }

    $('.model-gallery').hide();
    $('.article-gallery').show();
    $('.article-gallery .big_article_image').prop('src', $(this).data('flimag'));
    $('.article-gallery .big_article_image').prop('alt', $(this).data('dsarti'));

    updateSizesFromColor();
  }
});
function updateSizesFromColor() {
	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/getSizesFromColor') }}",
		dataType: "json",
		data: {
      cdarti: $('.small-model-color-picker.selected').data('cdarti'),
      cdcolo: $('.small-model-color-picker.selected').data('cdcolo'),
      cdtagl: $('.small-model-color-picker.selected').data('cdtagl'),
      tppers: $('.small-model-color-picker.selected').data('tppers'),
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      $('#modal-fast-buy-content').html(data['html_modal']);
    } else {
      $('#model-fast-buy-content').html('');
    }
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
}
$(".modal-fast-buy .modal-content").on('click', '#add-to-cart-modal', function(e){
  e.preventDefault();
	var header = {{ common['modelDetailStyle'] == 6 or common['modelDetailStyle'] == 7 or common['modelDetailStyle'] == 8
    ? "$(this).closest('.insert-quantity-block').find('.header-insert-block')"
    : "$(this).closest('.insert-quantity-block').find('.header-insert-table')" }};
  var nuordc = "{{ common['order_info'].nuordc }}";
	var nurorc = header.data('nurorc');
	var cdarti = $('.small-model-color-picker.selected').data("cdarti");
	var cdcolo = $('.small-model-color-picker.selected').data("cdcolo");
  var cdcata = "{{ common['order_info'].cdcata }}";
  var quanti = 0;
  var seqdet = 0;
  var dtmcli = header.data('dtmcli');
  var sgrifc = header.data('sgrifc');
  var indorc = header.data('indorc');
  var dsnoco = $('#dsnoco-info').val();

  var success = $('.modal-fast-buy .modal-content .success-box');
  var error = $('.modal-fast-buy .modal-content .unsuccess-box');
  success.hide();
  error.hide()

  var octagl = [];
  $(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-size').each(function(){
    var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
    quanti += curr_quanti;
    octagl.push([
      $(this).data('taglia'),
      $(this).data('prezzo'),
      curr_quanti,
      $(this).data('sconto'),
    ]);
  });

  var ocasso = [];
  $(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-asso').each(function(){
    var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
    quanti += (curr_quanti * $(this).data("qtasso"));
    ocasso.push([
      $(this).data('cdasso'),
      curr_quanti
    ]);
  });

  $.ajax({
    type: "POST",
    url: "{{ url('model/ajax/saveOrderRow') }}",
    dataType: "json",
    data: {
      nuordc: nuordc,
      nurorc: nurorc,
      cdarti: cdarti,
      cdcolo: cdcolo,
      cdvari: '',
      cdcata: cdcata,
      quanti: quanti,
      seqdet: seqdet,
      dtmcli: dtmcli,
      sgrifc: sgrifc,
      indorc: indorc,
      dsnoco: dsnoco,
      octagl: octagl,
      ocasso: ocasso
    }
  }).done(function(data) {
    if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
      header.data('nurorc', data['nurorc']);

      $('.modal-fast-buy .modal-content .insert-quantity-row.is-size').each(function(){
        var quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
        var taglia = $(this).data('taglia');
        $('.color-size[data-taglia="' + taglia + '"]').data('quanti', quanti);
      });
      $('.modal-fast-buy .modal-content .insert-quantity-row.is-asso').each(function(){
        var quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
        var cdasso = $(this).data('cdasso');
        $('.color-size[data-cdasso="' + cdasso + '"]').data('quanti', quanti);
      });
      updateShoppingBag(data['tot']);
    }
    {% if common['closeQtyModal'] %}
    $('.modal-fast-buy').modal('hide');
    {% else %}
    success.fadeIn();
    setTimeout( function(){
      success.fadeOut();
    }, 10000 );
    {% endif %}
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
    error.fadeIn();
    setTimeout( function(){
      error.fadeOut();
    }, 10000 );
  });
});

{% set btn_target = '.modal-fast-buy .modal-content' %}
{% include 'scripts/common/qty_btn.volt' %}
