<script>
var barcodeInfo = {
	"insertFromBarcodeUrl": "{{ url('catalog/insertFromBarcode') }}",
};
</script>
{{ javascript_include("js/custom/common_barcode.js") }}

<script>
var indexRow = 1;
//region Input insertion
$(".modal-barcode-bulk .modal-body").on('click', '.btn-number', function(e) {
  e.preventDefault();

  var type   	= $(this).attr('data-type');
  var parent 	= $(this).closest('.brcd-lst-ava-qty,.brcd-lst-res-qty');
  var input		= parent.find("input");
  var disp  	= parent.data("disp");
  var qtamin  = parent.data("qtamin");
  var qtamul  = parent.data("qtamul");

  var currentVal = input.val() != '' ? parseInt(input.val()) : 0;
  // disp == -1 when it's reservation order
  if ($(this).hasClass("enabled") && !isNaN(currentVal)) {
	  if (type == 'minus' && (input.prop('min') == '' || currentVal > input.prop('min'))) {
      if (disp != -1) {
        if (currentVal > disp) {
          // qty was over the max
          {% if common['breakregqta'] == 1 %}
          input.val(disp == 0 ? '' : disp).change();
          {% else %}
          input.val(disp < qtamin ? '' : disp - ((disp - qtamin) % qtamul)).change();
          {% endif %}
        } else {
          {% if common['breakregqta'] == 1 %}
          if (currentVal == disp) {
            var valueFill = (currentVal - qtamin) % qtamul;
            if (valueFill == 0) {
              input.val(currentVal - qtamul >= qtamin ? currentVal - qtamul : '').change();
            } else {
              input.val(currentVal - valueFill).change();
            }
          } else {
            input.val(currentVal - qtamul >= qtamin ? currentVal - qtamul : '').change();
          }
          {% else %}
          if (currentVal == qtamin) {
            input.val('').change();
          } else {
            input.val(currentVal - qtamul >= qtamin ? currentVal - qtamul : '').change();
          }
          {% endif %}
        }
      } else {
        if (currentVal - qtamul < qtamin) {
          input.val(currentVal - qtamul > 0 ? qtamin : '').change();
        } else {
          input.val(currentVal - qtamul).change();
        }
      }
	  } else if (type == 'plus' && (input.prop('max') == '' || currentVal < input.prop('max'))) {
		  if (disp != -1) {
        if (currentVal < qtamin) {
          if (qtamin <= disp) {
            input.val(parseInt(qtamin)).change();
				  }
          {% if common['breakregqta'] == 1 %}
          else {
            // allow to order all available qty
            input.val(parseInt(disp)).change();
          }
          {% endif %}
			  } else {
          if (currentVal + qtamul <= disp) {
            input.val(parseInt(currentVal) + parseInt(qtamul)).change();
          }
          {% if common['breakregqta'] == 1 %}
          else {
            // allow to order all available qty
            input.val(parseInt(disp)).change();
          }
          {% endif %}
        }
      } else {
        input.val((currentVal < qtamin) ? parseInt(qtamin) : parseInt(currentVal) + parseInt(qtamul)).change();
      }
    }
  }

  if (input.val() < $(this).prop('max')) {
	  $(this).removeClass("over-max");
  }
});
$(".modal-barcode-bulk .modal-body").on('focusin', '.input-number', function() {
  $(this).data('old_value', $(this).val());
});
$(".modal-barcode-bulk .modal-body").on('change', '.input-number', function() {
  if ($(this).val() == 0) {
  	$(this).val("");
  }

  valueCurrent = $(this).val() != '' ? parseInt($(this).val()) : 0;
  var parent 	= $(this).closest('.brcd-lst-ava-qty,.brcd-lst-res-qty');
  var min_btn	= parent.find(".minus-qty");
  var plu_btn	= parent.find(".plus-qty");
  var input		= parent.find("input");
  var disp  	= parent.data("disp");
  var qtamin  = parent.data("qtamin");
  var qtamul  = parent.data("qtamul");

  // Set to old value, if:
  // - Current value between 0 and qtamin
  // - Current value greater than qtamin and current value - qtamin not multiple of qtamul
  // - Current value greater than availability (if availability order -> disp != -1)
  if ((valueCurrent > input.attr('min') && valueCurrent < qtamin) ||
      {% if common['breakregqta'] == 0 %}
      (valueCurrent > qtamin && ((valueCurrent - qtamin) % qtamul != 0)) ||
      {% else %}
      (valueCurrent > qtamin && valueCurrent != input.attr('max') && ((valueCurrent - qtamin) % qtamul != 0)) ||
      {% endif %}
  		(disp != -1 && valueCurrent > disp)) {
  	$(this).val($(this).data('old_value'));
  } else {
    $(this).data('old_value', $(this).val());
  }

  if (parseInt(input.val()) == input.attr('min') || input.val() == '') {
  	min_btn.addClass('disabled');
  	min_btn.removeClass('enabled');
  } else {
  	min_btn.addClass('enabled');
  	min_btn.removeClass('disabled');
  }

  if (parseInt(input.val()) == input.attr('max')
      {% if common['breakregqta'] == 0 %}
      || (parseInt(input.val()) + qtamul) > input.attr('max')
      || (disp != -1 && disp < qtamin)
      {% endif %}
  ) {
  	plu_btn.addClass('disabled');
  	plu_btn.removeClass('enabled');
  } else {
  	plu_btn.addClass('enabled');
  	plu_btn.removeClass('disabled');
  }
  if (input.val() < $(this).prop('max')) {
  	$(this).removeClass("over-max");
  }
  checkModNotSaved();
});
$(".modal-barcode-bulk .modal-body").on('keydown', '.input-number', function (e) {
  // Allow: backspace, delete, tab, escape, enter and .
  {% if router.getControllerName() == "model" %}
  if ($.inArray(e.keyCode, [46, 8, 9, 27, 190]) !== -1 ||
  {% else %}
  if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
  {% endif %}
  	// Allow: Ctrl+A
    (e.keyCode == 65 && e.ctrlKey === true) ||
    // Allow: home, end, left, right
    (e.keyCode >= 35 && e.keyCode <= 39)) {
    // let it happen, don't do anything
    return;
  }

  {% if router.getControllerName() == "model" %}
  if (e.keyCode == 13) {
    console.log('enter');
  }
  {% endif %}

  // Ensure that it is a number and stop the keypress
  if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
  	e.preventDefault();
  }
});
function checkModNotSaved() {
  $('.modal-barcode-bulk .msg-mod-not-saved').hide();
  $('.modal-barcode-bulk .row-barcode-list').each(function(){
    if ($(this).data('qty') != $(this).find('.input-number').val()) {
      $('.modal-barcode-bulk .msg-mod-not-saved').show();
    }
  });
}
//endregion

function findBarcode(barcode, type) {
  $(".msg-error").hide();
  $(".msg-success").hide();
  if (type == 'bulk') {
    if ($('#brcd-' + barcode).length == 0) {
      $.ajax({
        type: "POST",
        url: "{{ url('catalog/findbarcode') }}",
        dataType: "json",
        data: {
          barcode: barcode,
          index: indexRow
        },
      }).done(function(data){
        if (data['response'] == 'NF') {
          showTemporary("#not-found-bulk", 2000);
        } else {
          showTemporary("#success-bulk", 2000);
          indexRow++;
          $('#brcd-bulk-list').append(data['html']);
        }
      }).error(function(x, t, m) {
    		printAjaxError(x, t, m);
        showTemporary("#not-found-bulk", 2000);
      });
    } else {
      showTemporary("#already-present-bulk", 2000);
      var oldBckgColor = $("#brcd-" + barcode).css('background-color');
      $("#brcd-" + barcode).css('background-color', 'rgba(255,255,0,0.5)');
      setTimeout( function(){
        $("#brcd-" + barcode).css('background-color', oldBckgColor);
      }, 2000 );
    }
  } else {
    $.ajax({
      type: "POST",
      url: "{{ url('catalog/getarticlefrombarcode') }}",
      dataType: "json",
      data: {
        barcode: barcode,
      },
    }).done(function(data){
      if (data['response'] == 'OK') {
        if (data['cdpers'] != '' && data['cdcolo'] != '') {
          location.href = "{{ url('model') }}/" + data['cdartn'] + "/" + data['cdpers'] + "/" + data['cdcolo'];
        } else {
          location.href = "{{ url('model') }}/" + data['cdartn'];
        }
      }
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
      showTemporary("#not-found-bulk", 2000);
    });
  }
}
</script>
