<script>
$(document).ready(function(){
  $.ajax({
    type: "POST",
    url: "{{ url('cart/getPromoDetail') }}",
    dataType: "json",
    data: {
      cdprom: "{{ promo.cdprom }}",
      nuordc: "{{ common['order_info'].nuordc }}",
    }
  }).done(function(data) {
    if (data["response"] == "OK") {
      switch(data["type"]) {
      case "OT":
      case "SL":
        // not implemented
        break;
      case "CA":
        $('#promo-detail').html(data["html"]);
        break;
      case "OC":
      case "DN":
        // not needed
        break;
      }
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('.add-to-cart').click(function(e){
	e.preventDefault();

  if ($('.over-max').length > 0) {
    $('.over-max').closest('.insert-quantity-row').addClass('promo-row-error');
		setTimeout( function(){
      $('.over-max').closest('.insert-quantity-row').removeClass('promo-row-error');
		}, 5000 );
  } else {
    var nuordc = "{{ common['order_info'].nuordc }}";

    var occorp = [];
    $('.insert-quantity-row').each(function(){
      var quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0;
      occorp.push({
        'nuordc': nuordc,
        'nurorc': $(this).data('nurorc'),
        'cdarti': $(this).data('cdarti'),
        'cdcolo': $(this).data('cdcolo'),
        'cdcata': "{{ common['order_info'].cdcata }}",
        'quanti': quanti,
        'seqdet': 1,
        'dtmcli': "{{ common['order_info'].dtmcli_n }}",
        'octagl': {
          'taglia': $(this).data('taglia'),
          'prezzo': $(this).data('prezzo'),
          'quanti': quanti
        }
      });
    });

    $.ajax({
      type: "POST",
      url: "{{ url('cart/saverowsfrompromo') }}",
      dataType: "json",
      data: {
        occorp: occorp
      }
    }).done(function(data) {
      window.location.reload();
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});

{% set btn_target = '#promo-detail' %}
{% include 'scripts/common/qty_btn.volt' %}

</script>
