{% include "scripts/common/barcode.volt" %}

<script>
var jsInfo = {
	"orderNuordc": {{ nuordc }},
	"currentNuordc": {{ common['order_info'].nuordc }},
	"totPrice": {{ global_prc_tot }},
	"cdcata": "{{ common['order_info'].cdcata }}",
	"modelDetailStyle": {{ common['modelDetailStyle'] }},
	"isMultipleInsertEnabled": {{ common['multipleInsert'] == 1 ? 'true' : 'false' }},
	"changeViewDropText": "{{ mt._('_common.budget.changeview.drop') }}",
	"changeViewLineText": "{{ mt._('_common.budget.changeview.line') }}",

	"getOrderRowInfoUrl": "{{ url('cart/getOrderRowInfo') }}",
	"updateOrderRowInfoUrl": "{{ url('cart/updateOrderRowInfo') }}",
	"applyCouponUrl": "{{ url('cart/applyCoupon') }}",
	"removeCouponUrl": "{{ url('cart/removeCoupon') }}",
	"applyDiscountsUrl": "{{ url('cart/applyDiscounts') }}",
	"deleteCartRowsWithNoQuantityUrl": "{{ url('cart/deleteCartRowsWithNoQuantity') }}",
	"getCurrentArticleUrl": "{{ url('model/ajax/getCurrentArticle') }}",
	"getBulkInsertModalUrl": "{{ url('cart/getBulkInsertModal') }}",
	"saveBulkQuantityUrl": "{{ url('cart/saveBulkQuantity') }}",
	"getBudgetUrl": "{{ url('cart/getBudget') }}",
	"toggleDiscountsUrl": "{{ url('cart/toggleDiscounts') }}",

	"budgetAvailable": {{ common['isOrder'] and common['budgetManagement'] > 0 and common['budget']['line']|length > 0 and common['budget']['drop']|length > 0 ? 'true' : 'false' }},
	"language": "{{ session.get('language') }}",
	"showRowDelivery": {{ common['showRowDelivery'] }},
	"showRowIndicative": {{ common['showRowIndicative'] }},
	"showRowNotes": {{ common['showRowNotes'] }},
	"showRowReference": {{ common['showRowReference'] }},
	"couponPromo": {{ common['coupon_promo'] }},
	"genericSuccessMsg": "{{ mt._('_common.generic.db.success')|escape_js }}",
	"genericErrorMsg": "{{ mt._('_common.generic.db.error')|escape_js }}",
	"cartErrors": {
		"LE1": "{{ mt._('cart.error.limit.qtamin', ['value': common['cart_limit_min_value']])|escape_js }}",
		"LE2": "{{ mt._('cart.error.limit.spendmin', ['value': common['cart_limit_min_value']])|escape_js }}",
	}
};
</script>
{{ javascript_include("js/cart.js") }}

<script>
$(document).ready(function(){
	$('[data-toggle="tooltip"]').tooltip();
	{# Proviamo a metterli sempre #}
	checkTppagaPreagg();
	checkTpportPreagg();
	{#{% if nuordc < 0 %}
	checkTppagaPreagg();
	checkTpportPreagg();
	{% endif %}#}
  $('#paypal-button-container').hide();
  $('#stripe-button-container').hide();

	$('#cart-list-text-filter + input[type="image"]').on('click', filterArticleListRow);
	$('#cart-list-text-filter').on('input', filterArticleListRow);
	$('#cart-list-qty-filter').on('change', filterArticleListRow);
});

function filterArticleListRow(e) {
	// console.log('filterArticleListRow', e);
	const text = $('#cart-list-text-filter').val();
	const type = parseInt($('#cart-list-qty-filter').val());
	if (text === '' && type === -1) {
		$('.cart-list-row, .cart-list-row-under').show();
	} else {
		$('.cart-list-row').each((idx, el) => {
			const $el = $(el);
			const elQuanti = parseInt($el.data('quanti'));
			let textSearch = text === '';
			if (!textSearch) {
				textSearch = !textSearch;
				const textPcs = text.split(' ');
				for (let i = 0; i < textPcs.length; i++) {
					textSearch = textSearch && $el.data('search').includes(textPcs[i].toLowerCase());
				}
			}

			if (textSearch && (type < 0 || elQuanti === type || (type > 0 && type < elQuanti))) {
				$el.show().next('.cart-list-row-under').addClass('d-block').removeClass('d-none');
			} else {
				$el.hide().next('.cart-list-row-under').removeClass('d-block').addClass('d-none');
			}
		});
	}
}

//region Payment, Shipping
function checkTppagaPreagg() {
	var basePrice = $('#cart-final-total').data('base-price');
	if ($('#custom-shi').is(':visible')) {
		basePrice += $('#custom-shi-preagg').data('preagg');
	}
	$('#cart-final-total').data('total', basePrice);

	// Check custom payment
	if ($('input[name="tppaga_radio"]:checked').data('preagg') > 0) {
		var total = parseFloat(basePrice + $('input[name="tppaga_radio"]:checked').data('preagg'));
		// Add preagg to total
		$('#cart-final-total').html(parseFloat(basePrice + $('input[name="tppaga_radio"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#cart-final-total').data('total', total);
		$('#custom-pay').show();
		$('#custom-pay-dspaga').html($('input[name="tppaga_radio"]:checked').data('dspaga'));
		$('#custom-pay-preagg').html(parseFloat($('input[name="tppaga_radio"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#custom-pay-preagg').data("preagg", $('input[name="tppaga_radio"]:checked').data('preagg'));
	} else {
		// Reset total
		$('#cart-final-total').html(parseFloat(basePrice).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#cart-final-total').data('total', parseFloat(basePrice));
		$('#custom-pay-dspaga').html('');
		$('#custom-pay-preagg').html('');
		$('#custom-pay-preagg').data("preagg", 0);
		$('#custom-pay').hide();
	}
	{% if nuordc < 0 and stripe %}
	updateStripeValue();
	{% endif %}
}

function checkTpportPreagg() {
	var basePrice = $('#cart-final-total').data('base-price');
	if ($('#custom-pay').is(':visible')) {
		basePrice += $('#custom-pay-preagg').data('preagg');
	}

	// Check custom shipment
	if ($('input[name="tpport_radio"]:checked').data('preagg') > 0) {
		var total = parseFloat(basePrice + $('input[name="tpport_radio"]:checked').data('preagg'));
		// Add preagg to total
		$('#cart-final-total').html(total.formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#cart-final-total').data('total', total);
		$('#custom-shi').show();
		$('#custom-shi-dstpor').html($('input[name="tpport_radio"]:checked').data('dstpor'));
		$('#custom-shi-preagg').html(parseFloat($('input[name="tpport_radio"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#custom-shi-preagg').data("preagg", $('input[name="tpport_radio"]:checked').data('preagg'));
	} else {
		// Reset total
		$('#cart-final-total').html(parseFloat(basePrice).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
		$('#cart-final-total').data('total', parseFloat(basePrice));
		$('#custom-shi-dstpor').html('');
		$('#custom-shi-preagg').html('');
		$('#custom-shi-preagg').data("preagg", 0);
		$('#custom-shi').hide();
	}
	{% if nuordc < 0 and stripe %}
	updateStripeValue();
	{% endif %}
}

{% if nuordc < 0 %}

//region Insert quantity scripts
{% set btn_target = '#modal-cart-insert-quantity .modal-body' %}
{% include 'scripts/common/qty_btn.volt' %}

$("#modal-cart-insert-quantity .modal-body").on('click', '.add-to-cart', function(e){
	e.preventDefault();
	var nuordc = "{{ common['order_info'].nuordc }}";
  var cdarti = $("#modal-cart-insert-quantity .modal-body .header-modal-list").data("cdarti");
  var cdcolo = $("#modal-cart-insert-quantity .modal-body .header-modal-list").data("cdcolo");
	var cdcata = "{{ common['order_info'].cdcata }}";

{% if common['modelDetailStyle'] != 5 %}
	var header = $(this).closest('.insert-quantity-block').find('.header-insert-block');
	var nurorc = header.data('nurorc');
	var cdvari = header.data('cdvari');
	var quanti = 0;
	var seqdet = header.prop('id').replace("row-", "");
  {% if common['order_info'].tpordc == 0 or (articles|length > 0 and articles[0]['tppers'] == "PT") %}
  var dtmcli = header.data('dtmcli');
  {% else %}
  var dtmcli = header.find('.dtmcli').val();
  {% endif %}
	var sgrifc = header.data('sgrifc');
	var indorc = header.data('indorc');
	var dsnoco = header.find('.dsnoco-info').val();
{% else %}
	var nurorc = $('#modify-modal-nurorc').val();
	var cdvari = '';
	var quanti = 0;
	var seqdet = 0;
  var dtmcli = '0000-00-00';
	var sgrifc = '';
	var indorc = '';
	var dsnoco = '';
{% endif %}

	var success = $(this).closest('.insert-quantity-block').find('.success-box');
	var error = $(this).closest('.insert-quantity-block').find('.unsuccess-box');
	error.find('span').html("{{ mt._('quantity.insert.unsuccess') }}");
	success.hide();
	error.hide();

	var octagl = [];
	$(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-size').each(function(){
		var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
		quanti += curr_quanti;
		octagl.push([
			$(this).data('taglia'),
			$(this).data('prezzo'),
			curr_quanti,
			$(this).data('sconto')
		]);
	});

	var ocasso = [];
	$(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-asso').each(function(){
		var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
		quanti += (curr_quanti * $(this).data("qtasso"));
		ocasso.push([
			$(this).data('cdasso'),
			curr_quanti
		]);
	});

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/saveOrderRow') }}",
		dataType: "json",
		data: {
			nuordc: nuordc,
			nurorc: nurorc,
			cdarti: cdarti,
			cdcolo: cdcolo,
			cdvari: cdvari,
			cdcata: cdcata,
			quanti: quanti,
			seqdet: seqdet,
			dtmcli: dtmcli,
			sgrifc: sgrifc,
			indorc: indorc,
			dsnoco: dsnoco,
			octagl: octagl,
			ocasso: ocasso
		}
	}).done(function(data) {
		if (data['response'] == 'RM') {
			error.find('span').html("{{ mt._('quantity.warning.regqtm.bis') }}");
			error.find('span.min').html(data['min']);
			error.find('span.mul').html(data['mul']);
		  error.fadeIn();
		  setTimeout( function(){
		  	error.fadeOut();
		  }, 10000 );
		} else {
			if (data['response'] != 'OC' && data['response'] != 'DT' && data['response'] != 'NT' && data['response'] != 'OA') {
				window.location.reload();
			}
		}
	}).error(function(x, t, m) {
		error.fadeIn();
		setTimeout( function(){
			error.fadeOut();
		}, 10000 );
		printAjaxError(x, t, m);
	});
});

{% if articles|length > 0 and articles[0]['tppers'] != "PT" and
	((common['order_info'].tpordc == 0 and (common['dateTypeAvaOrder'] == 2 or common['dateTypeAvaOrder'] == 3)) or
	 (common['order_info'].tpordc == 1 and (common['dateTypeResOrder'] == 2 or common['dateTypeResOrder'] == 3))) %}
$("#modal-cart-insert-quantity .modal-body").on('change', ".dtmcli", function() {
	var index = $(this).data("index");
	var value = $(this).val();
	$("#row-" + index).data("dtmcli", value);
});
{% endif %}
$("#modal-cart-insert-quantity .modal-body").on('click', ".btn-add-delete", function(){
	var id = $(this).prop('id');
	$(this).hide();
	switch (id) {
	case 'btn-add-1':
		$("#row-2").closest(".insert-quantity-block").show();
		$("html, body").animate({ scrollTop: $('#row-2').offset().top - 180}, 1000, function(){
			$("#btn-add-2").show();
			$("#btn-delete-2").show();
		});
		break;
	case 'btn-add-2':
		$("#row-3").closest(".insert-quantity-block").show();
		$("html, body").animate({ scrollTop: $('#row-3').offset().top - 180}, 1000, function(){
			$("#btn-delete-2").hide();
			$("#btn-add-3").show();
		});
		break;
	case 'btn-delete-2':
		$("#btn-add-1").show();
		var block = $(this).closest(".insert-quantity-block");
		$("html, body").animate({ scrollTop: $('#row-1').offset().top - 180}, 1000, function(){
			block.hide();
		});
	  break;
	case 'btn-delete-3':
		$("#btn-add-2").show();
		$("#btn-delete-2").show();
		var block = $(this).closest(".insert-quantity-block");
		$("html, body").animate({ scrollTop: $('#row-2').offset().top - 180}, 1000, function(){
			block.hide();
		});
		break;
	}
});

$('.empty-row').click(function(e){
  e.preventDefault();

	var nurorc = $(this).closest(".row-cart-btn").data("nurorc");

  var qtyToRemove = $(this).closest('.cart-list-row').find('.qty').html();
  var totalQty = $('#footer-tot-qty').html();
  var grsToRemove = $(this).closest('.cart-list-row').find('.gross-total').html();
  grsToRemove = grsToRemove.substring(0, grsToRemove.length - 2);
  var totalGrs = $('#footer-tot-grs').html();
  totalGrs = totalGrs.substring(0, totalGrs.length - 2);
  var netToRemove = $(this).closest('.cart-list-row').find('.net-total').html();
  netToRemove = netToRemove.substring(0, netToRemove.length - 2);
  var totalNet = $('#footer-tot-net').html();
  totalNet = totalNet.substring(0, totalNet.length - 2);

  $(this).closest('.cart-list-row').find('.cart-size-box').html("&nbsp;");
  $(this).closest('.cart-list-row').find('.qty').html("0");
  $(this).closest('.cart-list-row').find('.gross-total').html("0,00 {{ common['currency'] }}");
  $(this).closest('.cart-list-row').find('.net-total').html("0,00 {{ common['currency'] }}");
  $('#footer-tot-qty').html(parseInt(totalQty) - parseInt(qtyToRemove));
  $('#footer-tot-grs').html((parseFloat(totalGrs) - parseFloat(grsToRemove)).toFixed(2).toLocaleString().replace(".",",").replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1.") + " {{ common['currency'] }}");
  $('#footer-tot-net').html((parseFloat(totalNet) - parseFloat(netToRemove)).toFixed(2).toLocaleString().replace(".",",").replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1.") + " {{ common['currency'] }}");

  $.ajax({
    type: "POST",
    url: "{{ url('cart/emptyorderrow') }}",
    dataType: "json",
    data: {
      nurorc: nurorc,
      nuordc: {{ common['order_info'].nuordc }},
    }
  }).done(function(data) {
	{% if common['coupon_promo'] == 2 and promos|length > 0 %}
		window.location.reload();
	{% endif %}
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('.delete-row[data-target=".modal-delete-row-order"]').click(function(e){
  $("#warning-delete-row").show();
  $('.confirm-delete-row').show();
  $("#error-delete-row").hide();

	var nurorc = $(this).closest(".row-cart-btn").data("nurorc");

  if ($('.cart-list-row').length > 1) {
    $('#nurorc-to-delete').html(nurorc);
  } else {
    $("#warning-delete-row").hide();
    $('.confirm-delete-row').hide();
    $("#error-delete-row").show();
  }
});
$('.confirm-delete-row').click(function(e){
  var nurorc = $('#nurorc-to-delete').html();
  e.preventDefault();

  $.ajax({
    type: "POST",
    url: "{{ url('cart/deleteorderrow') }}",
    dataType: "json",
    data: {
			nurorc: nurorc,
      nuordc: {{ common['order_info'].nuordc }},
    }
  }).done(function(data) {
    if (data == "OK") {
			window.location.reload();
		}
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
//endregion

//region Payment
{% if common['paypal'] == 1 %}
function setCreditCardPayment() {
  if (
			($('input[name="tppaga_radio"]').length > 0 && $('input[name="tppaga_radio"]:checked').val() == "payp") ||
			($('input[name="tppaga_radio_mobile"]').length > 0 && $('input[name="tppaga_radio_mobile"]:checked').val() == "payp")
		) {
    $('#save-order').closest('.btn-close').hide();
    $('#send-order').closest('.btn-close').hide();
    $('#send-error').hide();
		if (checkAvailabilityError()) {
			$('#paypal-stripe-error').show();
			$('#paypal-button-container').hide();
			$('#stripe-button-container').hide();
		} else {
			$('#paypal-stripe-error').hide();
			$('#paypal-button-container').show();
			$('#stripe-button-container').hide();
			loadPaypal();
		}
  } else if (
			($('input[name="tppaga_radio"]').length > 0 && $('input[name="tppaga_radio"]:checked').val() == "stri") ||
			($('input[name="tppaga_radio_mobile"]').length > 0 && $('input[name="tppaga_radio_mobile"]:checked').val() == "stri")
		) {
    $('#save-order').closest('.btn-close').hide();
    $('#send-order').closest('.btn-close').hide();
    $('#send-error').hide();
    $('#paypal-button-container').hide();
    $('#stripe-button-container').show();
		if (checkAvailabilityError()) {
			$('#paypal-stripe-error').show();
			$('#paypal-button-container').hide();
			$('#stripe-button-container').hide();
		} else {
			$('#paypal-stripe-error').hide();
			$('#paypal-button-container').hide();
			$('#stripe-button-container').show();
		}
  } else {
    $('#save-order').closest('.btn-close').show();
    $('#send-order').closest('.btn-close').show();
    $('#paypal-button-container').hide();
    $('#stripe-button-container').hide();
  }
}
function loadPaypal() {
	$('#paypal-loading').show();
	$('#paypal-checkout').hide();

	var tax = $('#footer-tax').data('tax');
	var add = parseFloat($('#custom-pay-preagg').data('preagg')) + parseFloat($('#custom-shi-preagg').data('preagg'));

	$.ajax({
		type: 'POST',
		url: "{{ url('cart/loadPaypal') }}",
		dataType: 'json',
		data: {
			tax: tax,
			add: add
		}
	}).done(function(data) {
		$('#paypal-loading').hide();
		$('#paypal-checkout').show();
		$('#paypal-checkout').attr('href', data);
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
}
{% endif %}
//endregion

{% if stripe %}
function updateStripeValue() {
	var total = Math.round(parseFloat($('#cart-final-total').data('total')) * 100);
	$('#amount').val(total);
	$('#stripe-script').data('amount', total);
	var stripeString = "<input type='hidden' name='amount' id='amount' value='" + total + "'/>";
	stripeString += "<script id='stripe-script' src='https://checkout.stripe.com/checkout.js' class='stripe-button' data-key='{{ pub_key }}' ";
	stripeString += "data-amount='" + total + "' data-name='{{ common['company'] }}' ";
	stripeString += "data-description='{{ articles|length }} {{ articles|length > 1 ? mt._('_common.article') : mt._('_common.articles') }} ";
	stripeString += "({{ mt._('cart.header.quantity') }}: {{ global_qty_total }})'  ";
	stripeString += "data-image='https://stripe.com/img/documentation/checkout/marketplace.png' ";
	stripeString += "data-locale='auto' data-zip-code='true' data-currency='{{ common['order_info'].cdvalu }}'><\/script>";
	$('#stripe-button-container form').html(stripeString);
}
{% endif %}

// Link desktop radio to mobile radio
{#
$('input[name="tppaga_radio"]').change(function(){
	var value = $(this).val();
	{% if common['paypal'] == 1 %}
	setCreditCardPayment();
	{% endif %}
	checkTppagaPreagg();
	$('input[name="tppaga_radio_mobile"] option[value="' + value + '"]').prop('selected','selected');
});
$('input[name="tpport_radio"]').change(function(){
	var value = $(this).val();
	checkTpportPreagg();
	$('input[name="tpport_radio_mobile"] option[value="' + value + '"]').prop('selected','selected');
});
$('input[name="tppaga_radio_mobile"]').change(function(){
	var value = $(this).val();
	{% if common['paypal'] == 1 %}
	setCreditCardPayment();
	{% endif %}
	checkTppagaPreagg();
	$('input[name="tppaga_radio"] option[value="' + value + '"]').prop('selected','selected');
});
$('input[name="tpport_radio_mobile"]').change(function(){
	var value = $(this).val();
	checkTpportPreagg();
	$('input[name="tpport_radio"] option[value="' + value + '"]').prop('selected','selected');
});
#}
$('input[name="tppaga_radio"], input[name="tppaga_radio_mobile"]').change(function(e){
	const value = $(e.currentTarget).val();
	// const data = $(e.currentTarget).data();
	$.ajax({
		type: "POST",
		url: "{{ url('cart/updateCurrentOrderInfo') }}",
		dataType: "json",
		data: {
			paramName: 'tppaga',
			value
		}
	}).done(function(data) {
		if (data == "OK") {
			{% if common['paypal'] == 1 %}
			setCreditCardPayment();
			{% endif %}
			checkTppagaPreagg();
			$('input[name="tppaga_radio"][value="' + value + '"], input[name="tppaga_radio_mobile"][value="' + value + '"]').prop('checked', true);
		} else if (data == "RELOAD") {
			window.location.reload();
		} else {
			// Dove mostriamo l'errore
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
$('#select-tppaga, #select-tppaga-mobile').change(function(e){
	const value = $(e.currentTarget).val();
	// const data = $(e.currentTarget).data();
	$.ajax({
		type: "POST",
		url: "{{ url('cart/updateCurrentOrderInfo') }}",
		dataType: "json",
		data: {
			paramName: 'tppaga',
			value
		}
	}).done(function(data) {
		if (data == "OK") {
			$('#select-tppaga, #select-tppaga-mobile').val(value);
		} else if (data == "RELOAD") {
			window.location.reload();
		} else {
			// Dove mostriamo l'errore
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});

$('input[name="tpport_radio"], input[name="tpport_radio_mobile"]').change(function(e){
	const value = $(e.currentTarget).val();
	// const data = $(e.currentTarget).data();
	$.ajax({
		type: "POST",
		url: "{{ url('cart/updateCurrentOrderInfo') }}",
		dataType: "json",
		data: {
			paramName: 'tpport',
			value
		}
	}).done(function(data) {
		if (data == "OK") {
			checkTpportPreagg();
			$('input[name="tpport_radio"][value="' + value + '"], input[name="tpport_radio_mobile"][value="' + value + '"]').prop('checked', true);
		} else if (data == "RELOAD") {
			window.location.reload();
		} else {
			// Dove mostriamo l'errore
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
$('#select-tpport, #select-tpport-mobile').change(function(e){
	const value = $(e.currentTarget).val();
	// const data = $(e.currentTarget).data();
	$.ajax({
		type: "POST",
		url: "{{ url('cart/updateCurrentOrderInfo') }}",
		dataType: "json",
		data: {
			paramName: 'tpport',
			value
		}
	}).done(function(data) {
		if (data == "OK") {
			$('#select-tpport, #select-tpport-mobile').val(value);
		} else if (data == "RELOAD") {
			window.location.reload();
		} else {
			// Dove mostriamo l'errore
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});

//endregion

function checkAvailabilityError() {
	var error = false;
	$('.cart-size-box').each(function(){
		if ($(this).hasClass("qtyerr_box"))
		error = true;
	});
	return error;
}

{% if thereAreDoubles %}
$('.btn-double').click(function(){
	var flstat = $(this).data('flstat');
	$('#modal-flstat-confirm').val(flstat);
});
{% endif %}

$('{{ not thereAreDoubles ? '#send-order,#save-order' : '#confirm-double-rows' }}').click(function(e) {
	e.preventDefault();
	$('#send-error').hide();

	{% if common['paymentCondition'] != 3 %}
	var inputTppaga = $('input[name="tppaga_radio"]').is(':visible') ? $('input[name="tppaga_radio"]:checked') : $('input[name="tppaga_radio_mobile"]:checked');
	var inputTpport = $('input[name="tpport_radio"]').is(':visible') ? $('input[name="tpport_radio"]:checked') : $('input[name="tpport_radio_mobile"]:checked');
	{% else %}
	var inputTppaga = $('#select-tppaga').is(':visible') ? $('#select-tppaga') : $('#select-tppaga-mobile');
	var inputTpport = $('#select-tpport').is(':visible') ? $('#select-tpport') : $('#select-tpport-mobile');

	{% endif %}

	var tppaga = inputTppaga.val() ?? 'default';
	var tpport = inputTpport.val() ?? 'default';
	var idcuspag = inputTppaga.data('idcuspag') ?? null;
	var idcuspor = inputTpport.data('idcuspor') ?? null;

	var indema = $('#contact-email').is(':visible') ? $('#contact-email').val() : $('#contact-mobile-email').val();
	var conrif = $('#contact-reference').is(':visible') ? $('#contact-reference').val() : $('#contact-mobile-reference').val();

  if (checkAvailabilityError()) {
    $('#send-error').show();
	showTemporary('#send-error', 5000, {});
  } else {
	var flstat = {{ not thereAreDoubles ? "$(this).data('flstat')" : "$('#modal-flstat-confirm').val()" }};
	var paymentNotes = '';
	var shipmentNotes = '';
	var notcli = $('#notcli').length ? $('#notcli').val() : "";
	var notazi = $('#notazi').length ? $('#notazi').val() : "";

	/*if ($('input[name="tppaga_radio"]').is(':visible') && $('input[name="tppaga_radio"]:checked').data('preagg') > 0) {
		{#
		// notcli += "<br/>" + $('input[name="tppaga_radio"]:checked').data('dspaga');
		// notcli += " (+" + parseFloat($('input[name="tppaga_radio"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }})";
		#}
		paymentNotes += $('input[name="tppaga_radio"]:checked').closest('label').text().trim();
	} else if ($('input[name="tppaga_radio_mobile"]').is(':visible') && $('input[name="tppaga_radio_mobile"]:checked').data('preagg') > 0) {
		{#
		// notcli += "<br/>" + $('input[name="tppaga_radio_mobile"]:checked').data('dspaga');
		// notcli += " (+" + parseFloat($('input[name="tppaga_radio_mobile"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }})";
		#}
		paymentNotes += $('input[name="tppaga_radio_mobile"]:checked').closest('label').text().trim();
	}
	if(paymentNotes !== '') {
		notcli += "<br/>{{ mt._('cart.payment')|upper }}: " + paymentNotes + ";";
	}

	if ($('input[name="tpport_radio"]').is(':visible') && $('input[name="tpport_radio"]:checked').data('preagg') > 0) {
		{#
		// notcli += "<br/>" + $('input[name="tpport_radio"]:checked').data('dstpor');
		// notcli += " (+" + parseFloat($('input[name="tpport_radio"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }})";
		// notcli += ", {{ mt._('account.customer.carrier') }}: " + $('input[name="tpport_radio"]:checked').data('dsvett');
		#}
		shipmentNotes += "<br/>" + $('input[name="tpport_radio"]:checked').closest('label').text().trim();
	} else if ($('input[name="tpport_radio_mobile"]').is(':visible') && $('input[name="tpport_radio_mobile"]:checked').data('preagg') > 0) {
		{#
		// notcli += "<br/>" + $('input[name="tpport_radio_mobile"]:checked').data('dstpor');
		// notcli += " (+" + parseFloat($('input[name="tpport_radio_mobile"]:checked').data('preagg')).formatMoney(2, ",", ".") + " {{ common['currency'] }})";
		// notcli += ", {{ mt._('account.customer.carrier') }}: " + $('input[name="tpport_radio_mobile"]:checked').data('dsvett');
		#}
		shipmentNotes += "<br/>" + $('input[name="tpport_radio_mobile"]:checked').closest('label').text().trim();
	}
	if (shipmentNotes !== '') {
		notcli += "<br/>{{ mt._('cart.shipping')|upper }}: " + shipmentNotes + ";";
	}*/

	$.ajax({
		type: "POST",
		url: "{{ url('cart/completeOrder') }}",
		dataType: "json",
		data: {
			flstat: flstat,
			notcli: notcli,
			notazi: notazi,
			idcuspag: idcuspag,
			tppaga: tppaga,
			idcuspor: idcuspor,
			tpport: tpport,
			indema: indema,
			conrif: conrif,
		}
	}).done(function(data) {
		if (data === "OK") {
			location.href = "{{ url('account/info/ord?t=' ~ common['order_info'].tpanag ~ '&c=' ~ common['order_info'].cdanag) }}";
		} else {
			let text = '';
			if (jsInfo.cartErrors.hasOwnProperty(data)) {
				text = jsInfo.cartErrors[data];
			} else if (data === "OE") {
				text = '{{ mt._('_common.update.error')|escape_js }}';
			} else {
				text = jsInfo.genericErrorMsg;
			}
			showTemporary(null, 5000, {className: 'alert alert-danger', text});
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
		showTemporary(null, 5000, {className: 'alert alert-danger', text: jsInfo.genericErrorMsg});
	});
  }
});

{% if common['coupon_promo'] == 2 and promos|length > 0 %}
var title = "<div class='font-weight-bold text-uppercase text-custom pt-10x'>{{ mt._('promo.appliedpromo') }}</div>"
title += "<div class='px-10x'>";
title += "<ul class='text-left mb-0'>";
	{% for promo in promos %}
title += "<li> {{ promo.dsprom }}</li>";
	{% endfor %}
title += "</ul></div>";
$('[data-toggle="tooltip"]').tooltip({
	title: title,
	html: true,
	placement: "bottom"
});
{% endif %}

//region modelDetailStyle == 2
{% if common['modelDetailStyle'] == 2 and nuordc < 0 %}

	{% if (common['order_info'].tpordc == 1 and common['dateTypeResOrder'] < 2) or
			  (common['order_info'].tpordc == 0 and common['dateTypeAvaOrder'] < 2) %}

	{% else %}
$.datepicker.setDefaults($.datepicker.regional.{{ session.get('language') }});
$('#modal-modify-row-quantity-date').datepicker({ dateFormat: 'dd/mm/yy', minDate: 0, autoOpen: false});
$('.general-dtmcli').click(function(){
  $('#ui-datepicker-div').css('margin-left', '0');
})
	{% endif %}

$(document).on('show.bs.modal', '.modal-modify-row-quantity', function (e) {
});

$('.form-element-datepicker').click(function(){
	$('#modal-modify-row-quantity-date').datepicker('enable');
	$('#modal-modify-row-quantity-date').datepicker('show');
});

{{ insertQuantityTemplate('#modal-modify-row-content', router.getControllerName(), common['breakregqta'], common['modelDetailStyle']) }}

$('.modify-row-quantity').click(function(){
	var nurorc = $(this).closest(".row-cart-btn").data("nurorc");
	$('#modal-modify-row-quantity-nurorc').val(nurorc);

	var cdartn = $(this).closest(".row-cart-btn").data("cdartn");
	var dsartn = $(this).closest(".row-cart-btn").data("dsartn");
	$('#modal-modify-row-quantity-model').html(cdartn + " - " + dsartn);

	var cdpers = $(this).closest(".row-cart-btn").data("cdpers");
	$('#modal-modify-row-quantity-fabric').html(cdpers);

	var cdcolo = $(this).closest(".row-cart-btn").data("cdcolo");
	var dscolo = $(this).closest(".row-cart-btn").data("dscolo");
	$('#modal-modify-row-quantity-color').html(cdcolo + (dscolo != '' ? " - " + dscolo : ''));

	var dsvari = $(this).closest(".row-cart-btn").data("dsvari");
	$('#modal-modify-row-quantity-variants').html(dsvari.replace('<br/>', ', '));

	var dsnoco = $(this).closest(".row-cart-btn").data("dsnoco");
	$('#modal-modify-row-quantity-notes').val(dsnoco);

	var flimag_n = $(this).closest(".cart-list-row").find(".model-img img").prop('src');
	$('#modal-modify-row-quantity-model-img').prop('src', flimag_n);

	var flimag_c = $(this).closest(".cart-list-row").find(".color-img img").prop('src');
	$('#modal-modify-row-quantity-color-img').prop('src', flimag_c);

	var dtmcli = $(this).closest(".row-cart-btn").data("dtmcli");
	$('#modal-modify-row-quantity-date').val(dtmcli != '00/00/0000' ? dtmcli : '');
	$('#modal-modify-row-quantity-date').datepicker('disable');

	var qtamin = $(this).closest(".row-cart-btn").data("regqtm-qtamin");
	var qtamul = $(this).closest(".row-cart-btn").data("regqtm-qtamul");
	$('#modal-modify-row-quantity-regqtm-qtamin').html(qtamin);
	$('#modal-modify-row-quantity-regqtm-qtamul').html(qtamul);

	$.ajax({
		type: "POST",
		url: "{{ url('cart/getModifyQuantityContent') }}",
		dataType: "json",
		data: {
			nurorc: nurorc,
			nulist: "{{ common['order_info'].nulist }}",
			cdartn: cdartn
		}
	}).done(function(data) {
		if (data['response'] == 'OK') {
			$('.modal-modify-row-quantity').modal('show');
			$('#modal-modify-row-content').html(data['html']);
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
$('#modal-modify-row-quantity-confirm').click(function(){
	$(".modal-modify-row-quantity .unsuccess-box").hide();
	var octagl = [];
	var totQty = 0;
	$('#modal-modify-row-content .input-number').each(function(){
		var currentValue =  $(this).val() != '' ? $(this).val() : 0;
		totQty += parseInt(currentValue);
		octagl.push([
			$(this).data('taglia'),
			currentValue,
		]);
	})

  var qtamin = parseInt($('#modal-modify-row-quantity-regqtm-qtamin').html());
  var qtamul = parseInt($('#modal-modify-row-quantity-regqtm-qtamul').html());

  // Accept empty rows, Check rules if rows are not empty
  if (totQty == 0 || (totQty >= qtamin && ((totQty - qtamin) % qtamul == 0))) {
		$.ajax({
			type: "POST",
			url: "{{ url('cart/saveModifyQuantity') }}",
			dataType: "json",
			data: {
				nurorc: $('#modal-modify-row-quantity-nurorc').val(),
				dtmcli: $('#modal-modify-row-quantity-date').val(),
				dsnoco: $('#modal-modify-row-quantity-notes').val(),
				octagl: octagl,
			}
		}).done(function(data) {
			window.location.reload();
		}).error(function(x, t, m) {
			printAjaxError(x, t, m);
		});
	} else {
		showTemporary(".modal-modify-row-quantity .unsuccess-box", 2000);
	}
});
$('#modal-modify-row-variants-content').on('click', '.variant-box', function(){
  var currentTpvari = $(this).data('tpvari');

  if ($(this).hasClass('selected')) {
    $(this).removeClass('selected');
  } else {
    $('.variant-box[data-tpvari="' + currentTpvari + '"]').removeClass('selected');
    $(this).addClass('selected');
  }

  var variants = '';
  $('.variant-box.selected').each(function(){
    variants += $(this).data('cdvari');
  });
});
$('.modify-row-variants').click(function(){
	var nurorc = $(this).closest(".row-cart-btn").data("nurorc");
	$('#modal-modify-row-variants-nurorc').val(nurorc);

	var cdvari = $(this).closest(".row-cart-btn").data("cdvari");
	$('#modal-modify-row-variants-oldcdvari').val(cdvari);

	var cdartn = $(this).closest(".row-cart-btn").data("cdartn");
	var dsartn = $(this).closest(".row-cart-btn").data("dsartn");
	$('#modal-modify-row-variants-model').html(cdartn + " - " + dsartn);

	var cdpers = $(this).closest(".row-cart-btn").data("cdpers");
	$('#modal-modify-row-variants-fabric').html(cdpers);

	var cdcolo = $(this).closest(".row-cart-btn").data("cdcolo");
	var dscolo = $(this).closest(".row-cart-btn").data("dscolo");
	$('#modal-modify-row-variants-color').html(cdcolo + (dscolo != '' ? " - " + dscolo : ''));

	var dsvari = $(this).closest(".row-cart-btn").data("dsvari");
	$('#modal-modify-row-variants-variants').html(dsvari.replace('<br/>', ', '));

	var flimag_n = $(this).closest(".cart-list-row").find(".model-img img").prop('src');
	$('#modal-modify-row-variants-model-img').prop('src', flimag_n);

	var flimag_c = $(this).closest(".cart-list-row").find(".color-img img").prop('src');
	$('#modal-modify-row-variants-color-img').prop('src', flimag_c);

	$.ajax({
		type: "POST",
		url: "{{ url('cart/getModifyVariantsContent') }}",
		dataType: "json",
		data: {
			nurorc: nurorc,
			cdvari: $(this).closest(".row-cart-btn").data("cdvari"),
		}
	}).done(function(data) {
		if (data['response'] == 'OK') {
			$('.modal-modify-row-variants').modal('show');
			$('#modal-modify-row-variants-content').html(data['html']);
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});

$('#modal-modify-row-variants-confirm').click(function(){
	var cdvari = '';
	$('#modal-modify-row-variants-content .variant-box.selected').each(function(){
		cdvari += $(this).data('cdvari');
	});
	$.ajax({
		type: "POST",
		url: "{{ url('cart/saveModifyVariants') }}",
		dataType: "json",
		data: {
			nurorc: $('#modal-modify-row-variants-nurorc').val(),
			cdvari: cdvari,
			oldcdvari: $('#modal-modify-row-variants-oldcdvari').val(),
		}
	}).done(function(data) {
		window.location.reload();
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
{% endif %}
//endregion

{% if common['shippingsOnRows'] == 1 %}
$('.select-cddesm').change(function(){
	var cddesm = $(this).val();
	var nurorc = $(this).closest('.cart-list-row').data('nurorc');

	$.ajax({
		type: "POST",
		url: "{{ url('cart/updateRowShipping') }}",
		dataType: "json",
		data: {
			nurorc: nurorc,
			cddesm: cddesm
		}
	}).done(function(data) {

	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
{% endif %}

{{ insertQuantityTemplate('.modal-bulk-insert .modal-body', router.getControllerName(), common['breakregqta'], common['modelDetailStyle']) }}

{% endif %}

</script>
