<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
    var jsInfo = {
        'typeSomethingText': "{{ i18n._('_common.typeSomething') }}",
        'searchTranslationStringsUrl': "{{ url('admin/searchTranslationStrings') }}",
        'updateTranslationStringUrl': "{{ url('admin/updateTranslationString') }}",
        'translationHelpGoogleText': "{{ i18n._("admin.translation.help.google") }}",
        'translationHelpDeeplText': "{{ i18n._("admin.translation.help.deepl") }}",
        'saveText': "{{ i18n._("_common.save") }}",
        'confirmSearchText': "{{ i18n._('admin.translation.search.confirm') }}",
    };

    $(document).ready(function () {
        const successMessagesWrapper = $('#msg-success-model-info');
        const errorMessagesWrapper = $('#msg-error-model-info');

        function hideMessages() {
            successMessagesWrapper.html('').addClass('hidden');
            errorMessagesWrapper.html('').addClass('hidden');
        }

        function appendSuccessMessage(message) {
            message = message || '{{ mt._('_common.update.success')|escape_js }}';
            const messageElement = $(`<div class="element-message-content">${message}</div>`);
            successMessagesWrapper.removeClass('hidden').append(messageElement);
            setTimeout(() => {
                messageElement.remove();
                if (successMessagesWrapper.children().length === 0) {
                    successMessagesWrapper.addClass('hidden');
                }
            }, 3500);

        }

        function appendErrorMessage(message) {
            message = message || '{{ mt._('_common.update.error')|escape_js }}';
            const messageElement = $(`<div class="element-message-content">${message}</div>`);
            errorMessagesWrapper.removeClass('hidden').append(messageElement);
            setTimeout(() => {
                messageElement.remove();
                if (errorMessagesWrapper.children().length === 0) {
                    errorMessagesWrapper.addClass('hidden');
                }
            }, 3500);
        }

        hideMessages();

        const languageSelector = $('#translation-strings-language');
        const searchBtn = $('#translation-strings-search');
        const table = $('#translation-strings-table');

        if (table.length) {
            table.on('click', '.btn-save', (e) => {
                hideMessages();
                const btn = $(e.currentTarget);
                const row = btn.closest('tr');
                const value = row.find(':input').val() ?? '';

                $.ajax({
                    url: jsInfo['updateTranslationStringUrl'],
                    type: 'POST',
                    async: true,
                    dataType: 'json',
                    data: {
                        'id': row.data('tsId'),
                        'value': value,
                    },
                    success: function (data) {
                        if (!data['success']) {
                            appendErrorMessage(data['messages']);
                        } else {
                            row.data('tsValue', value).removeClass('edited');
                            row.find('.btn-save').prop('disabled', true);
                            row.find('td:first-child i.fa')
                                .removeClass('fa-check-circle text-success fa-exclamation-circle text-danger')
                                .addClass(value !== '' ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger');
                            appendSuccessMessage(data['messages']);
                        }
                    },
                    error: function (x, s, e) {
                        appendErrorMessage(x);
                        printAjaxError(x, s, e);
                    }
                });
            });

            table.on('click', '.btn-translation-help', (e) => {
                const btn = $(e.currentTarget);
                btn.siblings(':input').focus();
            });

            table.on('input', ':input.form-control', (e) => {
                const input = $(e.currentTarget);
                const row = input.closest('tr');
                const prevValue = row.data('tsValue') ?? '';
                const value = input.val() ?? '';
                if (value !== prevValue) {
                    row.addClass('edited');
                    row.find('.btn-save').prop('disabled', false);
                } else {
                    row.removeClass('edited');
                    row.find('.btn-save').prop('disabled', true);
                }
            });

            table.DataTable({
                'pageLength': 100,
                'columns': [
                    {"orderable": true, "width": "5%"},
                    {"orderable": true, "width": "40%"},
                    {"orderable": false, "width": "50%"},
                    {"orderable": false, "width": "5%"},
                ],
                {% include 'scripts/common/table_language.volt' %}
            });

            $(languageSelector).on('change', () => {
                window.location.href = '/admin/translateStrings/' + languageSelector.val();
            });
        }

        $(searchBtn).on('click', () => {
            if (confirm(jsInfo['confirmSearchText'])) {
                table.data('language', languageSelector.val());
                $.ajax({
                    url: jsInfo['searchTranslationStringsUrl'],
                    async: true,
                    contentType: 'application/json',
                    dataType: 'json',
                    success: () => {
                        window.location.reload();
                    },
                    error: function (x, s, e) {
                        showMessageTemporary('#update-translation-strings-error', x);
                        printAjaxError(x, s, e);
                    }
                });
            }
        });

    });
</script>
