<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
{% include "scripts/common/user_operations.volt" %}
<script>

$(document).ready(function() {
  $('#table-shippings').DataTable({
    'order': [],
    'columns': [
      { "orderable": false, "width": "3%" },
      { "orderable": true, "width": "6%" },
      { "orderable": true, "width": "35%" },
      { "orderable": true, "width": "17%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": false, "width": "3%" },
    ],
    'pageLength': 100,
    {% include 'scripts/common/table_language.volt' %}
  });

  function exportTableToCSV($table, filename) {
    var $rows = $table.find('tr'),

    // Temporary delimiter characters unlikely to be typed by keyboard
    // This is to avoid accidentally splitting the actual contents
    tmpColDelim = String.fromCharCode(11), // vertical tab character
    tmpRowDelim = String.fromCharCode(0), // null character

    // actual delimiter characters for CSV format
    colDelim = '","',
    rowDelim = '"\r\n"',

    // Grab text from table into CSV formatted string
    csv = '"' + $rows.map(function(i, row) {
      var $row = $(row), $cols = $row.find('td');

      return $cols.map(function(j, col) {
        var $col = $(col), text = $col.text();

        //return text.replace(/"/g, '""'); // escape double quotes
        return text; // escape double quotes
      }).get().join(tmpColDelim);
    }).get().join(tmpRowDelim)
      .split(tmpRowDelim).join(rowDelim)
      .split(tmpColDelim).join(colDelim) + '"';

    // Deliberate 'false', see comment below
    if (false && window.navigator.msSaveBlob) {
      var blob = new Blob([decodeURIComponent(csv)], {
        type: 'text/csv;charset=utf8'
      });

      // Crashes in IE 10, IE 11 and Microsoft Edge
      // See MS Edge Issue #10396033
      // Hence, the deliberate 'false'
      // This is here just for completeness
      // Remove the 'false' at your own risk
      window.navigator.msSaveBlob(blob, filename);
    } else if (window.Blob && window.URL) {
      // HTML5 Blob
      var blob = new Blob([csv], {
        type: 'text/csv;charset=utf-8'
      });
      var csvUrl = URL.createObjectURL(blob);

      $(this).attr({
        'download': filename,
        'href': csvUrl
      });
    } else {
      // Data URI
      var csvData = 'data:application/csv;charset=utf-8,' + encodeURIComponent(csv);

      $(this).attr({
        'download': filename,
        'href': csvData,
        'target': '_blank'
      });
    }
  }
  // This must be a hyperlink
  $("#export-csv").on('click', function(event) {
    //event.preventDefault();
    // CSV
    var args = [$('#dvData > table'), 'shippings-export.csv'];
    exportTableToCSV.apply(this, args);

    // If CSV, don't do event.preventDefault() or return false
    // We actually need this to be a typical hyperlink
  });
});
$('.modify-user').click(function(e) {
  e.preventDefault();

  // reset
  $('#modal-username').val("");
  $('#modal-password').val("");
  $('#modal-repeatpassword').val("");
  $("#modal-status").css("background-color", "#ffeeee");
  $("#status-disabled").prop("selected",true);
  $(".catalog-checkbox").prop('checked', false);

  // anagra / desmer
  $('#modal-customer').html($(this).data('cdanag') + " - " + $(this).data('desana'));
  $('#modal-code').html($(this).data('cddesm'));
  $('#modal-description').html($(this).data('indiri'));

  // b2buser
  if ($(this).data('idusr')) {
    $('#modal-edit-password-box').show();
    $('#modal-password-box').hide();
    $('#modal-repeatpassword-box').hide();

    $('#modal-username').val($(this).data('usrnam'));

    if ($(this).data('enable') == 1) {
      $("#modal-status").css("background-color", "#defcbd");
      $("#status-enabled").prop("selected",true);
    } else {
      $("#modal-status").css("background-color", "#ffeeee");
      $("#status-disabled").prop("selected",true);
    }

    if ($(this).is("[data-catalogs]")) {
      var catalogs = $(this).data('catalogs').split(',');
      var i;
      for (i = 0; i < catalogs.length; i++) {
        $("#checkbox-" + catalogs[i]).prop('checked', true);
      }
    }

    $('#save-user').data("action", "edit");
    $('#save-user').data("idusr", $(this).data('idusr'));
  } else {
    $('#modal-status').css("background-color", "#ffeeee");
    $('#modal-edit-password-box').hide();
    $('#modal-password-box').show();
    $('#modal-repeatpassword-box').show();
    $('#save-user').data("action", "new");
  }
});
$('#save-user').click(function(){
  $("#modal-username").removeClass("error-form-input");
  $("#modal-password").removeClass("error-form-input");
  $("#modal-repeatpassword").removeClass("error-form-input");
  $(".msg-form-error").hide();
  $(".msg-error").hide();
  $(".msg-success").hide();
  $(".msg-form-error").html("");

  if ($(this).data("action") != "new") {
    var idusr          = $(this).data("idusr");
    var username       = $("#modal-username").val();
    var editpassword   = $("#modal-edit-password").prop("checked") == false;
    var password       = $("#modal-password").val();
    var repeatpassword = $("#modal-repeatpassword").val();
    var enabled        = $("#modal-status").val();
    var catalogs       = $("input[name='catalog-checkbox[]']:checked").map(function(){return $(this).val();}).get();

    // check username and passwords
    if (username == "") {
      $("#modal-username").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.missingusername') }}");
    } else if (editpassword && password == "") {
      $("#modal-password").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.missingpassword') }}");
    } else if (editpassword && password != repeatpassword) {
      $("#modal-repeatpassword").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.passwordmismatch') }}");
    } else if ((editpassword && password == repeatpassword) || !editpassword) {
      $("#save-user").prop("disabled",true);
      $.ajax({
        type: 'POST',
        url: "{{ url('admin/editUser') }}",
        dataType: 'json',
        data: {
          idusr:        idusr,
          username:     username,
          editpassword: editpassword,
          password:     password,
          enabled:      enabled,
          catalogs:     catalogs,
        }
      }).done(function(data) {
        switch(data) {
        case "OK":
          $(".msg-error").hide();
          showTemporary(".msg-success", 2000);
          setTimeout( function(){
            location.reload();
          }, 2000 );
          break;
        case "US":
        case "UA":
        case "UC":
        default:
          $(".msg-success").hide();
          showTemporary(".msg-error", 2000);
          break;
        case "LT":
          $(".msg-form-error").show();
          $(".msg-form-error").html("{{ mt._('_common.form.licenseslimitreached') }}");
          break;
        }
        $("#save-user").prop("disabled",false);
      }).error(function(x, t, m) {
    		printAjaxError(x, t, m);
        $(".msg-success").hide();
        showTemporary(".msg-error", 2000);
        $("#save-user").prop("disabled",false);
      });
    }
  } else {
    var cddesm         = $("#modal-code").html();
    var username       = $("#modal-username").val();
    var password       = $("#modal-password").val();
    var repeatpassword = $("#modal-repeatpassword").val();
    var enabled        = $("#modal-status").val();
    var catalogs       = $("input[name='catalog-checkbox[]']:checked").map(function(){return $(this).val();}).get();

    // check username and passwords
    if (username == "") {
      $("#modal-username").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.missingusername') }}");
    } else if (password == "") {
      $("#modal-password").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.missingpassword') }}");
    } else if (password != repeatpassword) {
      $("#modal-repeatpassword").addClass("error-form-input");
      $(".msg-form-error").show();
      $(".msg-form-error").html("{{ mt._('_common.form.passwordmismatch') }}");
    } else {
      $("#save-user").prop("disabled",true);
      $.ajax({
        type: 'POST',
        url: "{{ url('admin/createuserdsm') }}",
        dataType: 'json',
        data: {
          cddesm:   cddesm,
          username: username,
          password: password,
          enabled:  enabled,
          catalogs: catalogs,
        }
      }).done(function(data) {
        switch(data) {
        case "OK":
          $(".msg-error").hide();
          showTemporary(".msg-success", 2000);
          setTimeout( function(){
            location.href = "{{ url('admin/shippings') }}";
          }, 2000 );
          break;
        case "US":
        case "UA":
        case "UC":
        default:
          $(".msg-success").hide();
          showTemporary(".msg-error", 2000);
          break;
        case "LT":
          $(".msg-form-error").show();
          $(".msg-form-error").html("{{ mt._('_common.form.licenseslimitreached') }}");
          break;
        }
        $("#save-user").prop("disabled",false);
      }).error(function(x, t, m) {
    		printAjaxError(x, t, m);
        $("#save-user").prop("disabled",false);
      });
    }
  }
});
$('.checkbox-shipping input').change(function() {
  if ($(this).is(":checked") && $(".checkbox-shipping input:checked").length == 1) {
    // first item selected
    if ($(this).val() == "-1") {
      $("#bulk-enable").parent("span").hide();
      $("#bulk-disable").parent("span").hide();
      $("#export-csv").parent("span").hide();
      // hide all item with id_usr
      $('.checkbox-shipping input').each(function(){
        if ($(this).val() != "-1") {
          $(this).parent('.checkbox-shipping').hide();
        }
      });
    } else {
      $("#bulk-create").parent("span").hide();
      // hide all item with -1
      $('.checkbox-shipping input').each(function(){
        if ($(this).val() == "-1") {
          $(this).parent('.checkbox-shipping').hide();
        }
      });
    }
  } else if (!$(this).is(":checked") && $(".checkbox-shipping input:checked").length == 0) {
    // last item unselected
    $('.checkbox-shipping input').each(function(){
      $(this).parent('.checkbox-shipping').show();
      $("#bulk-enable").parent("span").show();
      $("#bulk-disable").parent("span").show();
      $("#bulk-create").parent("span").show();
      $("#export-csv").parent("span").show();
    });
  }
});
$("#bulk-create").click(function(){
  $(this).hide();
  var shippings = [];
  $("input[name='status-checkbox[]']:checked").each(function(){
    var cddesm = $(this).closest('tr').attr('id');
    shippings.push(cddesm);
  });

  if (shippings.length > 0) {
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/createusersdsm') }}",
      dataType: 'json',
      data: {
        shippings: shippings,
      }
    }).done(function(data) {
      location.reload();
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  }
});
</script>
