<!-- jQuery TE -->
{{ javascript_include("vendors/tinymce/tinymce.min.js") }}
<script>
    $(document).ready(function () {
        const editableInputs = $('.jqte-editable-input');

        // Enable Editor
        // editableInputs.jqte();
        tinymce.init({
            selector: '.jqte-editable-input',
            menubar: false,
            toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | hr link image lists table | removeformat | code',
            toolbar_groups: {
                lists: {
                    icon: 'unordered-list',
                    tooltip: 'Lists',
                    items: 'bullist numlist indent outdent'
                }
            },
            setup : function(ed) {
                ed.on('input', function(e) {
                    // Aggiorniamo sempre i dati dentro la textarea per
                    $(this.getElement()).val(this.getContent());
                });
            },
            plugins: 'table link image lists hr code',
            language: '{{ session.get('language')|default('it') }}'
        });

        $('#save-notes').click(function () {
            let utils = [];
            editableInputs.each((idx, el) => {
                const $el = $(el);
                utils.push({param: $el.attr('name'), value: $el.val()});
            });

            // console.log(utils);

            $("#save-notes").prop("disabled", true);
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/updateUtils') }}",
                dataType: 'json',
                data: {
                    utils
                }
            }).done(function (data) {
                if (data == "OK") {
                    $(".msg-error").hide();
                    showTemporary(".msg-success", 2000);
                } else {
                    $(".msg-success").hide();
                    showTemporary(".msg-error", 2000);
                }
                $("#save-notes").prop("disabled", false);
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
                $("#save-notes").prop("disabled", false);
            });
        });
    });

</script>
