<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<script type="text/javascript">// Immediately after the js include
  Dropzone.autoDiscover = false;
</script>
<script>
$('#dropzone-login-image').dropzone({
  init: function() {

  },
  acceptedFiles: 'image/jpeg',
  dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
  dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
  dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
  success: function (response) {
    $("#login_image").val(response["name"]);
  },
  addRemoveLinks: true,
  maxFiles: 1,
  removedfile: function(file) {
    var _ref; // Remove file on clicking the 'Remove file' button
    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
  }
});
$('#dropzone-logo-image').dropzone({
  init: function() {

  },
  acceptedFiles: 'image/jpeg',
  dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
  dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
  dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
  success: function (response) {
    $("#logo_image").val(response["name"]);
  },
  addRemoveLinks: true,
  maxFiles: 1,
  removedfile: function(file) {
    var _ref; // Remove file on clicking the 'Remove file' button
    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
  }
});
$('#save-params').click(function(){
  var settings = [];
  $(".setting").each(function(){
    var setting = $(this).attr("id");
    var value = $(this).val();

    settings.push({setting, value});
  });

  if (settings.length > 0) {
    $("#save-params").prop("disabled",true);
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/updateSettings') }}",
      dataType: 'json',
      data: {
        settings: settings,
        login: $('#login_image').val(),
        logo: $('#logo_image').val(),
      }
    }).done(function(data) {
      if (data == "OK") {
        $(".msg-error").hide();
        showTemporary(".msg-success", 2000);
      } else {
        $(".msg-success").hide();
        showTemporary(".msg-error", 2000);
      }
      $("#save-params").prop("disabled",false);
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
      $("#save-params").prop("disabled",false);
    });
  }
});
</script>
