<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function($) {
  $('#datatable-reqaccess').DataTable({
    'order': [[ 0, 'desc' ]],
    'pageLength': 100,
    {% include 'scripts/common/table_language.volt' %}
  });
});
$('.set-managed').click(function(){
  var descri = $(this).closest('tr').data('descri');
  var dtcrea = $(this).closest('tr').data('dtcrea');
  var td = $(this).closest('td');

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/setManaged') }}",
    dataType: 'json',
    data: {
      descri: descri,
      dtcrea: dtcrea,
    }
  }).done(function(data) {
    if (data == "OK") {
      td.html("{{ mt._('admin.reqaccess.managed') }}");
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('.delete-reqacc').click(function(){
  var descri = $(this).closest('tr').data('descri');
  var dtcrea = $(this).closest('tr').data('dtcrea');
  $('#modal-delete-descri').val(descri);
  $('#modal-delete-dtcrea').val(dtcrea);
});

$('#delete-reqacc').click(function(e){
  var descri = $('#modal-delete-descri').val();
  var dtcrea = $('#modal-delete-dtcrea').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteReqAccess') }}",
    dataType: 'json',
    data: {
      descri: descri,
      dtcrea: dtcrea
    }
  }).done(function(data) {
    location.reload();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
