<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>
<script>
$.fn.dataTable.ext.type.order['numeric-comma-asc']  = function(a,b) {
  var x = a.replace(".", "");
  var y = b.replace(".", "");
  x = x.replace(",", ".");
  y = y.replace(",", ".");

  x = parseFloat( x );
  y = parseFloat( y );

  return ((x < y) ? -1 : ((x > y) ?  1 : 0));
};
$.fn.dataTable.ext.type.order['numeric-comma-desc'] = function(a,b) {
  var x = a.replace(".", "");
  var y = b.replace(".", "");
  x = x.replace(",", ".");
  y = y.replace(",", ".");

  x = parseFloat( x );
  y = parseFloat( y );

  return ((x < y) ?  1 : ((x > y) ? -1 : 0));
};

$(document).ready(function($) {
  $('#datatable-orders').DataTable({
    'order': [[ 0, 'desc' ]],
    'pageLength': 100,
    'columnDefs': [
      { "type": "num-fmt", "targets": [0] },
      { "type": "num-fmt", "targets": [7] },
      { "type": "numeric-comma", "targets": [8] }
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

// Delete order
$('.delete-order').click(function(e){
	e.preventDefault();

  var nuordc = $(this).closest('tr').data('nuordc');
  $('#order-to-delete').val(nuordc);
  $('#order-to-delete-txt').html(nuordc);
});
$('#confirm-delete-order').click(function(e){
  e.preventDefault();
  $.ajax({
    type: "POST",
    url: "{{ url('admin/deleteOrder') }}",
    dataType: "json",
    data: {
      nuordc: $('#order-to-delete').val(),
    }
  }).done(function(data) {
    window.location.reload();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
