<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}

<!-- jQuery TE -->
{{ javascript_include("js/jquery-te-1.4.0.min.js") }}
<script type="application/json" id="available-classifications">{{ classifications|json_encode }}</script>
<script>
    $(document).ready(function() {
        $('.jqte-test').jqte();

        // settings of status
        var jqteStatus = true;
        $(".status").click(function() {
            jqteStatus = jqteStatus ? false : true;
            $('.jqte-test').jqte({"status" : jqteStatus})
        });

        const classifications = JSON.parse(document.getElementById('available-classifications').innerHTML);
        console.log(classifications);

        $('.classification-path').each((id, el) => {
            const realInput = $('input[type="hidden"]', el);
            const labelInput = $('input[type="text"]', el);
            const list = $('.dropdown-menu', el);
            const datalist = $('datalist', el);
            labelInput.change(() => {
                const currentValue = labelInput.val();
                const option = datalist.find(`option[value^="${currentValue}"]`);
                if (option.length > 0) {
                    realInput.val(option.data('value'));
                    labelInput.val(option.val());
                } else {
                    realInput.val('');
                    labelInput.val('');
                }
            });
            list.on('click', 'a', (e) => {
                console.log(e);
                e.preventDefault();
                const clickedLink = $(e.currentTarget);
                if (clickedLink.is('.disabled')) {
                    return false;
                }
                realInput.val(clickedLink.data('value'));
                labelInput.val(clickedLink.data('label'));
            });
            list.find('> li > a:not(.disabled)').each((id2, el2) => {
                const listEL = $(el2);
                datalist.append(`<option data-value="${listEL.data('value')}" value="${listEL.data('label')}"/>`);
            });
            if (realInput.val() != '') {
                labelInput.val(datalist.find(`[data-value="${realInput.val()}"]`).val()).change();
            }
        });
    });
    function init_daterangepicker() {
        {% include "scripts/common/daterangepicker_config.volt" %}
        if( typeof ($.fn.daterangepicker) === 'undefined'){ return; }

        drpConfig4['startDate'] = '{{ model.dtiniz_eu }}';
        $('#dtiniz-box span').html('{{ model.dtiniz_eu }}');
        $('#dtiniz').val('{{ model.dtiniz_eu }}');
        $('#dtiniz-box').daterangepicker(drpConfig4, function(start, end, label) {
            $('#dtiniz-box span').html(start.format('DD/MM/YYYY'));
            $('#dtiniz').val(start.format('DD/MM/YYYY'));
        });
        drpConfig4['startDate'] = '{{ model.dtfine_eu }}';
        $('#dtfine-box span').html('{{ model.dtfine_eu }}');
        $('#dtfine').val('{{ model.dtfine_eu }}');
        $('#dtfine-box').daterangepicker(drpConfig4, function(start, end, label) {
            $('#dtfine-box span').html(start.format('DD/MM/YYYY'));
            $('#dtfine').val(start.format('DD/MM/YYYY'));
        });
    }
    $(document).ready(function(){
        init_daterangepicker();
    });
</script>

{% if success >= 0 %}
    <script>
        $(document).ready(function(){
            delay(function(){
                $('.msg-success-model-info').fadeOut();
                $('.msg-error-model-info').fadeOut()
            }, 5000);
        });
    </script>
{% endif %}
