<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
var tb_conf = {
  'bInfo': false,
  'pageLength': 100,
  'bPaginate': false,
  'searching': false,
  'order': [],
  'columns': [
    { "orderable": true, "width": "15%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
  ],
  {% include 'scripts/common/table_language.volt' %}
};
$(document).ready(function(){
  table.DataTable(tb_conf);

  {% if table != '' %}
  refreshTable();
  {% endif %}
});
var table = $('#table-localization');
$('#type').change(function(){
  refreshTable();
});
function refreshTable() {
  if ($('type').val() != 'none') {
    // Load fltest
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/getLocalization') }}",
      dataType: 'json',
      data: {
        data: $('#type').val()
      }
    }).done(function(data) {
      if (data['response'] == "OK") {
        table.DataTable().destroy();
        $('#table-localization tbody').html(data['rows']);
        table.DataTable(tb_conf);
      }
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });

    $('#localization-panel').show();
  } else {
    $('#localization-panel').hide();
  }
}

$('.save-info').click(function(){
  var table = $('#type').val();

  $('.msg-success').hide();
  $('.msg-error').hide();

  var rows = [];
  $('#table-localization tbody tr').each(function(){
    var codic1 = $(this).data('codic1');
    var codic2 = table == 'sermod' ? $(this).data('codic2') : '';
    var des_it = $(this).find('.des_it').val();
    var des_en = $(this).find('.des_en').val();
    var des_es = $(this).find('.des_es').val();
    var des_fr = $(this).find('.des_fr').val();
    var des_de = $(this).find('.des_de').val();
    rows.push([
      codic1,
      codic2,
      des_it,
      des_en,
      des_es,
      des_fr,
      des_de,
    ]);
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveLocalization') }}",
    dataType: 'json',
    data: {
      table: table,
      rows:  rows
    }
  }).done(function(data) {
    if (data == "OK") {
      $('.msg-error').hide();
      showTemporary(".msg-success", 2000);
      setTimeout( function(){
        location.href = "{{ url('admin/localization') }}/" + table;
      }, 2000 );
    } else {
      $('.msg-success').hide();
      showTemporary(".msg-error", 2000);
    }
  }).error(function(x, t, m) {
  	printAjaxError(x, t, m);
  });
});
</script>
