<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<script type="text/javascript">// Immediately after the js include
  Dropzone.autoDiscover = false;
  $('#dropzone-add-image').dropzone({
    init: function() {
      this.on("maxfilesexceeded", function(file) {
        this.removeAllFiles();
        this.addFile(file);
      });
    },
    acceptedFiles: 'image/jpeg',
    dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
    dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
    dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
    success: function (response) {
      console.log(response);
    },
    addRemoveLinks: true,
    maxFiles: 1,
    removedfile: function(file) {
      var _ref; // Remove file on clicking the 'Remove file' button
      return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
    }
  });
  $('#dropzone-change-image').dropzone({
    init: function() {
      this.on("maxfilesexceeded", function(file) {
        this.removeAllFiles();
        this.addFile(file);
      });
      this.on("complete", function(file) {
        this.removeAllFiles(true);
      })
    },
    acceptedFiles: 'image/jpeg',
    dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
    dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
    dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
    success: function (response) {
      $('#current-image').prop('src', '../public/upload/galleries/' + response.name);
      $('#new-image').val(response.name);
    },
    addRemoveLinks: true,
    maxFiles: 1,
    removedfile: function(file) {
      var _ref; // Remove file on clicking the 'Remove file' button
      return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
    }
  });
</script>

<script>
var jsInfo = {
  'getGalleriesUrl':  '{{ url("admin/getGalleries") }}',
  'saveGalleryUrl':   '{{ url("admin/saveGallery") }}',
  'deleteGalleryUrl': '{{ url("admin/deleteGallery") }}',
  'updateGalleryOrderUrl': '{{ url("admin/updateGalleryOrder") }}',
  'updateGalleryImageUrl': '{{ url("admin/updateGalleryImage") }}',
  'updateGalleryDescriptionUrl': '{{ url("admin/updateGalleryDescription") }}'
};
</script>
{{ javascript_include("js/custom/admin_galleries.js") }}
