<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>

<script>
var tb_3col_conf = {
  'order': [],
  'pageLength': 100,
  'columns': [ { "orderable": true }, { "orderable": true }, { "orderable": false } ],
  {% include 'scripts/common/table_language.volt' %}
};
var tb_4col_conf = {
  'order': [],
  'pageLength': 100,
  'columns': [ { "orderable": true }, { "orderable": true }, { "orderable": true }, { "orderable": false } ],
  {% include 'scripts/common/table_language.volt' %}
};
var tableBrand;
var tableLine;
var tableSeries;
var tableModelType;
var tableModel;
var tableArticle;
$(document).ready(function(){
  {% if discount is not null %}
  tableBrand      = $('#table-brand').dataTable(tb_3col_conf);
  tableLine       = $('#table-line').dataTable(tb_3col_conf);
  tableSeries     = $('#table-series').dataTable(tb_4col_conf);
  tableModelType  = $('#table-modeltype').dataTable(tb_3col_conf);
  tableModel      = $('#table-model').dataTable(tb_3col_conf);
  tableArticle    = $('#table-article').dataTable(tb_4col_conf);

  var tpdisc_tot = getTpdiscTot();
  checkTabs(tpdisc_tot);

  {% if discount.fltota == 1 %}
  $('#fltota').prop('checked',true);
  {% endif %}

  $('#create-discount').prop('disabled',true);
  $('#dsdisc').prop('disabled',true);
  $('#validity').prop('disabled',true);
  $('#customers-select').prop('disabled',true);
  $('#fltota').prop('disabled',true);
  $('#catalogs-select').prop('disabled',true);
  $('#pricelists-select').prop('disabled',true);

  $('#types-select').change(function(){
    var tpdisc_tot = getTpdiscTot();
    checkTabs(tpdisc_tot);
  });
  {% endif %}
});
{% if discount is null %}
$('#create-discount').click(function(){
  $('#error-fill').hide();
  $('#error-present').hide();

  var cddisc   = $('#cddisc').val();
  var dsdisc   = $('#dsdisc').val();
  var validity = $('#validity').val()
  var cttest   = $('#catalogs-select').val();
  var anagra   = $('#customers-select').val();
  var fltota   = $('#fltota').is(':checked');
  var flpora   = $('#flpora').is(':checked');
  var flpaga   = $('#flpaga').is(':checked');
  var lstest   = $('#pricelists-select').val();
  var tpport   = $('#ports-select').val();
  var tppaga   = $('#payments-select').val();

  var dates_ok = false;
  if (validity != '') {
    var start = validity.split(' - ')[0];
    var end   = validity.split(' - ')[1];
    if (start != null && end != null) {
      var start_el = start.split('/');
      var end_el   = end.split('/');

      if (start_el[2] > 0 && $.isNumeric(start_el[2]) && start_el[2].length == 4 &&
          start_el[1] > 0 && $.isNumeric(start_el[1]) && start_el[1].length == 2 &&
          start_el[0] > 0 && $.isNumeric(start_el[0]) && start_el[0].length == 2 &&
          end_el[2] > 0 && $.isNumeric(end_el[2]) && end_el[2].length == 4 &&
          end_el[1] > 0 && $.isNumeric(end_el[1]) && end_el[1].length == 2 &&
          end_el[0] > 0 && $.isNumeric(end_el[0]) && end_el[0].length == 2) {
        dates_ok = true;
      }
    }
  }

  var tpdisc_tot = getTpdiscTot();

  if (cddisc != '' && dsdisc != '' && dates_ok && cttest != null && tpdisc_tot > 0 && (fltota || anagra != null) && lstest != null && (flpora || tpport != null) && (flpaga || tppaga != null)) {
    var anagra_ok = [];
    if (!fltota) {
      for (var i = 0; i < anagra.length; i++) {
        var opt = $('option.cus_opt[value="' + anagra[i] + '"]');
        anagra_ok.push([ opt.data('tpanag'), opt.data('cdanag') ]);
      }
    }

    var dataJson = JSON.stringify({
      cddisc: cddisc,
      dsdisc: dsdisc,
      dtiniz: start_el[2] + "-" + start_el[1] + "-" + start_el[0],
      dtfine: end_el[2] + "-" + end_el[1] + "-" + end_el[0],
      tpdisc: tpdisc_tot,
      fltota: fltota,
      cttest: cttest,
      anagra: anagra_ok,
      lstest: lstest,
      flpora: flpora,
      tpport: tpport,
      flpaga: flpaga,
      tppaga: tppaga,
    });

    $.ajax({
      type: 'POST',
      url: "{{ url('admin/saveCustomDiscountHeader') }}",
      dataType: 'json',
      data: {
        data: dataJson
      }
    }).done(function(data) {
      if (data['response'] == "OK") {
        $('#discount-body').show();
        $('#discount-body').data('numdis', data['numdis']);
        $('#create-discount').prop('disabled',true);
        $('#dsdisc').prop('disabled',true);
        $('#validity').prop('disabled',true);
        $('#types-select').prop('disabled',true);
        $('#customers-select').prop('disabled',true);
        $('#fltota').prop('disabled',true);
        $('#catalogs-select').prop('disabled',true);
        $('#pricelists-select').prop('disabled',true);

        checkTabs(tpdisc_tot);
        fillDataInVisibleTabs(data);
      } else {
        $('#error-present').show();
      }
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  } else {
    $('#error-fill').show();
  }
});

$('#fltota').click(function(){
  if ($(this).is(':checked')) {
    $('#customers-select').prop('disabled',true);
    $('[data-id=customers-select]').css('opacity','50%')
  } else {
    $('#customers-select').prop('disabled',false);
    $('[data-id=customers-select]').css('opacity','100%')
  }
});

$('#flpora, #flpaga').change(function(e) {
  const check = $(e.currentTarget);
  const select = check.closest('.checkbox-container').prev();
  const isChecked = check.is(':checked');
  if (select.is('.bootstrap-select')) {
    $('select', select).attr('disabled', isChecked).prop('disabled', isChecked).val('').change();
  } else {
    select.attr('disabled', isChecked).prop('disabled', isChecked).val('').change();
  }
});

function fillDataInVisibleTabs(data) {
  if ($('#tab_content_brand tbody').css('display') != 'none') {
    $('#tab_content_brand tbody').html(data['titlin']);
    tableBrand = $('#table-brand').dataTable(tb_3col_conf);
  }
  if ($('#tab_content_line tbody').css('display') != 'none') {
    $('#tab_content_line tbody').html(data['linmod']);
    tableLine = $('#table-line').dataTable(tb_3col_conf);
  }
  if ($('#tab_content_series tbody').css('display') != 'none') {
    $('#tab_content_series tbody').html(data['sermod']);
    tableSeries = $('#table-series').dataTable(tb_4col_conf);
  }
  if ($('#tab_content_modeltype tbody').css('display') != 'none') {
    $('#tab_content_modeltype tbody').html(data['tpmode']);
    tableModelType = $('#table-modeltype').dataTable(tb_3col_conf);
  }
  if ($('#tab_content_models tbody').css('display') != 'none') {
    $('#tab_content_models tbody').html(data['tipolo']);
    tableModel = $('#table-model').dataTable(tb_3col_conf);
  }
  if ($('#tab_content_articles tbody').css('display') != 'none') {
    $('#tab_content_articles tbody').html(data['anaart']);
    tableArticle = $('#table-article').dataTable(tb_4col_conf);
  }
}
{% endif %}

function getTpdiscTot() {
  var tpdisc_tot = 0;
  var tpdisc   = $('#types-select').val();
  if (tpdisc != null) {
    for (var i = 0; i < tpdisc.length; i++) {
      tpdisc_tot += parseInt(tpdisc[i]);
    };
    return tpdisc_tot;
  }
  return 0;
}

function checkTabs(tpdisc_tot) {
  if (tpdisc_tot == 0) {
    $('.save-rules').hide();
    $('#myTab').hide();
  } else {
    $('.save-rules').show();
    $('#myTab').show();
  }

  $('.tab-pane').css('display', 'none');
  $('.tab-pane').removeClass('active').removeClass('in');
  $('#myTab li').css('display', 'none');
  $('#myTab li').removeClass('active');

  if (tpdisc_tot >= 32) {
    tpdisc_tot -= 32;
    $('#tab_brand').closest('li').css('display', '');
    $('#tab_content_brand').css('display', '');
  }
  if (tpdisc_tot >= 16) {
    tpdisc_tot -= 16;
    $('#tab_line').closest('li').css('display', '');
    $('#tab_content_line').css('display', '');
  }
  if (tpdisc_tot >= 8) {
    tpdisc_tot -= 8;
    $('#tab_series').closest('li').css('display', '');
    $('#tab_content_series').css('display', '');
  }
  if (tpdisc_tot >= 4) {
    tpdisc_tot -= 4;
    $('#tab_modeltype').closest('li').css('display', '');
    $('#tab_content_modeltype').css('display', '');
  }
  if (tpdisc_tot >= 2) {
    tpdisc_tot -= 2;
    $('#tab_models').closest('li').css('display', '');
    $('#tab_content_models').css('display', '');
  }
  if (tpdisc_tot >= 1) {
    tpdisc_tot -= 1;
    $('#tab_articles').closest('li').css('display', '');
    $('#tab_content_articles').css('display', '');
  }

  $('#myTab li:visible:first').addClass('active');
  var anchorContent = $('#myTab li:visible:first').find('a').data('anchor');
  $('#' + anchorContent).addClass('active').addClass('in');
}

$('.save-rules').click(function(){
  var discounts = [];
  var numdis = $('#discount-body').data('numdis');
  {% if discount is not null %}
  var tpdisc = getTpdiscTot();
  {% endif %}

  for (var i = 0; i < $('#types-select').val().length; i++) {
    switch (parseInt($('#types-select').val()[i])) {
      case 1:
      $(tableArticle.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': '', 'cdlinm': '', 'cdserm': '', 'cdartn': '', 'cdarti': item.data('cdarti'), 'tpmode': ''});
        }
      })
      break;
      case 2:
      $(tableModel.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': '', 'cdlinm': '', 'cdserm': '', 'cdartn': item.data('cdartn'), 'cdarti': '', 'tpmode': ''});
        }
      })
      break;
      case 4:
      $(tableModelType.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': '', 'cdlinm': '', 'cdserm': '', 'cdartn': '', 'cdarti': '', 'tpmode': item.data('tpmode')});
        }
      })
      break;
      case 8:
      $(tableSeries.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': '', 'cdlinm': item.data('cdlinm'), 'cdserm': item.data('cdserm'), 'cdartn': '', 'cdarti': '', 'tpmode': ''});
        }
      })
      break;
      case 16:
      $(tableLine.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': '', 'cdlinm': item.data('cdlinm'), 'cdserm': '', 'cdartn': '', 'cdarti': '', 'tpmode': ''});
        }
      })
      break;
      case 32:
      $(tableBrand.fnGetNodes()).each(function(){
        var item  = $(this).find('.disc-input');
        var value = item.val();
        if (value > 0) {
          discounts.push({'sconto': value, 'cdtitl': item.data('cdtitl'), 'cdlinm': '', 'cdserm': '', 'cdartn': '', 'cdarti': '', 'tpmode': ''});
        }
      })
      break;
    }
  }

  $.ajax({
    type: 'POST',
    url: "{{ discount is not null ? url('admin/updateCustomDiscount') : url('admin/saveCustomDiscountBody') }}",
    dataType: 'json',
    data: {
      cdbody: discounts,
      numdis: numdis,
      {% if discount is not null %}
      tpdisc: tpdisc,
      {% endif %}
    }
  }).done(function(data) {
    if (data == 'OK') {
      window.location.href = "{{ url('admin/customdiscountlist') }}";
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

$('#validity').daterangepicker({
  {% include "scripts/common/daterangepicker_locale.volt" %}
}, function(start, end, label) {
  console.log(start.toISOString(), end.toISOString(), label);
});
</script>
