<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-group').DataTable({
    'order': [],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "25%" },
      { "orderable": true, "width": "65%" },
      { "orderable": false, "width": "10%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

$('#new-group').click(function(){
  $('#modal-modify-cdregv').val(-1);
  $('#modal-modify-dsregv').val('');
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.newgroup') }}");
});
$('.modify-group').click(function(){
  var row = $(this).closest('tr');
  $('#modal-modify-cdregv').val(row.data('cdregv'));
  $('#modal-modify-dsregv').val(row.data('dsregv'));
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.modifygroup') }}");
});
$('#modify-group').click(function(e){
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/editCustomVarGroup') }}",
    dataType: 'json',
    data: {
      code: $('#modal-modify-cdregv').val(),
      desc: $('#modal-modify-dsregv').val(),
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customgroup') }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('.delete-group').click(function(e){
  var row = $(this).closest('tr');
  $('#modal-delete-cdregv').val(row.data('cdregv'));
});
$('#delete-group').click(function(e){
  var cdregv = $('#modal-delete-cdregv').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCustomVarGroup') }}",
    dataType: 'json',
    data: {
      cdregv: cdregv,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customgroup') }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

</script>
