<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-family').DataTable({
    'order': [],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "10%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "16%" },
      { "orderable": true, "width": "16%" },
      { "orderable": true, "width": "14%" },
      { "orderable": true, "width": "14%" },
      { "orderable": false, "width": "10%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

// Group actions
$('#new-family').click(function(){
  $('#modal-modify-mode').val('i');
  $('#modal-modify-tpvari').val('');
  $('#modal-modify-tpvari').prop('disabled', false);
  $('#modal-modify-dstvar').val('');
  $('#modal-modify-seqrap').val('');
  $('#modal-modify-flobbl').prop('checked', false);
  $('#modal-modify-flbloc').prop('checked', false);
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.newfamily') }}");
});
$('.modify-family').click(function(){
  var row = $(this).closest('tr');
  $('#modal-modify-mode').val('u');
  $('#modal-modify-tpvari').val(row.data('tpvari'));
  $('#modal-modify-tpvari').prop('disabled', true);
  $('#modal-modify-dstvar').val(row.data('dstvar'));
  $('#modal-modify-seqrap').val(row.data('seqrap'));
  $('#modal-modify-flobbl').prop('checked', row.data('flobbl') == 1);
  $('#modal-modify-flbloc').prop('checked', row.data('flbloc') == 1);
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.modifyfamily') }}");
});
$('#modify-family').click(function(e){
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/editCustomVarFamily') }}",
    dataType: 'json',
    data: {
      mode: $('#modal-modify-mode').val(),
      cdregv: "{{ group.cdregv }}",
      tpvari: $('#modal-modify-tpvari').val(),
      dstvar: $('#modal-modify-dstvar').val(),
      seqrap: $('#modal-modify-seqrap').val(),
      flobbl: $('#modal-modify-flobbl').prop('checked') ? 1 : 0,
      flbloc: $('#modal-modify-flbloc').prop('checked') ? 1 : 0,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customfamily/' ~ group.cdregv) }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('.delete-family').click(function(e){
  var row = $(this).closest('tr');
  $('#modal-delete-tpvari').val(row.data('tpvari'));
});
$('#delete-family').click(function(e){
  var tpvari = $('#modal-delete-tpvari').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCustomVarFamily') }}",
    dataType: 'json',
    data: {
      cdregv: "{{ group.cdregv }}",
      tpvari: tpvari,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customfamily/' ~ group.cdregv) }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

</script>
