<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
{% include "scripts/common/user_operations.volt" %}
<script>
    var jsInfo = {
        "tableContentUrl": "{{ url('admin/customersTableContent') }}",
        "editUserUrl": "{{ url('admin/editUser') }}",
        "customersUrl": "{{ url('admin/customers') }}",
        "getCustomersSearchCountUrl": "{{ url('admin/getCustomersSearchCount') }}",
        "createCustomerUserUrl": "{{ url('admin/createCustomerUser') }}",
        "createCustomerUsersUrl": "{{ url('admin/createCustomerUsers') }}",
        "resetUsersPasswordUrl": "{{ url('admin/resetUsersPassword') }}",
        "updateCustomersBanStatusUrl": "{{ url('admin/updateCustomersBanStatus') }}",
        "updateCustomersLoginStatusUrl": "{{ url('admin/updateCustomersLoginStatus') }}",
        "getShippingsForCustomerUrl": "{{ url('admin/getShippingsForCustomer') }}",
        "getNewShippingFormForCustomerUrl": "{{ url('admin/getNewShippingFormForCustomer') }}",
        "deleteCustomerShippingUrl": "{{ url('admin/deleteCustomerShipping') }}",
        "editCustomerShippingUrl": "{{ url('admin/editCustomerShipping') }}",
        "loadBudgetForCustomerUrl": "{{ url('admin/loadBudgetForCustomer') }}",
        "enableCustomerManagement": {{ enableCustomerManagement ? 'true' : 'false' }},

        "resultText": "{{ mt._('_common.searchresult') }}",
        "resultsText": "{{ mt._('_common.searchresults') }}",
        "missingFieldsText": "{{ mt._('_common.missingfields') }}",
        "missingUsernameText": "{{ mt._('_common.form.missingusername') }}",
        "missingPasswordText": "{{ mt._('_common.form.missingpassword') }}",
        "passwordMismatchText": "{{ mt._('_common.form.passwordmismatch') }}",
        "licensesLimitReachedText": "{{ mt._('_common.form.licenseslimitreached') }}",
    };
</script>
{{ javascript_include("js/custom/admin_customers.js") }}

<script>
    var customerDataTable;
    // var buttonCommon = {
    //     exportOptions: {
    //         format: {
    //             body: function ( data, row, column, node ) {
    //                 // Strip $ from salary column to make it numeric
    //                 return column === 1 ?
    //                     data.replace( /[$,]/g, '' ) :
    //                     data;
    //             }
    //         }
    //     }
    // };

    $(document).ready(function () {
        $('input[type="search"]').val('');

        $('#customers-export-data').on('click', (e) => {
            const selected = $(':checkbox[name="status-checkbox[]"]:checked');
            if (selected.length > 0) {
                e.preventDefault();
                e.stopPropagation();
                let href = e.currentTarget.href;
                selected.each((idx, el) => {
                    href += (idx > 0 ? '&' : '?') + 'sel[]=' + el.dataset.cdanag;
                });
                window. open(href, '_blank');
                return false;
            }

            return true;
        });

        {#
        $('#table-customers').DataTable({
          'order': [],
          'otherOptions': {},
          'initComplete': function() {
              $(this.api().table().container()).find('input').parent().wrap('<form>').parent().attr('autocomplete', 'off');
          },
          'bPaginate': false,
          'bInfo': false, // hide showing entries
          'columns': [
            { "orderable": false, "width": "4%" },
            { "orderable": true, /*"width": "11%"*/ },
            { "orderable": true, /*"width": "30%"*/ },
            { "orderable": true, "width": "8%" },
            { "orderable": true, /*"width": "12%"*/ },
            { "orderable": true, /*"width": "12%"*/ },
            { "orderable": true, /*"width": "12%"*/ },
            { "orderable": true, "width": "8%" },
            { "orderable": true, "width": "8%" },
            { "orderable": false, "width": "7%" },
          ],
          {% include 'scripts/common/table_language.volt' %}
        });
        #}

        customerDataTable = $('#table-customers-ajax').DataTable({
            // buttons: [
            //     $.extend( true, {}, buttonCommon, {
            //         extend: 'excelHtml5'
            //     } )
            // ],
            lengthMenu: [
                [250, 500, 1000, 2500],
                [250, 500, 1000, 2500]
            ],
            length: 500,
            ajax: {
                url: jsInfo.tableContentUrl,
                type: 'POST'
            },
            processing: true,
            serverSide: true,
            order: [[1, "asc"]],
            columns: [
                {
                    name: 'checkbox',
                    title: '',
                    data: (data) => {
                        return `<label class="checkbox-customer checkbox-container">
                                  <input type="checkbox" name="status-checkbox[]" value="${data.id_usr}" data-tpanag="${data.tpanag}"  data-cdanag="${data.cdanag}"/>
                                  <span class="checkbox-checkmark"></span>
                                </label>`;
                    }, orderable: false, "width": "4%"
                },
                {
                    name: 'cdanag',
                    title: '{{ mt._('admin.customers.customercode')|escape_js }}',
                    data: 'cdanag',
                    orderable: true /*,"width": "11%"*/
                },
                {
                    name: 'descri',
                    title: '{{ mt._('admin.customers.name')|escape_js }}',
                    data: 'descri',
                    orderable: true /*,"width": "30%"*/
                },
                {
                    name: 'indema',
                    title: '{{ mt._('_common.email')|escape_js }}',
                    data: 'indema',
                    orderable: true /*,"width": "30%"*/
                },
                {
                    name: 'cdblco',
                    title: '{{ mt._('admin.status')|escape_js }}',
                    data: (data) => {
                        // TODO Modificare questa parte prendendo i dati dalla tabella apposita
                        if (jsInfo.enableCustomerManagement) {
                            return `<span>
                                <select class="table-ban form-control input-sm w-100 p-5x ${data.cdblco == 0 ? 'enabled' : 'disabled'}" data-cdanag="${data.cdanag}">
                                  <option value="0" ${data.cdblco == 0 ? 'selected' : ''} class="enabled">{{ mt._('account.customer.ban.0') }}</option>
                                  <option value="1" ${data.cdblco == 1 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.1') }}</option>
                                  <option value="2" ${data.cdblco == 2 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.2') }}</option>
                                  <option value="3" ${data.cdblco == 3 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.3') }}</option>
                                  <option value="4" ${data.cdblco == 4 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.4') }}</option>
                                  <option value="5" ${data.cdblco == 5 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.5') }}</option>
                                  <option value="6" ${data.cdblco == 6 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.6') }}</option>
                                  <option value="999" ${data.cdblco == 999 ? 'selected' : ''} class="disabled">{{ mt._('account.customer.ban.999') }}</option>
                                </select>
                              </span>`;
                        } else {
                            let label = '';
                            switch (parseInt(data.cdblco)) {
                                case 1:
                                    label = '{{ mt._('account.customer.ban.1')|escape_js }}';
                                    break;
                                case 2:
                                    label = '{{ mt._('account.customer.ban.2')|escape_js }}';
                                    break;
                                case 3:
                                    label = '{{ mt._('account.customer.ban.3')|escape_js }}';
                                    break;
                                case 4:
                                    label = '{{ mt._('account.customer.ban.4')|escape_js }}';
                                    break;
                                case 5:
                                    label = '{{ mt._('account.customer.ban.5')|escape_js }}';
                                    break;
                                case 6:
                                    label = '{{ mt._('account.customer.ban.6')|escape_js }}';
                                    break;
                                case 999:
                                    label = '{{ mt._('account.customer.ban.999')|escape_js }}';
                                    break;
                                case 0:
                                default:
                                    label = '{{ mt._('account.customer.ban.0')|escape_js }}';
                                    break;
                            }
                            return `<span>${label}</span>`;
                        }
                    }, orderable: true, "width": "8%"
                },
                {
                    name: 'catalogs',
                    title: '{{ mt._('admin.catalogs')|escape_js }}',
                    data: (data) => {
                        const catalogsCount = parseInt(data.catalogsCount) || 0;
                        const list = data.catalogs ?? '-';
                        let label = '-';
                        if (catalogsCount > 0) {
                            label = catalogsCount + ' ' + (catalogsCount > 1 ? '{{ mt._('admin.catalogs')|escape_js }}' : '{{ mt._('admin.catalog')|escape_js }}');
                        }
                        let tooltip = '';
                        if (list !== '' && list !== '-') {
                            tooltip = `<span class="glyphicon glyphicon-bookmark mytooltip fr fs13 mt-5x" aria-hidden="true"><span class="tooltiptext">${list}</span></span>`;
                        }
                        return `<span class="lowercase">${label}</span>${tooltip}
                    `;
                    }, orderable: false /*,"width": "12%"*/
                },
                {
                    name: 'shippings',
                    title: '{{ mt._('_common.shippings')|escape_js }}',
                    data: (data) => {
                        const shippingsCount = parseInt(data.shippingsCount) || 0;
                        const list = data.shippings ?? '-';
                        let label = '-';
                        if (shippingsCount > 0) {
                            label = shippingsCount + ' ' + (shippingsCount > 1 ? '{{ mt._('_common.shippings')|escape_js }}' : '{{ mt._('_common.shipping')|escape_js }}');
                        }
                        let tooltip = '';
                        // if (list !== '' && list !== '-') {
                        //     tooltip = `<span class="glyphicon glyphicon-bookmark mytooltip fr fs13 mt-5x" aria-hidden="true"><span class="tooltiptext">${list}</span></span>`;
                        // }
                        return `<span class="lowercase">${label}</span>${tooltip}`;
                    }, orderable: false /*,"width": "12%"*/
                },
                {
                    name: 'username',
                    title: '{{ mt._('admin.username')|escape_js }}',
                    data: 'username',
                    orderable: true /*,"width": "12%"*/
                },
                {
                    name: 'enabled',
                    title: '{{ mt._('admin.customer.canlogin')|escape_js }}',
                    data: (data) => {
                        if (data.id_usr && data.id_usr > 0) {
                            return `<span>
                            <select class="table-status form-control input-sm w-100 p-5x ${data.enabled == 0 ? 'disabled' : 'enabled'}"
                                    data-idusr="${data.id_usr}" data-type="enabled">
                              <option value="0" class="disabled" ${data.enabled == 0 ? 'selected' : ''}>{{ mt._('admin.disabled') }}</option>
                              <option value="1" class="enabled" ${data.enabled == 1 ? 'selected' : ''}>{{ mt._('admin.enabled') }}</option>
                            </select>
                            <div class="msg-form-error-row left" id="login-enabled-error-${data.id_usr}"></div>
                          </span>`;
                        }
                        return '';

                    }, orderable: true, "width": "8%"
                },
                {
                    name: 'orders_enabled',
                    title: '{{ mt._('admin.customer.canorder')|escape_js }}',
                    data: (data) => {
                        if (data.id_usr && data.id_usr > 0) {
                            return `<span>
                            <select class="table-status form-control input-sm w-100 p-5x ${data.orders_enabled == 0 ? 'disabled' : 'enabled'}"
                                    data-idusr="${data.id_usr}" data-type="orders_enabled">
                              <option value="0" class="disabled" ${data.orders_enabled == 0 ? 'selected' : ''}>{{ mt._('admin.disabled') }}</option>
                              <option value="1" class="enabled" ${data.orders_enabled == 1 ? 'selected' : ''}>{{ mt._('admin.enabled') }}</option>
                            </select>
                            <div class="msg-form-error-row left" id="login-orders-enabled-error-${data.id_usr}"></div>
                          </span>`;
                        }
                        return '';

                    }, orderable: true, "width": "8%"
                },
                {
                    name: 'actions',
                    title: '',
                    data: (data) => {
                        return `<div class="action-wrapper center" style="vertical-align:middle"
                            data-tpanag="${data.tpanag}" data-cdanag="${data.cdanag}" data-cdblco="${data.cdblco}"
                            data-descri="${data.descri}" data-idusr="${data.id_usr != -1 ? data.id_usr : ''}"
                            data-username="${data.username}" data-enabled="${data.enabled}" data-ordersenabled="${data.orders_enabled}"
                            data-catalogs="${data.catalogs}" data-shippings="${data.shippings}" >
                            <span data-toggle="modal" data-target=".modal-modify-user">
                              <a href="#" class="modify-user" title="{{ mt._('admin.customers.modifycustomer') }}">
                                <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                              </a>
                            </span>
                            <span class="pl-20x" data-toggle="modal" data-target=".modal-manage-shippings">
                              <a href="#" class="manage-shippings" title="{{ mt._('admin.customers.manageshippings') }}">
                                <span class="glyphicon glyphicon-send" aria-hidden="true"></span>
                              </a>
                            </span>
                            {% if enableBudget %}
                            <span class="pl-20x" data-toggle="modal" data-target=".modal-show-budget">
                              <a href="#" class="show-budget" title="{{ mt._('_common.budget') }}">
                                <span class="glyphicon glyphicon-euro" aria-hidden="true"></span>
                              </a>
                            </span>
                            {% endif %}</div>`;
                    }, orderable: false, "width": "7%"
                },
            ],
            {% include 'scripts/common/table_language.volt' %}
        });
    });
</script>
