<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-discount').DataTable({
    'order': [],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "5%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": false, "width": "10%" },
      { "orderable": false, "width": "5%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

$('.table-discount-status').change(function(){
  var select = $(this);
  var numdis = $(this).closest('tr').data('numdis');
  var flbloc = $(this).val();
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/changecustomdiscountstatus') }}",
    dataType: 'json',
    data: {
      numdis: numdis,
      flbloc: flbloc,
    }
  }).done(function(data) {
    if (flbloc == 1) {
      select.addClass('disabled');
      select.removeClass('enabled');
    } else {
      select.addClass('enabled');
      select.removeClass('disabled');
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

$('.delete-discount').click(function(e){
  var row = $(this).closest('tr');
  $('#modal-delete-numdis').val(row.data('numdis'));
});

$('#delete-discount').click(function(e){
  var numdis = $('#modal-delete-numdis').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCustomDiscount') }}",
    dataType: 'json',
    data: {
      numdis: numdis,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customdiscountlist') }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
