<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
{{ javascript_include("js/helpers/jq-json-array-inputs.js") }}
{#{{ stylesheet_link("vendors/select2/dist/css/select2.min.css") }}
{{ javascript_include("vendors/select2/dist/js/select2.min.js") }}#}
{#{{ javascript_include("vendors/select2/dist/js/i18n/"~ 'it' ~".js") }}#}
{{ stylesheet_link("css/bootstrap-select.css") }}
{{ javascript_include("js/bootstrap-select.min.js") }}
<script>
    $(document).ready(function () {
        $('#table-cond').DataTable({
            'order': [],
            'pageLength': 100,
            'columns': [
                {"orderable": false, "width": "4%"},
                {"orderable": true, "width": "23%"},
                {"orderable": true, "width": "34%"},
                {"orderable": true, "width": "9%"},
                {"orderable": false, "width": "3%"},
                //
            ],
            {% include 'scripts/common/table_language.volt' %}
        });

        // $('.select2').select2({closeOnSelect: false});

        $('.modal-edit-cond').on('click', '.btn-edit-toggle', (e) => {
            const $btn = $(e.currentTarget);
            const $icon = $btn.find('i');
            const enableForm = $icon.hasClass('fa-pencil-square-o');
            const $form = $btn.closest('.jai-elemento-lista').find('.editable-view');
            $form.find(':input').prop('readonly', !enableForm).attr('readonly', !enableForm);
            $icon.toggleClass('fa-floppy-o fa-pencil-square-o');
        });

        $('#modal-edit-config').jqJsonArrayInputs({
            "title": 'Condizioni Personalizzate',
            "fnGetItemContent": (item) => {
                const emptyElement = item == null || Object.keys(item).length === 0;

                return `
          <div class="editable-view form-horizontal ${emptyElement ? 'new-element' : 'existent-element'}">
            <div class="row">
                <div class="col-xs-12">
                    <label>Intervallo</label>
                    <div class="input-group mb-5">
                        <input type="number" min="0" step="0.01" value="${item?.valmin ?? ''}" data-bind="valmin" ${emptyElement ? '' : 'readonly'} class="form-control input-sm" />
                        <span class="input-group-addon"><i class="fa fa-arrows-h"></i></span>
                        <input type="number" min="0" step="0.01" value="${item?.valmax ?? ''}" data-bind="valmax" ${emptyElement ? '' : 'readonly'} class="form-control input-sm" />
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <label>Costo Agg.</label>
                    <input type="number" min="0" step="0.01" value="${item?.preagg ?? ''}" data-bind="preagg" ${emptyElement ? '' : 'readonly'} class="form-control input-sm" />
                </div>
            </div>
          </div>
        `;
            },
            "fnGetItemButtons": (item) => {
                const emptyElement = item == null || Object.keys(item).length === 0;
                return `<div class="btn-group-vertical" role="group">
            <button type="button" class="btn btn-xs btn-info btn-edit-toggle" title="Abilita/Disabilita la modifica di questo elemento">
              <i class="fa fa-fw ${emptyElement ? 'fa-floppy-o' : 'fa-pencil-square-o'}"></i>
            </button>
            <button type="button" class="btn btn-xs btn-danger rimuovi" title="Cancella">
              <i class="fa fa-fw fa-trash-o"></i>
            </button>
          </div>`;
            },
            "fnAfterItemCreated": (elementLi, item) => {
                console.log('fnAfterItemCreated');
            },
        });

        function resetModal(row) {
            $('#modal-edit-countries option').prop('selected', false);
            // $("#modal-edit-countries").val(['ALL']).select2("val", ['ALL']);
            $("#modal-edit-countries").val(['ALL']);
            if (row !== undefined) {
                $('.modal-edit-cond .modal-title').html("{{ mt._('admin.condition.edit') }}");
                $('#modal-edit-numpag').val(row.dataset.numpag);
                $('#modal-edit-tppaga').val(row.dataset.tppaga);
                $('#modal-edit-config').val(row.dataset.config).data('initialValue', row.dataset.config).data('jaiInitialValue', $(row).data('config'));
                var cdnazi = row.dataset.cdnazi.split(",");
                //for (var i = 0; i < cdnazi.length; i++) {
                //    $('#modal-edit-countries option[value="' + cdnazi[i] + '"]').prop('selected', true);
                //}
                // $("#modal-edit-countries").val(cdnazi).select2("val", cdnazi);
                $("#modal-edit-countries").val(cdnazi);
            } else {
                $('.modal-edit-cond .modal-title').html("{{ mt._('admin.condition.new') }}");
                $('#modal-edit-numpor').val(-1);
                $('#modal-edit-tpport option:first').prop('selected', true);
                $('#modal-edit-config').val('[]').data('initialValue', '[]').data('jaiInitialValue', []);
            }
            // $("#modal-edit-countries").trigger("change")
            $("#modal-edit-countries").selectpicker('refresh');
            $('#modal-edit-config').jqJsonArrayInputs('render');
        }

        $('.modify-cond').click((e) => {
            console.log(e, e.currentTarget);
            resetModal(e.currentTarget.closest('tr'))
        });
        $('#new-cond').click((e) => resetModal());
        $('#del-cond').click(function (e) {
            $('#modal-delete-numpag').val('');
            let multi_numpag = '';
            $('input[type="checkbox"]:checked').each(function () {
                if (multi_numpag != '')
                    multi_numpag += ',';
                multi_numpag += $(this).closest('tr').data('numpag');
            });
            $('#modal-delete-multi-numpag').val(multi_numpag);
        });
        $('#delete-cond').click(function(e){
            var numpag = $('#modal-delete-numpag').val();
            var multi_numpag = $('#modal-delete-multi-numpag').val();

            $.ajax({
                type: 'POST',
                url: "{{ url('admin/deleteCustomPayment') }}",
                dataType: 'json',
                data: {
                    numpag: numpag,
                    multi_numpag: multi_numpag,
                }
            }).done(function(data) {
                location.reload();
            }).error(function(x, t, m) {
                printAjaxError(x, t, m);
            });
        });

        $('#save-cond').click(function (e) {
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/saveCustomPayment') }}",
                dataType: 'json',
                data: {
                    tppaga: $('#modal-edit-tppaga').val(),
                    dspaga: $('#modal-edit-tppaga option:selected').data('dspaga'),
                    config: $('#modal-edit-config').val(),
                    initial_config: $('#modal-edit-config').data('initialValue'),
                    codici_nazioni: $('#modal-edit-countries').val(),
                }
            }).done(function (data) {
                location.reload();
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });

        $('[data-toggle="tooltip"]').tooltip();
    });


</script>
