<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<!-- Bootstrap Multiselect -->
{{ javascript_include("js/bootstrap-multiselect.js") }}
<script>
$(document).ready(function() {
  $('#catalogs-select').multiselect({
    nonSelectedText:  "{{ mt._('ms.selectcatalogs') }}",
    allSelectedText:  "{{ mt._('ms.allselected') }}",
    selectAllText:    "{{ mt._('ms.selectall') }}",
    nSelectedText:    "{{ mt._('ms.selected') }}",
    maxHeight: 205,
    includeSelectAllOption: true,
    numberDisplayed: 1,
    enableFiltering: true,
  });
  $('#agents-select').multiselect({
    nonSelectedText:  "{{ mt._('ms.selectagents') }}",
    allSelectedText:  "{{ mt._('ms.allselected') }}",
    selectAllText:    "{{ mt._('ms.selectall') }}",
    nSelectedText:    "{{ mt._('ms.selected') }}",
    maxHeight: 205,
    includeSelectAllOption: true,
    numberDisplayed: 1,
    enableFiltering: true,
  });
  $('#customers-select').multiselect({
    nonSelectedText:  "{{ mt._('ms.selectcustomers') }}",
    allSelectedText:  "{{ mt._('ms.allselected') }}",
    selectAllText:    "{{ mt._('ms.selectall') }}",
    nSelectedText:    "{{ mt._('ms.selected') }}",
    maxHeight: 205,
    includeSelectAllOption: true,
    numberDisplayed: 1,
    enableFiltering: true,
  });
  $('#shippings-select').multiselect({
    nonSelectedText:  "{{ mt._('ms.selectshippings') }}",
    allSelectedText:  "{{ mt._('ms.allselected') }}",
    selectAllText:    "{{ mt._('ms.selectall') }}",
    nSelectedText:    "{{ mt._('ms.selected') }}",
    maxHeight: 205,
    includeSelectAllOption: true,
    numberDisplayed: 1,
    enableFiltering: true,
  });
});
$('input[name="radio-usage"]').change(function(){
  $("#limit").val("");
  if ($('input[name="radio-usage"]:checked').val() != 0) {
    $("#limit").show();
  } else {
    $("#limit").hide();
  }
});
$('input[name="radio-catalogs"]').change(function(){
  if ($('input[name="radio-catalogs"]:checked').val() == 0) {
    $("#row-catalogs").hide();
  } else {
    $("#row-catalogs").show();
  }
});
$('input[name="radio-type"]').change(function(){
  var value = $('input[name="radio-type"]:checked').val();
  $('input[name="radio-type2"][value="0"]').prop('checked', true);

  $("#row-agents").hide();
  $("#row-customers").hide();
  $("#row-shippings").hide();

  if (value != 0) {
    $("#row-type2").show();
  } else {
    $("#row-type2").hide();
  }
});
$('input[name="radio-type2"]').change(function(){
  var value = $('input[name="radio-type"]:checked').val();
  var value2 = $('input[name="radio-type2"]:checked').val();
  if (value2 == 0) {
    $("#row-agents").hide();
    $("#row-customers").hide();
    $("#row-shippings").hide();
  } else {
    switch (parseInt(value)) {
      case 1:
      $("#row-agents").show();
      $("#row-customers").hide();
      $("#row-shippings").hide();
      break;
      case 3:
      $("#row-agents").hide();
      $("#row-customers").show();
      $("#row-shippings").hide();
      break;
      case 5:
      $("#row-agents").hide();
      $("#row-customers").hide();
      $("#row-shippings").show();
      break;
    }
  }
});

{% include "scripts/common/daterangepicker_config.volt" %}
$('#period-box').daterangepicker(drpConfig, function(start, end, label) {
  $('#period-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
  $('#period').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
});
$("#new-coupon").click(function(){
  $("#modal-title-edit").html("{{ mt._('admin.coupon.new') }}");
  $("#mode").val("new");
  $("#row-code").hide();
  $("#dscoup").val("");
  $("#tpcoup").val("");
  $("#row-amount").hide();
  $("#impsco").val("");
  $("#period").val("");
  $("#qtamin").val("");
  $("#qtamax").val("");
  $("input[name='radio-usage'][value='0']").prop("checked", true);
  $("#limit").hide();
  $("#limit").val("");
  $("input[name='radio-catalogs'][value='0']").prop("checked", true);
  $("#row-catalogs").hide();
  $("input[name='radio-type'][value='0']").prop("checked", true);
  $("#row-type2").hide();
  $("input[name='radio-type2'][value='0']").prop("checked", true);
  $("#catalogs-select").multiselect('deselectAll', false);
  $("#catalogs-select").multiselect('refresh');
  $("#agents-select").multiselect('deselectAll', false);
  $("#agents-select").multiselect('refresh');
  $("#customers-select").multiselect('deselectAll', false);
  $("#customers-select").multiselect('refresh');
  $("#shippings-select").multiselect('deselectAll', false);
  $("#shippings-select").multiselect('refresh');
});
$(".modify-coupon").click(function(){
  $("#modal-title-edit").html("{{ mt._('admin.coupon.modifycoupon') }}");
  $("#mode").val("edit");
  $("#row-code").show();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/getCoupon') }}",
    dataType: 'json',
    data: {
      cdcoup: $(this).data('cdcoup'),
    }
  }).done(function(data) {
    if (data != "CP") {
      var coupon    = data['coupon'];
      var catalogs  = data['catalogs'];
      var users     = data['users'];
      $("#modal-coupon-code").html(coupon.cdcoup);
      $("#dscoup").val(coupon.dscoup);
      $("#tpcoup").val(coupon.tpcoup);
      if (coupon.tpcoup != 0) {
        $("#row-amount").show();
        $("#impsco").val(coupon.impsco);
      } else {
        $("#row-amount").hide();
        $("#impsco").val("");
      }
      var dtiniz = coupon.dtiniz.split('-');
      var dtfine = coupon.dtfine.split('-');
      $("#period").val(dtiniz[2] + "/" + dtiniz[1] + "/" + dtiniz[0] + " - " + dtfine[2] + "/" + dtfine[1] + "/" + dtfine[0]);
      $("#qtamin").val(coupon.qtamin);
      $("#qtamax").val(coupon.qtamax);
      if (coupon.cpnmax != 0) {
        $("input[name='radio-usage'][value='1']").prop("checked", true);
        $("#limit").show();
        $("#limit").val(coupon.cpnmax);
      } else if (coupon.usrmax != 0) {
        $("input[name='radio-usage'][value='2']").prop("checked", true);
        $("#limit").show();
        $("#limit").val(coupon.usrmax);
      } else {
        $("input[name='radio-usage'][value='3']").prop("checked", true);
        $("#limit").hide();
        $("#limit").val("");
      }
      if (coupon.tpcata == 0) {
        $("input[name='radio-catalogs'][value='0']").prop("checked", true);
        $("#row-catalogs").hide();
        $("#catalogs-select").multiselect('deselectAll', false);
      } else {
        $("input[name='radio-catalogs'][value='1']").prop("checked", true);
        $("#row-catalogs").show();
        for (var i = 0; i < catalogs.length; i++) {
          $("#catalogs-select").multiselect('select', catalogs[i].cdcata);
        }
        $("#catalogs-select").multiselect('refresh');
      }
      switch (coupon.tpuser) {
      case "0":
        $("input[name='radio-type'][value='0']").prop("checked", true);
        $("input[name='radio-type2'][value='0']").prop("checked", true);
        $("#row-type2").hide();
        $("#row-agents").hide();
        $("#row-customers").hide();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        $("#customers-select").multiselect('deselectAll', false);
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "1":
        $("input[name='radio-type'][value='1']").prop("checked", true);
        $("input[name='radio-type2'][value='0']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").hide();
        $("#row-customers").hide();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        $("#customers-select").multiselect('deselectAll', false);
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "2":
        $("input[name='radio-type'][value='1']").prop("checked", true);
        $("input[name='radio-type2'][value='1']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").show();
        $("#row-customers").hide();
        $("#row-shippings").hide();
        for (var i = 0; i < users.length; i++) {
          $("#agents-select").multiselect('select', users[i].id_usr);
        }
        $("#customers-select").multiselect('deselectAll', false);
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "3":
        $("input[name='radio-type'][value='3']").prop("checked", true);
        $("input[name='radio-type2'][value='0']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").hide();
        $("#row-customers").hide();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        $("#customers-select").multiselect('deselectAll', false);
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "4":
        $("input[name='radio-type'][value='3']").prop("checked", true);
        $("input[name='radio-type2'][value='1']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").hide();
        $("#row-customers").show();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        for (var i = 0; i < users.length; i++) {
          $("#customers-select").multiselect('select', users[i].id_usr);
        }
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "5":
        $("input[name='radio-type'][value='5']").prop("checked", true);
        $("input[name='radio-type2'][value='0']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").hide();
        $("#row-customers").hide();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        $("#customers-select").multiselect('deselectAll', false);
        $("#shippings-select").multiselect('deselectAll', false);
        break;
      case "6":
        $("input[name='radio-type'][value='1']").prop("checked", true);
        $("input[name='radio-type2'][value='1']").prop("checked", true);
        $("#row-type2").show();
        $("#row-agents").hide();
        $("#row-customers").show();
        $("#row-shippings").hide();
        $("#agents-select").multiselect('deselectAll', false);
        $("#customers-select").multiselect('deselectAll', false);
        for (var i = 0; i < users.length; i++) {
          $("#shippings-select").multiselect('select', users[i].id_usr);
        }
        break;
      }
      $("#agents-select").multiselect('refresh');
      $("#customers-select").multiselect('refresh');
      $("#shippings-select").multiselect('refresh');
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$("#tpcoup").change(function(){
  if ($(this).val() == 0) {
    $("#row-amount").hide();
  } else {
    $("#impsco").val("");
    $("#row-amount").show();
  }
});
$('#save-coupon').click(function(){
  var dscoup = $('#dscoup').val();
  var tpcoup = $('#tpcoup').val();
  var impsco = $('#tpcoup').val() != 0 ? $("#impsco").val() : 0;
  var dtiniz = $('#period').val().split(' - ')[0];
  var dtfine = $('#period').val().split(' - ')[1];
  var qtamin = $('#qtamin').val();
  var qtamax = $('#qtamax').val();
  var cpnmax = $("input[name='radio-usage']:checked").val() != 1 ? 0 : $("#limit").val();
  var usrmax = $("input[name='radio-usage']:checked").val() != 2 ? 0 : $("#limit").val();
  var tpcata = $("input[name='radio-catalogs']:checked").val();
  var catalogs = $("#catalogs-select").val();
  var tpuser = parseInt($("input[name='radio-type']:checked").val()) + ($("input[name='radio-type']:checked").val() != 0 ? parseInt($("input[name='radio-type2']:checked").val()) : 0);
  var agents = $("#agents-select").val();
  var customers = $("#customers-select").val();
  var shippings = $("#shippings-select").val();

  $('.msg-success').hide();
  $('.msg-error').hide();
  $('.msg-form-error').show();

  if (dscoup.trim() == "") {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.coupon.missingdescription') }}", 10000);
  } else if (tpcoup != 0 && !$.isNumeric(impsco)) {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.coupon.missingamount') }}", 10000);
  } else if ($("#period").val() == "") {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.coupon.missingperiod') }}", 10000);
  } else if ((qtamin != "" && !$.isNumeric(qtamin)) || (qtamax != "" && !$.isNumeric(qtamax))) {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.coupon.missingqty') }}", 10000);
  } else if (($("input[name='radio-usage']:checked").val() == 1 && (cpnmax == "" || cpnmax == 0)) ||
    ($("input[name='radio-usage']:checked").val() == 2 && (usrmax == "" || usrmax == 0))) {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.coupon.missinglimit') }}", 10000);
  } else {
    $("#save-coupon").prop("disabled",true);
    if ($("input#mode").val() == "new") {
      $.ajax({
        type: 'POST',
        url: "{{ url('admin/createCoupon') }}",
        dataType: 'json',
        data: {
          dscoup: dscoup,
          tpcoup: tpcoup,
          impsco: impsco,
          dtiniz: dtiniz,
          dtfine: dtfine,
          qtamin: qtamin != "" ? qtamin : 0,
          qtamax: qtamax != "" ? qtamax : 0,
          cpnmax: cpnmax,
          usrmax: usrmax,
          tpcata: tpcata,
          tpuser: tpuser,
          catalogs: catalogs,
          agents: agents,
          customers: customers,
          shippings: shippings,
        }
      }).done(function(data) {
        if (data == "OK") {
          $('.msg-error').hide();
          showTemporary(".msg-success", 2000);
          setTimeout( function(){
            location.href = "{{ url('admin/coupon') }}";
          }, 2000 );
        } else {
          $('.msg-success').hide();
          showTemporary(".msg-error", 2000);
        }
        $("#save-coupon").prop("disabled",false);
      }).error(function(x, t, m) {
    		printAjaxError(x, t, m);
        $("#save-coupon").prop("disabled",false);
      });
    } else {
      $.ajax({
        type: 'POST',
        url: "{{ url('admin/modifyCoupon') }}",
        dataType: 'json',
        data: {
          cdcoup: $("#modal-coupon-code").html(),
          dscoup: dscoup,
          tpcoup: tpcoup,
          impsco: impsco,
          dtiniz: dtiniz,
          dtfine: dtfine,
          qtamin: qtamin != "" ? qtamin : 0,
          qtamax: qtamax != "" ? qtamax : 0,
          cpnmax: cpnmax,
          usrmax: usrmax,
          tpcata: tpcata,
          tpuser: tpuser,
          catalogs: catalogs,
          agents: agents,
          customers: customers,
          shippings: shippings,
        }
      }).done(function(data) {
        if (data == "OK") {
          $(".msg-error").hide();
          showTemporary(".msg-success", 2000);
          setTimeout( function(){
            location.href = "{{ url('admin/coupon') }}";
          }, 2000 );
        } else {
          $(".msg-success").hide();
          showTemporary(".msg-error", 2000);
        }
        $("#save-coupon").prop("disabled",false);
      }).error(function(x, t, m) {
    		printAjaxError(x, t, m);
        $("#save-coupon").prop("disabled",false);
      });
    }
  }
});
$("#delete-coupon").click(function(){
  var coupons = [];
  $("input[name='status-checkbox[]']:checked").each(function(){
    coupons.push($(this).val());
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCoupons') }}",
    dataType: 'json',
    data: {
      coupons: coupons,
    }
  }).done(function(data) {
    if (data == "OK") {
      $(".msg-error").hide();
      showTemporary(".msg-success", 2000);
      setTimeout( function(){
        location.href = "{{ url('admin/coupon') }}";
      }, 2000 );
    } else {
      $(".msg-success").hide();
      showTemporary(".msg-error", 2000);
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
