{{ javascript_include("vendors/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js") }}

<script>
$(function () {
  $('.color-picker').colorpicker({
    format: 'hex',
    useAlpha: false
  }).on('changeColor', function(e) {
    var color = $(this).val();
    var section = $(this).closest('.color-picker-section');

    if ($(this).hasClass('color-picker1')) {
      section.find('.color-picker-preview1').css('background-color', '#' + color);
    } else if ($(this).hasClass('color-picker2')) {
      section.find('.color-picker-preview2').css('background-color', '#' + color);
    } else if ($(this).hasClass('color-picker3')) {
      section.find('.color-picker-preview3').css('background-color', '#' + color);
    }
  });
});

$('.source-picker').change(function(){
  switch(parseInt($(this).val())) {
  case 1:
    $(this).closest('.color-picker-row').find('.color-picker-section').show();
    $(this).closest('.color-picker-row').find('.load-image-section').hide();
    break;
  case 2:
    $(this).closest('.color-picker-row').find('.color-picker-section').hide();
    $(this).closest('.color-picker-row').find('.load-image-section').show();
    break;
  default:
    $(this).closest('.color-picker-row').find('.color-picker-section').hide();
    $(this).closest('.color-picker-row').find('.load-image-section').hide();
    break;
  }
});

$('.color').change(function(){
  var picker;
  var preview;
  if ($(this).hasClass('color2')) {
    picker = $(this).closest('.color-picker-row').find('.color-picker2');
    preview = $(this).closest('.color-picker-row').find('.color-picker-preview2');
  } else if ($(this).hasClass('color3')) {
    picker = $(this).closest('.color-picker-row').find('.color-picker3');
    preview = $(this).closest('.color-picker-row').find('.color-picker-preview3');
  }
  if ($(this).is(':checked')) {
    picker.removeClass('disabled');
    picker.prop('disabled', false);
  } else {
    picker.addClass('disabled');
    picker.prop('disabled', true);
    picker.val('');
    preview.css('background-color', '');
  }
});

$('.color-image-loader-input').on("change", function(){
  var file = $(this).val().split('\\').pop();
  var imageUrl = '../upload/colors/' + file;
  $(this).closest('.load-image-section').find('.color-image-loader-file').html(file);
  $(this).closest('.load-image-section').find('.color-image-preview').css('background-image', 'url(' + imageUrl + ')');

  var form_data = new FormData();

  var file_data = $(this).prop('files')[0];
  form_data.append('file', file_data);

  $.ajax({
    type:'POST',
    method:'POST',
    url: "{{ url('admin/uploadColorImage') }}",
    data: form_data,
    cache: false,
    contentType: false,
    processData: false,
    success:function(){ },
    error: function(x,t,m){ }
  });
});

$('.save-btn').click(function(){
  $(".msg-error").hide();
  $(".msg-success").hide();

  var colors = []
  $('.source-picker').each(function(){
    var code = $(this).closest('.color-picker-row').data('codice');
    var file = $(this).closest('.color-picker-row').find('.color-image-loader-file').html();
    var rgb1 = $(this).closest('.color-picker-row').find('.color-picker1').val();
    var rgb2 = $(this).closest('.color-picker-row').find('.color-picker2').val();
    var rgb3 = $(this).closest('.color-picker-row').find('.color-picker3').val();

    var optionSelected = $(this).val();

    if (optionSelected > 0) {
      switch (parseInt(optionSelected)) {
      case 1:
        colors.push({
          'codice': code,
          'rgbcd1': rgb1.substring(1),
          'rgbcd2': rgb2.substring(1),
          'rgbcd3': rgb3.substring(1),
          'flimag': '',
          'flmult': 0
        });
        break;
      case 2:
        colors.push({
          'codice': code,
          'rgbcd1': '',
          'rgbcd2': '',
          'rgbcd3': '',
          'flimag': file,
          'flmult': 0
        });
        break;
      case 3:
        colors.push({
          'codice': code,
          'rgbcd1': '',
          'rgbcd2': '',
          'rgbcd3': '',
          'flimag': '',
          'flmult': 1
        });
        break;
      }
    }
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveColors') }}",
    dataType: 'json',
    data: {
      colors: colors,
    }
  }).done(function(data) {
    $(".msg-error").hide();
    showTemporary(".msg-success", 2000);
  }).error(function(x, t, m) {
    $(".msg-success").hide();
    showTemporary(".msg-error", 2000);
    printAjaxError(x, t, m);
  });
});
</script>
