<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<script>
{% include "scripts/common/daterangepicker_config.volt" %}
$(document).ready(function() {
  var table = $('#table-articles').DataTable({
    'order': [],
    'otherOptions': {},
    'bPaginate': true,
    'pageLength': 100,
    'bInfo': false, // hide showing entries
    'columns': [
      { "orderable": true, "width": "10%" },
      { "orderable": true, "width": "10%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "20%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });

  $('input[type="checkbox"]').click(function() {
    updateFilters();
  });

  $('#period-box').daterangepicker(drpConfig3, function(start, end, label) {
    $('#period-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    $('#period').val(start.format('YYYY-MM-DD') + ',' + end.format('YYYY-MM-DD'));
    updateFilters();
  });

  function updateFilters() {
    var catalogsChecked = [];
    var seasonsChecked = [];
    $('input[name="catalog-checkbox[]"]:checked').each(function(){
      catalogsChecked.push($(this).val());
    });
    $('input[name="season-checkbox[]"]:checked').each(function(){
      seasonsChecked.push($(this).val());
    });
    $.fn.dataTable.ext.search.pop();

    $.fn.dataTable.ext.search.push(
      function(settings, data, dataIndex) {
        var shouldAdd = true;

        if (catalogsChecked.length > 0) {
          shouldAdd &= $.inArray($(table.row(dataIndex).node()).attr('data-cdcata'), catalogsChecked) >= 0;
        }

        if (seasonsChecked.length > 0) {
          shouldAdd &= $.inArray($(table.row(dataIndex).node()).attr('data-cdstag'), seasonsChecked) >= 0;
        }

        if ($('#period').val() != '') {
          var dates = $('#period').val().split(',');
          var startDate = moment(dates[0], "YYYY-MM-DD");
          var endDate = moment(dates[1], "YYYY-MM-DD");

          shouldAdd &= moment($(table.row(dataIndex).node()).attr('data-dtcrea'), "YYYY-MM-DD") >= startDate;
          shouldAdd &= moment($(table.row(dataIndex).node()).attr('data-dtcrea'), "YYYY-MM-DD") <= endDate;
        }

        return shouldAdd;
      }
    );

    table.draw();
  }

  function getRows() {
    var rows = [];
    table.rows( { search: 'applied' } ).nodes().each(function() {
      var cdarti = $(this).data('cdarti');
      var quanti = $(this).data('quanti');
      var nuordc = $(this).data('nuordc');
      var cdcata = $(this).data('cdcata');
      var cdstag = $(this).data('cdstag');
      var dtcrea = $(this).data('dtcrea-human');
      rows.push({cdarti, quanti, nuordc, cdcata, cdstag, dtcrea});
    });
    return rows;
  }

/*
  $('#download-csv').click(function() {
    var rows = getRows();
    if (rows.length > 0) {
      $.ajax({
        type: "POST",
        url: "{{ url('admin/downloadCheckPricesCsv') }}",
        dataType: "json",
        data: {
          articles: rows,
        }
      }).done(function(data) {
        if (data != '') {
          // download
          var link = document.createElement('a');
          link.href = data['fullPath'];
          link.download = data['filename'];
          document.body.appendChild(link);
          link.click();
        }
      }).error(function(x, t, m) {
        printAjaxError(x, t, m);
      });
    }
  });*/

  $('#download-csv').click(function() {
    var catalogsChecked = [];
    var seasonsChecked = [];
    $('input[name="catalog-checkbox[]"]:checked').each(function(){
      catalogsChecked.push($(this).val());
    });
    $('input[name="season-checkbox[]"]:checked').each(function(){
      seasonsChecked.push($(this).val());
    });
    var dates = $('#period').val();

    console.log(catalogsChecked);
    console.log(seasonsChecked);
    console.log(dates);
    $.ajax({
      type: "POST",
      url: "{{ url('admin/downloadCheckPricesCsv') }}",
      dataType: "json",
      data: {
        catalogs: catalogsChecked,
        seasons:  seasonsChecked,
        dates:    dates,
      }
    }).done(function(data) {
      if (data != '') {
        // download
        var link = document.createElement('a');
        link.href = data['fullPath'];
        link.download = data['filename'];
        document.body.appendChild(link);
        link.click();
      }
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  });

});

</script>
