<!-- Custom Theme Scripts -->
{{ javascript_include("js/custom.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>
{% include "scripts/common/user_operations.volt" %}

<script>
$(document).ready(function() {
  $('.selectpicker').selectpicker();
  $('#table-headoffices').DataTable({
    'bInfo': false,
    'pageLength': 100,
    'bPaginate': false,
    'searching': false,
    'order': [],
    'columns': [
      { "orderable": true, "width": "23%" },
      { "orderable": true, "width": "35%" },
      { "orderable": true, "width": "23%" },
      { "orderable": true, "width": "13%" },
      { "orderable": false, "width": "10%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
  $('#table-agents').DataTable({
    'order': [],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "23%" },
      { "orderable": true, "width": "35%" },
      { "orderable": true, "width": "23%" },
      { "orderable": true, "width": "13%" },
      { "orderable": false, "width": "10%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});
$('#sync').click(function(e){
  e.preventDefault();

  if ($('#sync').hasClass('disabled'))
    return;

  $('#sync').addClass('disabled');
  $('.sync-progress').show();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/sync') }}",
    dataType: "json"
  }).done(function(data) {
    $('.sync-progress').hide();
    $('#sync').removeClass('disabled');
    showMessageTemporary("#sync-time", "{{ mt._('admin.syncdone') }} " + data + " {{ mt._('admin.syncminutes') }}", 3000);
  }).error(function(x, t, m) {
    $('.sync-progress').hide();
    $('#sync').removeClass('disabled');
    showMessageTemporary("#sync-time", "{{ mt._('admin.syncerror') }}", 3000);
  	printAjaxError(x, t, m);
  });
});

// Users management
$('.manage-users').click(function(){
  var cdagen = $(this).closest('tr').data('cdagen');
  $('#current-cdagen').val(cdagen);
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/getUsersForAgent') }}",
    dataType: 'json',
    data: {
      cdagen: cdagen
    }
  }).done(function(data) {
    $('.modal-manage-users .modal-body').html(data);
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('#new-user').click(function(){
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/getNewUserFormForAgent') }}",
    dataType: 'json',
    data: { }
  }).done(function(data) {
    $('.modal-manage-users .modal-body').append(data);
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
$('.modal-manage-users .modal-body').on('change', 'input[name="edit-password"]', function(){
  var block = $(this).closest('div.modal-section');
  var checked = $(this).is(':checked');
  if (checked) {
    block.find('.modal-password-box').hide();
    block.find('.modal-repeatpassword-box').hide();
  } else {
    block.find('.modal-password-box').show();
    block.find('.modal-repeatpassword-box').show();
  }
});
$('.modal-manage-users .modal-body').on('change', 'select[name="status"]', function(){
  var enabled = $(this).val();
  if (enabled == 1) {
    $(this).removeClass('disabled');
    $(this).addClass('enabled');
  } else {
    $(this).removeClass('enabled');
    $(this).addClass('disabled');
  }
});
$('.modal-manage-users .modal-body').on('click', '.delete-user', function(){
  var block = $(this).closest('div.modal-section');
  var idusr = block.find('input[name="id"]').val();
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteUser') }}",
    dataType: 'json',
    data: {
      idusr: idusr
    }
  }).done(function(data) {
    showTemporary(block.find('.msg-success'), 2000);
    $('#is-changed').val(true);
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
$('.modal-manage-users .modal-body').on('click', '.save-user', function(){
  var block = $(this).closest('div.modal-section');

  block.find('input[name="username"]').removeClass("error-form-input");
  block.find('input[name="password"]').removeClass("error-form-input");
  block.find('input[name="repeatpassword"]').removeClass("error-form-input");
  block.find('.msg-form-error').hide();
  block.find('.msg-error').hide();
  block.find('.msg-success').hide();
  block.find('.msg-form-error').html("");

  var idusr          = block.find('input[name="id"]').val();
  var cdagen         = $('#current-cdagen').val();
  var username       = block.find('input[name="username"]').val();
  var editpassword   = block.find('input[name="edit-password"]').is(':checked') == false;
  var password       = block.find('input[name="password"]').val();
  var repeatpassword = block.find('input[name="repeatpassword"]').val();
  var enabled        = block.find('select[name="status"]').val();
  var catalogs       = block.find('input[name="catalog-checkbox[]"]:checked').map(function(){return $(this).val();}).get();

  // check username and passwords
  if (username == "") {
    block.find('input[name="username"]').addClass("error-form-input");
    block.find('.msg-form-error').show();
    block.find('.msg-form-error').html("{{ mt._('_common.form.missingusername') }}");
  } else if (editpassword && password == "") {
    block.find('input[name="password"]').addClass("error-form-input");
    block.find('.msg-form-error').show();
    block.find('.msg-form-error').html("{{ mt._('_common.form.missingpassword') }}");
  } else if (editpassword && password != repeatpassword) {
    block.find('input[name="repeatpassword"]').addClass("error-form-input");
    block.find('.msg-form-error').show();
    block.find('.msg-form-error').html("{{ mt._('_common.form.passwordmismatch') }}");
  } else if ((editpassword && password == repeatpassword) || !editpassword) {
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/editUser') }}",
      dataType: 'json',
      data: {
        idusr:        idusr,
        cdagen:       cdagen,
        username:     username,
        editpassword: editpassword,
        password:     password,
        enabled:      enabled,
        catalogs:     catalogs,
      }
    }).done(function(data) {
      if (data.hasOwnProperty('licenses')) {
        block.find('.msg-error').hide();
        showTemporary(block.find('.msg-success'), 2000);
        $('#is-changed').val(true);
      } else {
        switch(data) {
          case "US":
          case "UA":
          case "UC":
          default:
            block.find('.msg-success').hide();
            showTemporary(".msg-error", 2000);
            break;
          case "IU":
            block.find('.msg-form-error').show();
            block.find('.msg-form-error').html("{{ mt._('_common.form.usernameinuse') }}");
            break;
          case "LT":
            block.find('.msg-form-error').show();
            block.find('.msg-form-error').html("{{ mt._('_common.form.licenseslimitreached') }}");
            break;
        }
      }
    }).error(function(x, t, m) {
      $(".msg-success").hide();
      showTemporary(".msg-error", 2000);
  		printAjaxError(x, t, m);
    });
  }
});
$('.modal-manage-users').on('hidden.bs.modal', function () {
  if ($('#is-changed').val() == 'true') {
    location.reload();
  }
});

// Agent info management
$('.modify-agent').click(function(e) {
  e.preventDefault();

  var row = $(this).closest('tr');

  // reset
  $('#modal-username').val("");
  $('#modal-password').val("");
  $('#modal-repeatpassword').val("");
  $("#modal-status").css("background-color", "#ffeeee");
  $("#status-disabled").prop("selected",true);
  $(".catalog-checkbox").prop("checked", false);
  $("input[name='nulist']").prop("checked", false);

  // anaage
  $('#modal-code').html(row.data('cdagen'));
  $('#modal-description').html(row.data('dsagen'));
  $('#modal-email').val(row.data('indema'));
  {% if differentBehaviours %}
  $('#modal-different-behaviour').prop('checked',row.data('fldfbh') == 1)
  {% endif %}
  $('#modal-default-pricelist').val(row.data('nulist'));
  $('#modal-default-pricelist').selectpicker('refresh');
  {% if selectablePriceLists %}
  var nulist_s = row.data('nulist-s') + '';
  $('#modal-selectable-pricelist').val(nulist_s.split(','));
  $('#modal-selectable-pricelist').selectpicker('refresh');
  {% endif %}
});
$('#save-agent').click(function(){
  $(".msg-error").hide();
  $(".msg-success").hide();

  var cdagen = $('#modal-code').length == 1 ? $('#modal-code').html() : 0;
  var nulist = $('#modal-default-pricelist').val();
  var indema = $('#modal-email').val();
  var fldfbh = {{ differentBehaviours ? "$('#modal-different-behaviour').prop('checked') ? 1 : 0" : '0' }};
  var nulist_s = {{ selectablePriceLists ? "$('#modal-selectable-pricelist').val()" : "''" }};

  $("#save-user").prop("disabled",true);
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/editAgent') }}",
    dataType: 'json',
    data: {
      cdagen: cdagen,
      nulist: nulist,
      indema: indema,
      fldfbh: fldfbh,
      nulist_s: nulist_s,
    }
  }).done(function(data) {
    location.reload();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
