{% extends "base_pdf.volt" %}

{% block body %}
    <body id="tickler">

    <div>
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td colspan="2" class="customer-cell">
                    <div class="customer">{{ mt._('_common.customer') }}</div>
                    <div>{{ mt._('_common.code.short') }} {{ anagra.cdanag }}</div>
                    <div>{{ anagra.descri }}</div>
                    <div>{{ anagra.indiri }}</div>
                    <div>{{ anagra.codcap }} {{ anagra.ccitta }}{% if anagra.provin != '' %} ({{ anagra.provin }}){% endif %}{% if anagra.dsnazi != '' %} - {{ anagra.dsnazi }}{% endif %}</div>
                    <div>{% if anagra.pariva != '' %}{{ mt._('account.customer.vatcode.short') }}: {{ anagra.pariva }}{% endif %}{% if anagra.codfis != '' %}{% if anagra.pariva != '' %} / {% endif %}{{ mt._('account.customer.taxcode.short') }}: {{ anagra.codfis }}{% endif %}
                        &nbsp;
                    </div>
                </td>
            </tr>
            <tr>
                <td class="pay-cnd">
                    <div class="pay-cnd-t">{{ mt._('_common.payment.cond') }}</div>
                    <div>{{ anagra.dspaga != '' ? anagra.dspaga : "&nbsp;" }}</div>
                </td>
                <td class="shi-cnd">
                    <div class="shi-cnd-t">{{ mt._('_common.shipping.cond') }}</div>
                    <div>{{ anagra.dstpor != '' ? anagra.dstpor : "&nbsp;" }}</div>
                </td>
            </tr>
        </table>

        {% if gopart|length > 0 %}
            {% set toExpire = 0 %}
            {% set expired = 0 %}
            {% for deadline in gopart %}
                {% if deadline.expired > 0 %}
                    {% set expired = expired + deadline.impsca %}
                {% else %}
                    {% set toExpire = toExpire + deadline.impsca %}
                {% endif %}
            {% endfor %}
            <div class="header-content">
                <div>
                    <div>{{ mt._('account.openitems') }}</div>
                    <div class="col-hdr"><span
                                class="color">{{ mt._('_common.total') }}:</span> {{ (expired + toExpire)|currency }} {{ gopart[0].valuta }}
                    </div>
                    <div class="col-hdr"><span
                                class="color">{{ mt._('account.expiring') }}:</span> {{ toExpire|currency }} {{ gopart[0].valuta }}
                    </div>
                    <div class="col-hdr"><span class="color">{{ mt._('account.expired') }}:</span> <span
                                class="red">{{ expired|currency }} {{ gopart[0].valuta }}</span></div>
                </div>
            </div>

            <div class="header-row">
                <div class="col-dct">{{ mt._('_common.documenttype') }}</div>
                <div class="col-num">N. #</div>
                <div class="col-dat">{{ mt._('_common.date') }}</div>
                <div class="col-pay">{{ mt._('_common.payment.cond') }}</div>
                <div class="col-amt">{{ mt._('_common.amount') }}</div>
                <div class="col-top">{{ mt._('_common.topay') }}</div>
                <div class="col-ddl">{{ mt._('_common.deadline') }}</div>
                <div class="col-exp">{{ mt._('_common.expired.by') }}</div>
            </div>

            {% set prev_deadline = '' %}
            {% for deadline in gopart %}
                {% if (loop.index <= 36 and loop.index % 36 == 0) or (loop.index > 36 and (loop.index - 36) % 44 == 0) %}

                    <div class="header-row-2">
                        <div class="col-dct">{{ mt._('_common.documenttype') }}</div>
                        <div class="col-num">N. #</div>
                        <div class="col-dat">{{ mt._('_common.date') }}</div>
                        <div class="col-pay">{{ mt._('_common.payment.cond') }}</div>
                        <div class="col-amt">{{ mt._('_common.amount') }}</div>
                        <div class="col-top">{{ mt._('_common.topay') }}</div>
                        <div class="col-ddl">{{ mt._('_common.deadline') }}</div>
                        <div class="col-exp">{{ mt._('_common.expired.by') }}</div>
                    </div>
                {% endif %}

                <div class="detail-row {% if loop.index != 1 and deadline.numdoc != prev_deadline.numdoc %}btopc{% endif %}">
                    {% if loop.index == 1 or (loop.index <= 36 and loop.index % 36 == 0) or (loop.index > 36 and (loop.index - 36) % 44 == 0) or deadline.numdoc != prev_deadline.numdoc %}
                        <div class="col-dct">{{ deadline.tipdoc }}</div>
                        <div class="col-num">{{ deadline.numdoc }}</div>
                        <div class="col-dat">{{ deadline.datdoc }}</div>
                        <div class="col-pay">{{ deadline.despag }}</div>
                        <div class="col-amt">{{ deadline.impdoc|currency }} {{ deadline.valuta }}</div>
                    {% else %}
                        <div class="col-dct">&nbsp;</div>
                        <div class="col-num">&nbsp;</div>
                        <div class="col-dat">&nbsp;</div>
                        <div class="col-pay">&nbsp;</div>
                        <div class="col-amt">&nbsp;</div>
                    {% endif %}
                    <div class="col-top {% if deadline.expired > 0 %}red{% endif %}">{{ deadline.impsca|currency }} {{ deadline.valuta }}</div>
                    <div class="col-ddl">{{ deadline.datsca }}</div>
                    <div class="col-exp bold red">{{ deadline.expired > 0 ? deadline.expired ~ " " ~ mt._('_common.days') : "&nbsp;" }}</div>
                </div>
                {% set prev_deadline = deadline %}
            {% endfor %}
        {% endif %}

    </div>
    </body>
{% endblock %}
