{% extends "base_pdf.volt" %}

{% block body %}
    {# SET BILLING INFO #}
    {% set billing_address = anagra.indiri ~ ' - ' ~ anagra.codcap ~ ' ' ~ anagra.ccitta %}
    {% if anagra.provin != '' %}{% set billing_address = billing_address ~ ' (' ~ anagra.provin ~ ')' %}{% endif %}
    {% if anagra.dsnazi != '' %}{% set billing_address = billing_address ~ ' - ' ~ anagra.dsnazi %}{% endif %}

    {# SET SHIPPING INFO #}
    {% set shipping_address = "" %}
    {% if (not(desmer is empty)) %}
        {% set shipping_address = desmer.indiri ~ ' - ' ~ desmer.codcap ~ ' ' ~ desmer.ccitta %}
        {% if desmer.provin != '' %}{% set shipping_address = shipping_address ~ ' (' ~ desmer.provin ~ ')' %}{% endif %}
        {% if desmer.dsnazi != '' %}{% set shipping_address = shipping_address ~ ' - ' ~ desmer.dsnazi %}{% endif %}
    {% else %}
        {% set shipping_address = billing_address %}
    {% endif %}

    {# SET HEADER HTML #}
    {% set hdr_ord_ord = octest.nuordc ~ " - " ~ octest.dtcrea %}
    {% set hdr_ord_typ = octest.tpordc == 0 ? mt._('order.availability') : mt._('order.reservation') %}
    {% set hdr_ord_del = octest.dtmcli %}
    {% set hdr_ord_cat = octest.dscata != '' ? octest.dscata : octest.cdcata %}
    {% set hdr_ord_pay = "" %}
    {% if octest.tppaga == "payp" %}{% set hdr_ord_pay = "PayPal" %}
    {% elseif octest.tppaga == "stri" %}{% set hdr_ord_pay = "Stripe" %}
    {% elseif anagra.dspaga != '' %}{% set hdr_ord_pay = anagra.dspaga %}
    {% else %}{% set hdr_ord_pay = "&nbsp;" %}{% endif %}
    {% set hdr_ord_shi = anagra.dstpor %}

    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    {% set hdr_logo = exist_logo
        ? "<div class='w100 logo'><img src='" ~ url(imgurl) ~ "'/></div><hr/>"
        : "<div class='w100 logo'><br/></div><hr/>" %}

  {% set hdr_cust = "<div class='w100 cust'><span class='bold'>" ~ mt._('_common.customer') ~ ":</span> " ~ anagra.cdanag ~ " - " ~ anagra.descri ~ "</div>" %}
  {% set hdr_note = "<div class='w100 note'>
                      <div><span class='bold'>" ~ mt._('_common.notes.general') ~ ":</span> " ~ octest.notcli ~ "</div>
                      <div><span class='bold'>" ~ mt._('_common.notes.order') ~ ":</span> " ~  note ~ "</div>
                    </div>" %}

  {% set hdr_ordr = "<div class='w100'>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.order') ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.order') ~ ": " ~ hdr_ord_ord ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.type') ~ ": " ~ hdr_ord_typ ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.delivery') ~ ": " ~ hdr_ord_del ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.catalog') ~ ": " ~ hdr_ord_cat ~ "</div>
                        <div>" ~ mt._('_common.payment.cond') ~ ": " ~ hdr_ord_pay ~ "</div>
                        <div>" ~ mt._('_common.shipping.cond') ~ ": " ~ hdr_ord_shi ~ "</div>
                      </div>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.billing') ~ "</div>
                        <div>" ~ mt._('account.customer.address') ~ ": " ~ billing_address ~ "</div>
                        <div>" ~ mt._('account.customer.vatcode.short') ~ ": " ~ anagra.pariva ~ "</div>
                        <div>" ~ mt._('account.customer.taxcode.short') ~ ": " ~ anagra.codfis ~ "</div>
                      </div>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.shipping') ~ "</div>
                        <div>" ~ mt._('account.customer.address') ~ ": " ~ shipping_address ~ "</div>
                      </div>
                    </div>" %}

  {% set header = "<header>" ~ hdr_logo ~ hdr_cust ~ hdr_ordr ~ hdr_note ~ "</header>" %}
  {% set header_brk = "<header class='pb_before'>" ~ hdr_logo ~ hdr_cust ~ hdr_ordr ~ hdr_note ~ "</header>" %}

    <body id="pdf999">

    {# Logo + Header height: 244px; Available space: vertical 1300 px, horizontal TODO px #}
    {% set max_body_height = orientation == 0 ? 1000 : 2000 %}
    {% set curr_arti_iterator = 0 %}
    {% set curr_offset = 244 %}
    {% set full_total_qty = 0 %}
    {% set full_total_prc = 0 %}
    {% set row_html = "" %}
    {% set page = 0 %}
    {% set full_total_szs = [] %}
    {% set full_total_row = 0 %}

    {% if articles|length > 0 %}
        {% for article in articles %}
            {# SET IMAGES #}
            {% set imgurl_n = "img/model/" ~ article.flimag_n %}
            {% set imgurl_i = "img/model/" ~ article.flimag_i %}
            {% set imgurl_c = "img/model/" ~ article.flimag_c %}
            <?php $exist_n = $article->flimag_n != '' && file_exists($imgurl_n); ?>
            <?php $exist_i = $article->flimag_i != '' && file_exists($imgurl_i); ?>
            <?php $exist_c = $article->flimag_c != '' && file_exists($imgurl_c); ?>

            {# SET PRICE #}
            {% set price_for_size = false %}
            {% set price = article.tppers != "PT" or article.cdvari is null or article.cdvari == "" ? article.octagl[0].prezzo : (article.octagl[0].prezzo + article.preagg) %}
            {% set total = 0 %}

            {% for size in article.octagl %}
                {% set total = total + (size.prezzo * size.quanti) %}
                {% if price != size.prezzo %}
                    {% set price_for_size = true %}
                {% endif %}
            {% endfor %}

            {# SET ARTICLE DESCRIPTION #}
            {% set article_description = "" %}
            {% if descr == 0 %}{% set article_description = article.cdarti ~ " - " ~ article.dsarti %}
            {% elseif descr == 1 %}{% set article_description = article.cdcolo ~ " - " ~ article.dsarti %}
            {% elseif descr == 2 %}{% set article_description = article.cdcolo ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 3 %}{% set article_description = article.cdarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 4 %}{% set article_description = article.dsarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}{% endif %}

            {% if loop.first %}
                {# PRINT HEADER BEFORE FIRST ARTICLE #}
                {{ header }}
            {% endif %}

            {% if curr_arti_iterator == 0 %}
                {% set full_total_szs = [] %}
                {% set full_total_row = 0 %}

                {# Print row when all arti for artn are saved in row_html #}
                {{ row_html }}

                {% set breakCls = "" %}
                {% set firstRowOnPage = loop.first %}
                {% if curr_offset + 100 + (60 * article.arti_rows) > max_body_height %}
                    {% set curr_offset = 244 %}
                    {% set breakCls = "class='pb_before'" %}
                    {% set firstRowOnPage = true %}
                    {{ header_brk }}
                {% endif %}

                {% set sizes = "" %}
                {% for size in article.octagl %}
                    {% set sizes = sizes ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ size.taglia ~ "</div>" %}
                {% endfor %}
                {% set sizes = sizes ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ mt._('pdf.qty') ~ "</div>" %}

                {% set row_html = "
        <!-- Row -->
        <div class='w100 " ~ (firstRowOnPage ? 'mt30' : '') ~ "' style='height:" ~ (100 + (60 * article.arti_rows))  ~ "px' >
          <!-- Description -->
          <div class='description'>" ~ article.dsartn ~ " " ~ curr_offset ~ "</div>

          <!-- Code and price -->
          <div class='w100 lh20 h20'>
            <div class='w80 inline-block'>" ~ article.cdartn ~ "</div>
            <div class='w20 pad right inline-block'>" ~
                    (price_for_size
                    ? mt._('quantity.priceforsize')
                    : mt._('_common.price.unit') ~ ": " ~ price|currency ~ " " ~ currency) ~
                    "</div>
          </div>

          <!-- Body -->
          <div class='w100' style='height:" ~ (article.arti_rows > 1 ? 40 + (60 * article.arti_rows) : 80) ~ "px'>
            <div class='big-img'>" ~ (exist_n ? "<img src='" ~ url(imgurl_n) ~ "'/>" : '<br/>') ~ "</div>
            <div class='l100'>
              <div class='w100 lh20 btop h20'>
                <div class='w20 fl pad'>" ~ mt._('_common.article') ~ "</div>
                <div class='w65 fl col-short pad center'>" ~ sizes ~ "</div>
                <div class='w15 fl pad right'>" ~ mt._('_common.total') ~ "</div>
              </div>
        " %}

                {# Init Iterator #}
                {% set curr_arti_iterator = article.arti_rows %}

                {# Update offset for next artn #}
                {% set curr_offset = curr_offset + 100 + 60 * article.arti_rows %}
            {% endif %}

            {% set qty = "" %}
            {% set tot_qty = 0 %}
            {% set tot_prc = 0 %}
            {% for size in article.octagl %}
                {% if article.tppers != 'PT' or article.cdvari is null or article.cdvari == '' %}
                    {% set tot_prc = tot_prc + (size.quanti * size.prezzo) %}
                {% else %}
                    {% set tot_prc = tot_prc + (size.quanti * (size.prezzo + article.preagg)) %}
                {% endif %}
                {% set tot_qty = tot_qty + size.quanti %}
                {% set full_total_szs[loop.index0] = full_total_szs[loop.index0] is defined ? full_total_szs[loop.index0] + size.quanti : size.quanti %}
                {% set qty = qty ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ (size.quanti > 0 ? size.quanti : "&nbsp;") ~ "</div>" %}
            {% endfor %}
            {% set full_total_row = full_total_row + tot_prc %}
            {% set full_total_qty = full_total_qty + tot_qty %}
            {% set full_total_prc = full_total_prc + tot_prc %}
            {% set qty = qty ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ tot_qty ~ "</div>" %}

            {# Arti block #}
            {% set row_html = row_html ~
                "<div class='w100 lh20 btop " ~ (article.arti_rows == 1 ? 'bbtm' : '') ~ " h60'>
          <div class='w20 fl col'>
            <div class='fl small-img'>" ~ (exist_i ?  "<img src='" ~ url(imgurl_i) ~ "'/>" : '<br/>') ~ "</div>" ~
                (article.tppers == 'PT' ?
                "<div class='fl small-img'>" ~ (exist_c ? "<img src='" ~ url(imgurl_c) ~ "'/>" : '<br/>') ~ "</div>" : "") ~
                "<div style='margin-left:" ~ (article.tppers == 'PT' ? '110' : '55') ~ "px'>" ~ article_description ~ "</div>
          </div>
          <div class='w65 fl col center'>" ~ qty ~ "</div>
          <div class='w15 fl col right'><div>" ~ tot_prc|currency ~ " " ~ currency ~ "</div></div>
        </div>" %}

            {% set curr_arti_iterator = curr_arti_iterator - 1 %}

            {% if curr_arti_iterator == 0 %}
                {% set tot_row = "" %}
                {% set tot_szs = 0 %}
                {% for size in full_total_szs %}
                    {% set tot_szs = tot_szs + size %}
                    {% set tot_row = tot_row ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ (size > 0 ? size : "&nbsp;") ~ "</div>" %}
                {% endfor %}
                {% set tot_row = tot_row ~ "<div style='width:" ~ (100 / (article.octagl|length + 1)) ~ "%'>" ~ tot_szs ~ "</div>" %}

                {# Last arti block of multi arti row #}
                {% if article.arti_rows > 1 %}
                    {% set row_html = row_html ~
                        "<div class='w100 lh20 bold btop bbtm h20'>
              <div class='w20 fl pad'>&nbsp;</div>
              <div class='w65 fl col-short pad center'>" ~ tot_row ~ "</div>
              <div class='w15 fl pad right'>" ~ mt._('_common.total') ~ " " ~ full_total_row|currency ~ " " ~ currency ~ "</div>
            </div>" %}
                {% endif %}

                {% set row_html = row_html ~ "
              </div><!-- close div margin-left:100 -->
            </div><!-- close div body -->
          </div><!-- close div row -->" %}

            {% endif %}

        {% endfor %}

        {{ row_html }}

        {# CALCULATE TOTAL WITH TAXES #}
        {% set tax = 0 %}
        {% set total = full_total_prc %}
        {% if anagra.aliquo > 0 or anagra.dsaiva != '' %}
            {% set tax = (full_total_prc * anagra.aliquo) / 100 %}
            {% set total = full_total_prc + tax %}
        {% endif %}

        {# PRICES FOOTER #}
        <div class="w100 bold right">
            <div class="prices-footer-sm">
                <div class="title-row">{{ mt._('pdf.total.qty') }}</div>
                <div>{{ full_total_qty }}</div>
            </div>
            <div class="prices-footer-bg">
                <div class="title-row">{{ mt._('pdf.total.taxable') }}</div>
                <div>{{ full_total_prc|currency }} {{ currency }}</div>
            </div>
            <div class="prices-footer-sm">
                <div class="title-row">{{ mt._('_common.tax') }}{# {{ tax > 0 ? '&nbsp<span class="fs6">(' ~ anagra.dsaiva ~ ')</span>' : '' }} #}</div>
                <div>{{ tax > 0 ? tax|currency ~ ' ' ~ currency : '&nbsp;' }}</div>
            </div>
            <div class="prices-footer-bg">
                <div class="title-row">{{ mt._('_common.total') }}</div>
                <div>{{ total|currency }} {{ currency }}</div>
            </div>
        </div>

    {% endif %}

    </body>
{% endblock %}
