{% extends "base_pdf.volt" %}

{% block body %}
    <body id="pdf7">
    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>
    {# CUSTOMER TABLE #}
    <table cellspacing="0" cellpadding="10">
        <tr>
            {% if exist_logo %}
                <td class="vtop w20" rowspan="3"><img src="{{ url(imgurl) }}" class="logo-tbl"/></td>
            {% endif %}
            <td class="vtop btop brgt blft {{ exist_logo ? 'w40' : 'w50' }}">
                <span class="title">{{ mt._('_common.customer') }}</span><br/>
                <span>{{ mt._('_common.code.short') }} {{ anagra.cdanag }}<br/>{{ anagra.descri }}<br/>{{ anagra.indiri }}<br/>{{ anagra.codcap }} {{ anagra.ccitta }}{% if anagra.provin != '' %} ({{ anagra.provin }}){% endif %}{% if anagra.dsnazi != '' %} - {{ anagra.dsnazi }}{% endif %}<br/>{% if anagra.pariva != '' %}{{ mt._('account.customer.vatcode.short') }}: {{ anagra.pariva }}{% endif %}{% if anagra.codfis != '' %}{% if anagra.pariva != '' %} / {% endif %}{{ mt._('account.customer.taxcode.short') }}: {{ anagra.codfis }}{% endif %}</span>
            </td>
            <td class="btop vtop {{ exist_logo ? 'w28' : 'w40' }}">
                <span class="title">{{ mt._('_common.destination') }}</span><br/>
                <span>{% if (not(desmer is empty)) %}{% if desmer.cddesm > 0 %}{{ mt._('_common.code.short') }} {{ desmer.cddesm }}
                        <br/>{% endif %}{{ desmer.desvid }}<br/>{{ desmer.indiri }}
                        <br/>{{ desmer.codcap }} {{ desmer.ccitta }}{% if desmer.provin != '' %} ({{ desmer.provin }}){% endif %}{% if desmer.dsnazi != '' %} - {{ desmer.dsnazi }}{% endif %}{% else %}&nbsp;{% endif %}</span>
            </td>
            <td class="btop brgt right pd-lft {{ exist_logo ? 'w12' : 'w10' }}">
                <span class="bold">{% if octest.flstat == 1 %}{{ mt._('account.order.notsent') }}{% elseif octest.flstat == 2 %}{{ mt._('account.order.sent') }}{% elseif octest.flstat == 3 %}{{ mt._('account.order.accepted') }}{% elseif octest.flstat == 4 %}{{ mt._('account.order.rejected') }}{% endif %}</span>
            </td>
        </tr>
        <tr>
            <td class="btop brgt blft vtop">
                <span class="title">{{ mt._('_common.payment.cond') }}</span><br/>
                <span>{% if octest.tppaga == "payp" %}PayPal{% elseif octest.tppaga == "stri" %}Stripe{% elseif anagra.dspaga != '' %}{{ anagra.dspaga }}{% else %}&nbsp;{% endif %}</span>
            </td>
            <td class="btop brgt vtop" {% if label == 0 %}colspan="2"{% endif %}>
                <span class="title">{{ mt._('_common.shipping.cond') }}</span><br/>
                <span>{{ anagra.dstpor != '' ? anagra.dstpor : "&nbsp;" }}</span>
            </td>
            {% if label == 1 %}
                <td class="btop brgt vtop">
                    <span class="title">{{ mt._('_common.label') }}</span><br/>
                    <span>{{ octest.dsetic != '' ? octest.dsetic : "&nbsp;" }}</span>
                </td>
            {% endif %}
        </tr>
        <tr>
            <td class="notes" colspan="4">
                <div>
                    <span class="title">{{ mt._('_common.notes') }}</span><br/>
                    <span>{{ octest.notcli }}&nbsp;</span>
                </div>
            </td>
        </tr>
    </table>

    {# HEADER ORDER TABLE #}
    <table class="header-order-table" cellspacing="0" cellpadding="10">
        <tr>
            <td class="btop2 brgt2 bbtm2 blft2 vtop bg-gray">
                <span class="title">{{ mt._('_common.ordernumber') }}</span><br/>
                <span>{{ octest.nuordc }}&nbsp;</span>
            </td>
            <td class="btop2 brgt bbtm vtop bg-gray">
                <span class="title">{{ mt._('_common.date') }}</span><br/>
                <span>{{ octest.dtcrea }}&nbsp;</span>
            </td>
            <td class="btop2 brgt bbtm vtop bg-gray">
                <span class="title">{{ mt._('_common.delivery') }}</span><br/>
                <span>{{ octest.dtmcli }}&nbsp;</span>
            </td>
            <td class="btop2 brgt bbtm vtop bg-gray">
                <span class="title">{{ mt._('_common.catalog') }}</span><br/>
                <span>{{ octest.dscata }}&nbsp;</span>
            </td>
        </tr>
    </table>

    {% if articles|length > 0 %}
    {% set full_total_qty = 0 %}
    {% set full_total_prc = 0 %}

    {% set first_page = true %}
    {% set max_rows_first_page = orientation == 0 ? 17 : 34 %}
    {% set max_rows_other_page = orientation == 0 ? 33 : 50 %}
    {% set current_rows_page = 0 %}

    {% for article in articles %}
    {# IMAGE SECTION #}
    {% set imgurl = "img/temp/resize/model/" ~ article.flimag_i %}
    <?php $exist = $article->flimag_i != '' && file_exists($imgurl); ?>

    {% if not exist and article.flimag_i != '' %}
        {% set imgurl = "img/model/" ~ article.flimag_i %}
        <?php $exist = file_exists($imgurl); ?>
    {% endif %}

    {# PRICE SECTION #}
    {% set price_for_size = false %}

    {% set price = article.octagl[0].prezzo %}

    {% set prices = "" %}
    {% if article.prices|length > 1 %}
        {% set price_for_size = true %}
        {% set prices = mt._('quantity.priceforsize.short') %}
    {% endif %}

    {% if (first_page and (current_rows_page + 4 > max_rows_first_page)) or
        (not first_page and (current_rows_page + 4 > max_rows_other_page)) %}
    {% set first_page = false %}
    {% set current_rows_page = 0 %}
    {% set pagebreak = true %}
    <pagebreak>
        {% else %}
            {% set pagebreak = false %}
            {% set current_rows_page = current_rows_page + 4 %}
        {% endif %}
        <div class="content pbi_avoid {{ loop.first or pagebreak ? 'btop' : '' }}"
             style="padding:{{ loop.first or pagebreak ? '-1px' : '0' }} -1px -1px -1px">

            {% if orientation == 1 %}
                {% set width_img = 9 %}
                {% set width_row = 6 %}
                {% set width_cod = 19 %}
                {% set width_des = 41 %}
                {% set width_del = 11 %}
                {% set width_tro = 11 %}
                {% set width_tax = 12 %}
            {% else %}
                {% set width_img = 7.5 %}
                {% set width_row = 4 %}
                {% set width_cod = 12.4 %}
                {% set width_des = 52.6 %}
                {% set width_del = 9 %}
                {% set width_tro = 11 %}
                {% set width_tax = 11 %}
            {% endif %}

            <div class="fl center"
                 style="width:{{ width_img }}%">{{ exist ? image(imgurl, "class": "img-sm") : '&nbsp;' }}</div>
            <div class="fl flex" style="width:{{ 100 - width_img }}%">

                {% set total_prc = 0 %}
                {% set total_qty = 0 %}
                {% for size in article.octagl %}
                    {% if article.tppers != "PT" or article.cdvari is null or article.cdvari == "" %}
                        {% set total_prc = total_prc + (size.quanti * size.prezzo) %}
                    {% else %}
                        {% set total_prc = total_prc + (size.quanti * (size.prezzo + article.preagg)) %}
                    {% endif %}
                    {% set total_qty = total_qty + size.quanti %}
                    {% set full_total_prc = full_total_prc + (size.quanti * (size.prezzo + article.preagg)) %}
                    {% set full_total_qty = full_total_qty + size.quanti %}
                {% endfor %}

                {# FIRST ROW #}
                <div class="fl lh20 brgt bbtm blft pdm-rgt pdm-btm pdm-lft" style="width:{{ width_row }}%">
                    <div class="pad title">{{ mt._('pdf.row') }}</div>
                    <div class="pad">{{ article.seqrap }}</div>
                </div>
                <div class="fl lh20 brgt bbtm bg-gray pdm-rgt pdm-btm" style="width:{{ width_cod }}%">
                    <div class="pad title">{{ mt._('_common.article.code.short') }}</div>
                    <div class="pad">{{ article.cdarti }}</div>
                </div>
                <div class="fl lh20 brgt bbtm pdm-rgt pdm-btm" style="width:{{ width_des }}%">
                    <div class="pad title">{{ mt._('_common.description') }}</div>
                    <div class="pad">{% if descr == 0 %}{{ article.cdarti }} - {{ article.dsarti }}{% elseif descr == 1 %}{{ article.cdcolo }} - {{ article.dsarti }}{% elseif descr == 2 %}{{ article.cdcolo }} - {{ article.dscolo }}{% elseif descr == 3 %}{{ article.cdarti }} - {{ article.dscolo }}{% endif %}</div>
                </div>
                <div class="fl lh20 brgt bbtm pdm-rgt pdm-btm" style="width:{{ width_del }}%">
                    <div class="pad title">{{ mt._('_common.delivery') }}</div>
                    <div class="pad">{{ article.dtmcli != '00/00/0000' and article.dtmcli != octest.dtmcli ? article.dtmcli : "&nbsp;" }}</div>
                </div>
                <div class="fl lh20 brgt bbtm center bg-gray pdm-rgt pdm-btm" style="width:{{ width_tro }}%">
                    <div class="pad title">{{ mt._('pdf.qty.totrow')|uppercase }}</div>
                    <div class="pad bold">{{ total_qty }}</div>
                </div>
                <div class="fl lh20 bbtm center bg-gray pdm-btm">
                    <div class="pad title">{{ mt._('pdf.taxable')|uppercase }}</div>
                    <div class="pad bold">{{ total_prc|currency }} {{ currency }}</div>
                </div>

                {# SECOND ROW #}
                <div class="fl lh20 brgt blft pdm-rgt pdm-lft" style="width:{{ width_row + width_cod }}%">
                    <div class="pad title">{{ mt._('_common.price') }}</div>
                    <div class="pad">{% if price_for_size %}{{ prices }}{% elseif article.tppers != "PT" or article.cdvari is null or article.cdvari == "" %}{{ price|currency }}{% else %}{{ (price + article.preagg)|currency }}{% endif %} {{ currency }}</div>
                </div>
                <div class="fl lh20">
                    {% for size in article.octagl %}
                        <div class="fl center pdm-rgt" style="width:{{ 100 / article.octagl|length }}%">
                            <div class="pad title">{{ size.taglia }}</div>
                            <div class="pad">{{ size.quanti > 0 ? size.quanti : "&nbsp;" }}</div>
                        </div>
                    {% endfor %}
                </div>
            </div>
        </div>

        {% endfor %}
        {% endif %}

        {% if (first_page and ((current_rows_page + 4 + 3) > max_rows_first_page)) or
            (not first_page and ((current_rows_page + 4 + 3) > max_rows_other_page)) %}
        <pagebreak>
            {% endif %}

            <div class="footer">
                <div class="fl {{ orientation == 0 ? 'w80': 'w70' }}">&nbsp;</div>
                <div class="ftr-1 {{ orientation == 0 ? 'w10' : 'w15' }}">
                    <div class="pad title">{{ mt._('pdf.total.qty') }}</div>
                    <div class="pad">{{ full_total_qty }}</div>
                </div>
                <div class="ftr-2">
                    <div class="pad title">{{ mt._('pdf.total.taxable') }}</div>
                    <div class="pad">{{ full_total_prc|currency }} {{ currency }}</div>
                </div>
            </div>

            {% if note != '' %}
                <p>{{ note }}</p>
            {% endif %}

    </body>
{% endblock %}
