{% extends "base_pdf.volt" %}

{% block body %}
    <?php
    $logo_style = $exist_logo ? 'style="position: absolute; top: 50px; left: 30px; width: 26px; font-weight: bold;"' : '';

    // Testo delle tre righe
    $line1 = "INTERPORTO DI NOLA LOTTO C2 NUMERO 1/5";
    $line2 = "80035 NOLA (NA)-Italy";
    $line3 = "Reg.Imp.C.F. e P.IVA IT 04088251212";

    // Altezza totale del testo
    $total_text_height = 3 * 9; // Ridotto a 12px per il testo

    // Posizione verticale del logo rispetto alle righe di testo
    $logo_vertical_position = $total_text_height + 50; // 30px di distanza tra il testo e il logo
?>
    <body id="pdf400">
    <div>
        {% set headerHeight = 343 + 19 %}
        {% set bg = '#e6e6e6' %}
        {% set totqty = 0 %}
        {% set totamt = 0 %}
        {% set numdsserm =0 %}
        {% set currentHeight = 0 %}

        {% set vat = (anagra.cdnazi is not empty and anagra.cdnazi|lower != 'it' ? 0 : 22) %}
        {% set totqty = 0 %}
        {% for article in articles %}
            {% set rowQuanti = 0 %}
            {% for i in 1..maxDimension %}
                {% set indexRange = loop.index %}
                {% for qtaTaglia in article.octagl %}
                    {% if qtaTaglia.quanti > 0 and qtaTaglia.postgl == indexRange %}
                        {% set rowQuanti = rowQuanti + qtaTaglia.quanti %}
                    {% endif %}
                {% endfor %}
            {% endfor %}
            {% set totqty = totqty + rowQuanti %}
            {% set numdsserm +=1 %}
        {% endfor %}

        {% for article in articles %}
        {% set rowHeight = 20 + (article.cdvari != '' ? 19 : 0) %}
        {% set bg = ((loop.index0 % 2 == 0) ? "#c0c0c0" : "#ffffff") %}
        {% if currentHeight + rowHeight > 840 or loop.first %}
        {% if not loop.first %}
            <!-- Chiusura tabella nei cicli dopo il primo -->
            {{ '</tbody></table>' }}
        {% endif %}
        <!-- First Header -->
        <div class="w100 {{ loop.index0 != 0 ? 'pb_before' : '' }}" style="line-height:15px">
            {#<div class="w100" style="height:40px;">&nbsp;</div>#}
            <div class="hdr_col first_row pad fl w30" style="text-align:center">
                <div class="fl w100">
                    {{ exist_logo ? "<img src='../" ~ imgurl ~ "' style='height:55px;margin:0 auto'/>" : '<span style="font-size:45px; line-height:50px;font-weight:bold;">KOCCA Srl</span>' }}
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line1; ?></div>
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line2; ?></div>
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line3; ?></div>
                </div>
            </div>

            <div class="hdr_col first_row pad" style="width:35%;float:right">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.code.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.cddesm : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.reference.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.businessname.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.desvid : anagra.descri }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.indiri : anagra.indiri }}</div>
                    </div>
                    <div class="fl w25">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.codcap : anagra.codcap }}</div>
                    </div>
                    <div class="fl w55">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.ccitta : anagra.ccitta }}</div>
                    </div>
                    <div class="fl w20">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.provin : anagra.provin }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.numtel : anagra.numtel }}{{ desmer is defined and desmer.numcel != '' ? ' - ' ~ desmer.numcel : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.numfax : anagra.numfax }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                </div>
            </div>
            <div class="hdr_col first_row pad" style="width:35%;float:right;">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.code.short') }}</div>
                        <div class="fl bold">{{ anagra.cdanag }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.reference.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.businessname.short') }}</div>
                        <div class="fl bold">{{ anagra.descri }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                        <div class="fl bold">{{ anagra.indiri }}</div>
                    </div>
                    <div class="fl w25">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                        <div class="fl bold">{{ anagra.codcap }}</div>
                    </div>
                    <div class="fl w55">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                        <div class="fl bold">{{ anagra.ccitta }}</div>
                    </div>
                    <div class="fl w20">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                        <div class="fl bold">{{ anagra.provin }} - {{ anagra.cdnazi }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                        <div class="fl bold">{{ anagra.numtel }}{{ anagra.numcel != '' ? ' - ' ~ anagra.numcel : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                        <div class="fl bold">{{ anagra.numfax }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                        <div class="fl bold">{{ anagra.codfis }}
                            {{ anagra.codfis != anagra.pariva and anagra.codfis != '' and anagra.pariva != '' ? ' - ' : '' }}
                            {{ anagra.codfis != anagra.pariva ? anagra.pariva : '' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Second Header -->
        <div class="w100 mt10" style="line-height:15px">
            <div class="hdr_col second_row pad w35">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w60">
                        <div class="fl pad mr10">{{ mt._('pdf.brand') }}</div>
                        <div class="fl bold">{{ cttest.cdtitl }}</div>
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('pdf.reference') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w60">
                        <div class="fl pad mr10">{{ mt._('_common.season') }}</div>
                        <div class="fl bold">{{ octest.cdstag }}</div>
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('pdf.order.date') }}</div>
                        <div class="fl bold">{{ octest.dtcrea }}</div>
                    </div>
                    <div class="fl w60">
                        {% if octest.flstat >= 2 %}
                            <div class="fl pad mr10">{{ mt._('pdf.order.number.short') }}</div>
                            <div class="fl bold">{{ octest.codice_ordine }}</div>
                        {% else %}
                            &nbsp;
                        {% endif %}
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('_common.agent') }}</div>
                        <div class="fl bold">{{ octest.dsagen }}</div>
                    </div>
                </div>
            </div>
            <div class="hdr_col second_row pad w30">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w100">
                        <div class="fl pad mr10" style=>{{ mt._('pdf.payment.conditions') }}</div>
                        <div class="fl bold">{{ octest.dspaga }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.delivery.conditions') }}</div>
                        <div class="fl bold">{{ octest.dstpor }}</div>
                    </div>
                    <div class="fl w100">
                        {% if octest.flstat > 2 %}
                            <div class="fl pad mr10">{{ mt._('pdf.delivery') }}</div>
                            {# <div class="fl bold">{{ octest.dsscad != '' ? octest.dsscad : octest.dtmcli }}</div> #}
                            <div class="fl bold">{{ octest.dsscad != '' ? octest.dsscad : octest.dtmcli }}</div>
                        {% else %}
                            &nbsp;
                        {% endif %}
                    </div>
                </div>
            </div>
            <div class="hdr_col second_row pad w35">
                <div class="btop blft bbtm brgt pad fl w60">
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.bank') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">ABI:</div>
                        <div class="fl bold">{{ anagra.codabi != 0 ? anagra.codabi : '' }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">CAB:</div>
                        <div class="fl bold">{{ anagra.codcab != 0 ? anagra.codcab : '' }}</div>
                    </div>
                </div>
                <div class="resume_table btop blft bbtm brgt fl w35"
                     style="margin-left: 4.9%"> {# btop blft bbtm brgt pad fl w50 #}
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Pcs.</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ totqty }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Items</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ numdsserm }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Groups</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ groupItem|length }}</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Note Header -->
        <div class="w100 mt10" style="line-height:15px">
            <div class="notes_row pad">
                <div class="btop blft bbtm brgt pad w100 fl capitalize">{{ mt._('_common.notes') }}</div>
                <div class="blft bbtm brgt pad w100 fl">{{ octest.notcli }}&nbsp;</div>
            </div>
        </div>

        <!-- Content Table -->
        <table class="w100 articles-table pad">
            <!-- Content Table - Header -->
            <thead>
            <tr>
                <th class="main_col {# des_col #}">
                    {{ mt._('_common.description') }}
                </th>
                <th class="main_col {# art_col #}">
                    {{ mt._('_common.article') }}
                </th>
                <th class="{# col_col #} center">
                    {{ mt._('pdf.color.short') }}
                </th>
                {#<th class="#}{# mod_col #}{# center">
                    {{ mt._('_common.model') }}
                </th>#}
                <th class="{# um_col #} center">
                    {{ mt._('pdf.size.UM') }}
                </th>
                <th class="size_index_col center">
                    &nbsp;
                </th>
                <th class="{# siz1_col #} center" colspan="{{ maxDimension }}">
                    {{ mt._('pdf.qty.persize') }}
                </th>
                <th class="{# tqt_col #} center">
                    {{ mt._('pdf.tot') }}
                </th>
                <th class="{# prc_col #} right">
                    {{ mt._('pdf.price.short') }}
                </th>
                <th class="{# tam_col #} right">
                    {{ mt._('pdf.total.taxable.short') }}
                </th>
            <tr>
                <!-- Liste delle scale taglie (3) -->
                {% for i in 0..2 %}
            <tr class="sizes-row">
                <th class="{# des_col #}">
                    &nbsp;
                </th>
                <th class="{# art_col #}">
                    &nbsp;
                </th>
                <th class="{# col_col #} center">
                    &nbsp;
                </th>
                {#<th class="#}{# mod_col #}{# center">
                    &nbsp;
                </th>#}
                <th class="{# um_col #} center">
                    &nbsp;
                </th>
                <th class="size_index_col center">
                    {{ i + 1 }}
                </th>
                {% set size = scala_taglie[i] is defined ? scala_taglie[i] : [] %}
                {% for i2 in 0..(maxDimension - 1) %}
                    {% set taglia = (size[i2] is defined) ? size[i2] : '&nbsp;' %}
                    <th class="size_label_col{{ maxDimension > 10 ? '_sm' : '' }} center">{{ taglia }}</th>
                {% endfor %}
                <th class="{# tqt_col #} center">
                    &nbsp;
                </th>
                <th class="{# prc_col #} right">
                    &nbsp;
                </th>
                <th class="{# tam_col #} right">
                    &nbsp;
                </th>
            <tr>
                {% endfor %}
            </thead>
            {{ '<tbody>' }}
            {% set currentHeight = headerHeight %}
            {% endif %}
            {% set currentHeight = currentHeight + rowHeight %}

            <!-- Content Table - Article Row -->
            <tr style="background-color:{{ bg }};line-height:20px;">
                <td class="{# des2_col #}">{{ article.dsartn }}</td>
                <td class="{# art2_col #}">{{ article.cdartn }}</td>
                <td class="{# col2_col #} center">{{ article.cdcolo }}</td>
                {#<td class="#}{# mod2_col #}{# center">{{ article.dsserm }}</td>#}
                <td class="{# um2_col #} center">PZ</td>
                <td class="{# size2_index_col #} center">
                    {{ (indexCdTagl[article.cdtagl] is defined) ? indexCdTagl[article.cdtagl] : '' }}
                </td>
                {% set totmerce = 0 %}
                {% set rowQuanti = 0 %}
                {% for tagliaIdx in 1..maxDimension %}
                    <td class="size_label_col{{ maxDimension > 10 ? '_sm' : '' }} center">
                        {% for qtaTaglia in article.octagl %}
                            {% if qtaTaglia.postgl == tagliaIdx %}
                                {{ (qtaTaglia.quanti > 0) ? qtaTaglia.quanti : '' }}
                                {% set rowQuanti = rowQuanti + qtaTaglia.quanti %}
                                {% break %}
                            {% endif %}
                        {% endfor %}
                    </td>
                {% endfor %}
                <td class="{# tqt2_col #} center">{{ rowQuanti }}</td>
                <td class="{# prc2_col #} right">{{ (article.octagl[0].prezzo)|currency }} {{ currency }}</td>
                <td class="{# tam2_col #} right">{{ (rowQuanti * article.octagl[0].prezzo)|currency }} {{ currency }}</td>
                {% set totamt = totamt + (rowQuanti * article.octagl[0].prezzo) %}
                {% set totmerce = totmerce + totamt %}
                {% set discount1 = ( article.octagl[0].scont1 * currency )/100 %}
                {% set discount2 = ( article.octagl[0].scont2 * discount1 )/100 %}
                {% set discount3 = ( article.octagl[0].scont3 * discount2 )/100 %}
                {% set discount = discount1 + discount2 + discount3 %}
                {# 100 * ((article.octagl[0].scont1) / 100) + (article.octagl[0].scont2 / 100) + (article.octagl[0].scont3 / 100) #}
            </tr>
            {% if article.cdvari != '' or article.dsnoco != '' %}
                <tr class="w100 brgt bbtm blft pad" style="background-color:{{ bg }};line-height:18px">
                    <td colspan="99">
                        {{ article.dsvari }}{{ article.cdvari != '' ? ' - '  : '' }}{{ article.dsnoco }}
                    </td>
                </tr>
            {% endif %}
            {% if loop.last %}
                <!-- Chiusura tabella nell'ultimo ciclo -->
                {{ '</tbody></table>' }}
            {% endif %}
            {% endfor %}

            <!--Qua sotto è il codice che gestisce l'ultima riga in grigio contenente totale quantità e valore-->
            <div class="w100 brgt blft table-sum"
                 style="background-color: #c0c0c0; line-height:18px;margin-top:10px; border-top:1px solid black; width:100%; text-align: center">
                <div style="text-transform:uppercase;width:13%">{{ mt._('pdf.total.pcs') }}</div>
                <div style="text-transform:uppercase;width:12%">{{ mt._('pdf.total.discount') }}</div>
                <div style="text-transform:uppercase;width:12%">{{ mt._('pdf.iva.descr') }}</div>
                <div style="text-transform:uppercase;width:13%">{{ mt._('pdf.imponi') }}</div>
                <div style="text-transform:uppercase;width:12%">{{ mt._('pdf.iva.import') }}</div>
                <div style="text-transform:uppercase;width:13%">{{ mt._('pdf.tot.imponi') }}</div>
                <div style="text-transform:uppercase;width:12%">{{ mt._('pdf.tot.iva') }}</div>
                <div style="text-transform:uppercase;width:13%">{{ mt._('pdf.tot.order') }}</div>
            </div>
            <div class="w100 brgt blft table-sum"
                 style="background-color:#ffffff;line-height:18px;border-bottom:1px solid black; width:100%; text-align: center">
                <div style="width:13%;">
                    {{ totmerce|currency }} {{ currency }}
                </div>
                <div style="width:12%;">
                    {{ discount|currency }} {{ currency }}
                </div>
                <div style="width:12%;">
                    {{ mt._('pdf.iva.percentage', {'value': vat}) }}
                </div>
                <div  style="width:13%;">
                    {% set imponibile = totmerce - discount %}{{ imponibile|currency }} {{ currency }}
                </div>
                <div style="width:12%;">
                    {% set importoIva= ((imponibile * vat) / 100) %}
                    {{ importoIva|currency }} {{ currency }}
                </div>
                <div style="width:13%;">
                    {{ imponibile|currency }} {{ currency }}
                </div>
                <div style="width:12%;">
                    {{ importoIva|currency }} {{ currency }}
                </div>
                <div style="width:13%">
                    {% set totOrdine =  imponibile + importoIva %}
                    {{ totOrdine|currency }} {{ currency }}
                </div>
            </div>
    </div>

    </body>
{% endblock %}
