{% extends "base_pdf.volt" %}

{% block body %}
    {# SET BILLING INFO #}
    {% set billing_address = anagra.cdanag ~ ' - ' ~ anagra.descri ~ '<br/>' ~ anagra.indiri ~ ' - ' ~ anagra.codcap ~ ' ' ~ anagra.ccitta %}
    {% if anagra.provin != '' %}{% set billing_address = billing_address ~ ' (' ~ anagra.provin ~ ')' %}{% endif %}
    {% if anagra.dsnazi != '' %}{% set billing_address = billing_address ~ ' - ' ~ anagra.dsnazi %}{% endif %}
    {% if anagra.pariva != '' %}{% set billing_address = billing_address ~ '<br/>' ~ mt._('account.customer.vatcode.short') ~ ': ' ~ anagra.pariva %}{% endif %}
    {% if anagra.codfis != '' %}{% set billing_address = billing_address ~ '<br/>' ~ mt._('account.customer.taxcode.short') ~ ': ' ~ anagra.codfis %}{% endif %}

    {# SET SHIPPING INFO #}
    {% set shipping_address = "" %}
    {% if (not(desmer is empty)) %}
        {% set shipping_address = desmer.indiri ~ ' - ' ~ desmer.codcap ~ ' ' ~ desmer.ccitta %}
        {% if desmer.provin != '' %}{% set shipping_address = shipping_address ~ ' (' ~ desmer.provin ~ ')' %}{% endif %}
        {% if desmer.dsnazi != '' %}{% set shipping_address = shipping_address ~ ' - ' ~ desmer.dsnazi %}{% endif %}
    {% else %}
        {% set shipping_address = billing_address %}
    {% endif %}

    {# SET PAYMENTO INFO #}
    {% set hdr_ord_pay = "" %}
    {% if octest.tppaga == "payp" %}{% set hdr_ord_pay = "PayPal" %}
    {% elseif octest.tppaga == "stri" %}{% set hdr_ord_pay = "Stripe" %}
    {% elseif anagra.dspaga != '' %}{% set hdr_ord_pay = anagra.dspaga %}
    {% else %}{% set hdr_ord_pay = "&nbsp;" %}{% endif %}

    {# SET HEADER HTML #}
    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    {% set hdr_logo = exist_logo
        ? "<div class='w25 cell-high logo'><img src='" ~ url(imgurl) ~ "'/></div>"
        : "<div class='w25 cell-high logo'><br/></div>" %}

{% set hdr_cust = "<div class='w25 cell-high btop blft'>
    <div><span class='title'>" ~ mt._('pdf.info.billing') ~ "</span></div>
    <div><span>" ~ billing_address ~ "</span></div>
  </div>" %}
{% set hdr_ship = "<div class='w25 cell-high btop blft'>
    <div><span class='title'>" ~ mt._('pdf.info.shipping') ~ "</span></div>
    <div><span>" ~ shipping_address ~ "</span></div>
  </div>" %}
{% set hdr_type = "<div class='w25 cell-high btop blft brgt'>
    <div><span class='title'>" ~ (octest.tpordc == 0 ? mt._('order.availability') : mt._('order.reservation')) ~ "</span></div>
  </div>" %}

{% set hdr_ordn = "<div class='w25 cell btop blft'>
    <div><span class='title'>" ~ mt._('_common.order') ~ "</span></div>
    <div><span>" ~ octest.nuordc ~ " - " ~ octest.dtcrea ~ "</span></div>
  </div>" %}
{% set hdr_dlvr = "<div class='w25 cell btop blft'>
    <div><span class='title'>" ~ mt._('_common.delivery') ~ "</span></div>
    <div><span>" ~ octest.dtmcli ~ "</span></div>
  </div>" %}
{% set hdr_ctlg = "<div class='w" ~ (anaage != -1 ? '25' : '50 brgt') ~ " cell btop blft'>
    <div><span class='title'>" ~ mt._('_common.catalog') ~ "</div>
    <div><span>" ~ (octest.dscata != '' ? octest.dscata : octest.cdcata) ~ "</div>
  </div>" %}
{% set hdr_agnt = anaage != -1
    ? "<div class='w25 cell btop blft brgt'>
      <div><span class='title'>" ~ mt._('_common.agent') ~ "</span></div>
      <div><span>" ~ anaage.cdagen ~ " - " ~ anaage.dsagen ~ "</span></div>
    </div>"
    : "" %}

{% set hdr_cndp = "<div class='w" ~ (octest.tpindo != null ? '25' : '50') ~ " cell btop blft'>
    <div><span class='title'>" ~ mt._('admin.condition.payment') ~ "</span></div>
    <div><span>" ~ hdr_ord_pay ~ "</span></div>
  </div>" %}
{% set hdr_cnds = "<div class='w" ~ (octest.tpindo != null ? '25' : '50 brgt') ~ " cell btop blft'>
    <div><span class='title'>" ~ mt._('admin.condition.shipment') ~ "</span></div>
    <div><span>" ~ anagra.dstpor ~ "</span></div>
  </div>" %}
{% set hdr_indo = octest.tpindo != null
    ? "<div class='w50 cell btop blft brgt'>
      <div><span class='title'>" ~ mt._('_common.indicative') ~ "</span></div>
      <div><span>" ~ anagra.tpindo ~ "</span></div>
    </div>"
    : "" %}

{% set hdr_note = "<div class='w" ~ (false ? '50' : '100 brgt') ~ " cell-high btop blft bbtm'>
    <div><span class='title'>" ~ mt._('_common.notes') ~ "</span></div>
    <div><span>" ~ octest.notcli ~ "</br>" ~ octest.notazi ~ "</span></div>
  </div>" %}
{% set hdr_prom = false
    ? "<div class='w50 cell-high btop blft brgt bbtm'>
      <div><span class='title'>" ~ mt._('_common.promo') ~ "</span></div>
      <div><span>TODO TODO TODO</span></div>
    </div>"
    : "" %}

{# HEADER (min-height: 260px + padding-bottom: 40px) #}
{% set header = "<header>" ~
    hdr_logo ~ hdr_cust ~ hdr_ship ~ hdr_type ~
    hdr_ordn ~ hdr_dlvr ~ hdr_ctlg ~ hdr_agnt ~
    hdr_cndp ~ hdr_cnds ~ hdr_indo ~
    hdr_note ~ hdr_prom ~
    "</header>" %}

{# SPACAER #}
{% set spacer = "<div class='spacer'></div>" %}

{# ARTICLE HEADER #}
{% set hdr_articles = "<div class='articles-header btop blft brgt'>" ~
    "<div class='w1'>" ~ mt._('_common.row') ~ "</div>
    <div class='w2 blft'>" ~ mt._('_common.article') ~ "</div>
    <div class='w3 blft'>" ~ mt._('_common.image') ~ "</div>
    <div class='w4 blft'>" ~ mt._('_common.description') ~ "</div>
    <div class='w5 blft'>" ~ mt._('_common.sizes.qty') ~ "</div>
    <div class='w6 blft'>" ~ mt._('_common.total.qty') ~ "</div>
    <div class='w7 blft'>" ~ mt._('_common.price.unit') ~ "</div>
    <div class='w8 blft'>" ~ mt._('_common.total') ~ "</div>
  </div>" %}

    <body id="pdf4">
    {{ header }}

    {{ spacer }}

    {{ hdr_articles }}

    {% if articles|length > 0 %}
        {% set max_rows_page = orientation == 0 ? 6 : 7 %}
        {% set full_total_qty = 0 %}
        {% set full_total_prc = 0 %}

        {% for article in articles %}
            {# SET IMAGES #}
            {% set imgurl_n = "img/temp/resize/model/" ~ article.flimag_n %}
            {% set imgurl_i = "img/temp/resize/model/" ~ article.flimag_i %}
            {% set imgurl_c = "img/temp/resize/model/" ~ article.flimag_c %}
            <?php $exist_n = $article->flimag_n != '' && file_exists($imgurl_n); ?>
            <?php $exist_i = $article->flimag_i != '' && file_exists($imgurl_i); ?>
            <?php $exist_c = $article->flimag_c != '' && file_exists($imgurl_c); ?>

            {% if not exist_n and article.flimag_n != '' %}
                {% set imgurl_n = "img/model/" ~ article.flimag_n %}
                <?php $exist_n = file_exists($imgurl_n); ?>
            {% endif %}
            {% if not exist_i and article.flimag_i != '' %}
                {% set imgurl_i = "img/model/" ~ article.flimag_i %}
                <?php $exist_i = file_exists($imgurl_i); ?>
            {% endif %}
            {% if not exist_c and article.flimag_c != '' %}
                {% set imgurl_c = "img/model/" ~ article.flimag_c %}
                <?php $exist_c = file_exists($imgurl_c); ?>
            {% endif %}

            {# SET PRICE #}
            {% set prc_rows = 1 %}
            {% set qty_rows = 2 + (article.ocasso is defined ? article.ocasso|length : 0) + (orientation == 1 ? 2 : 0) %}
            {% set price_for_size = false %}
            {% set price = article.octagl[0].prezzo %}
            {% set total = 0 %}

            {% for size in article.octagl %}
                {% set total = total + (size.prezzo * size.quanti) %}
                {% if price != size.prezzo %}
                    {% set price_for_size = true %}
                {% endif %}
            {% endfor %}

            {% set prices = "" %}
            {% if article.prices|length > 1 %}
                {% set prc_rows = 0 %}
                {% set first_section_size = article.prices[0].taglia %}
                {% set last_section_size  = article.prices[0].taglia %}
                {% set last_price = article.prices[0].prezzo %}
                {% set cdvalu = article.prices[0].cdvalu %}
                {% for price in article.prices %}
                    {% if loop.first %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia %}
                    {% elseif loop.last and price == last_price %}
                        {% set prices = prices ~ " / " ~ price.taglia ~ ": " ~ price ~ " " ~ cdvalu ~ "</div>" %}
                    {% elseif loop.last and price != last_price %}
                        {% if first_section_size == last_section_size %}
                            {% set prices = prices ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% else %}
                            {% set prices = prices ~ " / " ~ last_section_size ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% endif %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia ~ ": " ~ price ~ " " ~ cdvalu ~ "</div>" %}
                    {% elseif price == last_price %}
                        {% set last_section_size = price.taglia %}
                    {% elseif price != last_price %}
                        {% if first_section_size == last_section_size %}
                            {% set prices = prices ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% else %}
                            {% set prices = prices ~ " / " ~ last_section_size ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% endif %}
                        {% set first_section_size = price.taglia %}
                        {% set last_section_size = price.taglia %}
                        {% set last_price = price %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia %}
                    {% endif %}
                {% endfor %}
            {% else %}
                {% set prices = "<div class='pad'>" ~ (article.tppers != "PT" or article.cdvari is null or article.cdvari == "" ? price : (price + article.preagg))|currency ~ " " ~ currency ~ "</div>" %}
            {% endif %}
            {% if prc_rows < qty_rows %}
                {% for i in 0..(qty_rows - prc_rows - 1) %}{% set prices = prices ~ "<div class='pad'>&nbsp;</div>" %}{% endfor %}
            {% endif %}

            {# SET ARTICLE DESCRIPTION #}
            {% set article_description = "" %}
            {% if descr == 0 %}{% set article_description = article.cdarti ~ " - " ~ article.dsarti %}
            {% elseif descr == 1 %}{% set article_description = article.cdcolo ~ " - " ~ article.dsarti %}
            {% elseif descr == 2 %}{% set article_description = article.cdcolo ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 3 %}{% set article_description = article.cdarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 4 %}{% set article_description = article.dsarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}{% endif %}

            {% set total_row_prc = 0 %}
            {% set total_row_qty = 0 %}
            {% set total_mod_qty = 0 %}

            <div class="w100 row-pdf btop blft brgt">
                <div class="w1 cell-row fl lh20">{{ loop.index }}</div>
                <div class="w2 cell-row blft fl lh20">{{ article.cdarti }}</div>
                <div class="w3 cell-row blft fl lh20">
                    {% if article.tppers != "PT" %}
                        {{ exist_i ? "<img src='" ~ url(imgurl_i) ~ "' class='img-sm'/>" : "<br/>" }}
                    {% endif %}
                    {% if article.tppers == "PT" %}
                        {{ exist_n ? "<img src='" ~ url(imgurl_n) ~ "' class='img-sm'/>" : "<br/>" }}
                        {{ exist_c ? "<img src='" ~ url(imgurl_c) ~ "' class='img-sm'/>" : "<br/>" }}
                    {% endif %}
                </div>
                <div class="w4 cell-row blft fl lh20">{{ article_description }}</div>
                <div class="w5 cell-row blft fl lh20">
                    {% for size in article.octagl %}
                        {% set total_row_qty = total_row_qty + size.quanti %}
                        {% if article.tppers != 'PT' or article.cdvari is null or article.cdvari == '' %}
                            {% set total_row_prc = total_row_prc + (size.quanti * size.prezzo) %}
                        {% else %}
                            {% set total_row_prc = total_row_prc + (size.quanti * (size.prezzo + article.preagg)) %}
                        {% endif %}
                        <div style="width:{{ 100 / article.octagl|length }}%" class="fl center">
                            <div class="bold center">{{ size.taglia }}</div>
                            <div class="center">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                        </div>
                    {% endfor %}
                </div>
                <div class="w6 cell-row blft fl lh20">{{ total_row_qty }}</div>
                <div class="w7 cell-row blft fl lh20">{{ prices }}</div>
                <div class="w8 cell-row blft fl lh20">{{ total_row_prc|currency }} {{ currency }}</div>
            </div>

            <div class="w100 row-pdf btop blft brgt {% if loop.last %}bbtm{% endif %}">
                <div class="w100 lh20 tit">{{ mt._('_common.notes') }}</div>
                <div class="w100 lh20 val">{{ article.tpnoco }} {{ article.dsnoco }}</div>
            </div>

            {% set full_total_prc = full_total_prc + total_row_prc %}
            {% set full_total_qty = full_total_qty + total_row_qty %}
            {% set total_mod_qty = total_mod_qty + total_row_qty %}
            {% if loop.last or article.cdartn != articles[loop.index].cdartn %}
                {{ spacer }}
                <div class="w50 row-pdf btop blft brgt bbtm">
                    <div class="w50 fl lh20 tit">{{ mt._('_common.total.qty.mod') }}</div>
                    <div class="w50 fl lh20 blft val">{{ total_mod_qty }}</div>
                </div>
                {% set total_mod_qty = 0 %}
            {% endif %}

        {% endfor %}

        {{ spacer }}

        <div class="w50 row-pdf btop blft brgt">
            <div class="w25 fl lh20">{{ mt._('_common.amount.net') }}</div>
            <div class="w25 fl lh20 blft">{{ full_total_prc }} {{ currency }}</div>
        </div>
        <div class="w50 row-pdf btop blft brgt bbtm">
            <div class="w25 fl lh20">{{ mt._('_common.discount') }}</div>
            <div class="w25 fl lh20 blft">{{ anagra.scont1 }} {{ anagra.scont2 }} {{ anagra.scont3 }}</div>
            <div class="w25 fl lh20 blft">{{ mt._('_common.total.qty') }}</div>
            <div class="w25 fl lh20 blft">{{ full_total_qty }}</div>
        </div>

    {% endif %}

    </body>
{% endblock %}
