{% extends "base_pdf.volt" %}

{% block body %}
    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    <body id="pdf100">
    <div class="pb_before">
        <div class="w100 fl pad pbi_avoid">
            <div class="w50 pad fl">
                {{ exist_logo ? "<img src='" ~ url(imgurl) ~ "'/>" : "<br/>" }}
            </div>
            <div class="w50 pad fl" style="line-height:18px">
                <div class="btop blft bbtm brgt pad" style="overflow:hidden">
                    <div class="fl w20 bold capitalize">{{ mt._('_common.customer') }}</div>
                    <div class="fl w80">
                        {{ anagra.descri }}<br/>
                        {{ anagra.indiri }}<br/>
                        {{ anagra.codcap }}&nbsp;&nbsp;&nbsp;&nbsp;{{ anagra.ccitta }}&nbsp;{{ anagra.provin }}
                    </div>
                    <div class="fl w20 bold capitalize">{{ mt._('_common.catalog') }}</div>
                    <div class="fl w80">{{ octest.dscata }}</div>
                    <div class="fl w20 bold capitalize">{{ mt._('_common.brand') }}</div>
                    <div class="fl w80">&nbsp;</div>
                </div>
            </div>
        </div>
        {% for detail in details %}
            {# SET IMAGES #}
            {% set imgurl_n = "img/model/" ~ detail.flimag_n %}
            {% set imgurl_c = "img/model/" ~ detail.flimag_c %}
            <?php $exist_n = $detail->flimag_n != '' && file_exists($imgurl_n); ?>
            <?php $exist_c = $detail->flimag_c != '' && file_exists($imgurl_c); ?>
            <div class="w100 fl pad mt10 pbi_avoid">
                <div class="w50 pad fl">
                    <div class="btop blft bbtm brgt pad center bold"
                         style="overflow:hidden;height:20px;line-height:20px;font-size:13px">
                        {{ mt._('_common.model') }} {{ detail.cdartn }}
                    </div>
                    <div class="blft bbtm brgt pad" style="overflow:hidden;height:270px">
                        <div class="w100 fl pad" style="height:200px;text-align:center">
                            {{ exist_n ? "<img src='" ~ url(imgurl_n) ~ "' style='padding-top:5px;max-height:195px;max-width:100%;margin:0 auto'/>" : "<br/>" }}
                        </div>
                        <div class="w100 fl pad"
                             style="height:70px;line-height:15px;word-wrap:break-word;white-space:initial">
                            {{ detail.dsartn }}<br/>
                            {{ detail.dscomm }}{{ detail.dstecn != '' ? ' | ' ~ detail.dstecn : '' }}
                        </div>
                    </div>
                </div>
                <div class="w50 pad fl">
                    <div class="btop blft bbtm brgt pad center bold"
                         style="overflow:hidden;height:20px;line-height:20px;font-size:13px">
                        {{ mt._('_common.tissue') }} {{ detail.cdpers }} ({{ detail.compos }}
                        )&nbsp;&nbsp;&nbsp;&nbsp;{{ mt._('_common.color') }} {{ detail.cdcolo }}
                    </div>
                    <div class="blft bbtm brgt pad" style="overflow:hidden;height:270px;text-align:center">
                        {{ exist_c ? "<img src='" ~ url(imgurl_c) ~ "' style='padding-top:5px;max-height:265px;max-width:100%;margin:0 auto'/>" : "<br/>" }}
                    </div>
                </div>
            </div>
        {% endfor %}
    </div>
    </body>
{% endblock %}
