{% extends "base_pdf.volt" %}

{% block body %}
    <body id="pdf1">
    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>
    {# CUSTOMER TABLE #}
    <table cellspacing="0" cellpadding="10">
        <tr>
            {% if exist_logo %}
                <td class="vtop w20" rowspan="3"><img src="{{ url(imgurl) }}" class="logo-tbl"/></td>
            {% endif %}
            <td class="vtop btop brgt blft {{ exist_logo ? 'w40' : 'w50' }}" colspan="2">
                <span class="title">{{ mt._('_common.customer') }}</span><br/>
                <span>
          {{ mt._('_common.code.short') }} {{ anagra.cdanag }}<br/>
          {{ anagra.descri }}<br/>{{ anagra.indiri }}<br/>
          {{ anagra.codcap }} {{ anagra.ccitta }}{% if anagra.provin != '' %} ({{ anagra.provin }}){% endif %}
                    {% if anagra.dsnazi != '' %} - {{ anagra.dsnazi }}{% endif %}<br/>
          {% if anagra.pariva != '' %}{{ mt._('account.customer.vatcode.short') }}: {{ anagra.pariva }}{% endif %}
                    {% if anagra.codfis != '' %}{% if anagra.pariva != '' %} / {% endif %}{{ mt._('account.customer.taxcode.short') }}: {{ anagra.codfis }}{% endif %}
        </span>
            </td>
            <td class="btop vtop {{ exist_logo ? 'w28' : 'w40' }}">
                <span class="title">{{ mt._('_common.destination') }}</span><br/>
                <span>
          {% if (not(desmer is empty)) %}
              {% if desmer.cddesm > 0 %}{{ mt._('_common.code.short') }} {{ desmer.cddesm }}<br/>{% endif %}
          {{ desmer.desvid }}<br/>
              {{ desmer.indiri }}<br/>
              {{ desmer.codcap }} {{ desmer.ccitta }}
              {% if desmer.provin != '' %} ({{ desmer.provin }}){% endif %}
              {% if desmer.dsnazi != '' %} - {{ desmer.dsnazi }}{% endif %}
          {% else %}&nbsp;{% endif %}
        </span>
            </td>
            <td class="btop brgt right {{ exist_logo ? 'w12' : 'w10' }} pdl5">
        <span class="bold">
          {% if octest.flstat == 1 %}{{ mt._('account.order.notsent') }}
          {% elseif octest.flstat == 2 %}{{ mt._('account.order.sent') }}
          {% elseif octest.flstat == 3 %}{{ mt._('account.order.accepted') }}
          {% elseif octest.flstat == 4 %}{{ mt._('account.order.rejected') }}{% endif %}
        </span>
            </td>
        </tr>
        <tr>
            <td class="btop brgt blft vtop">
            <span class="title">{{ mt._('pdf.code.payment') }}</span><br/>
            <span>{{ octest.tppaga > 0 ? octest.tppaga : '&nbsp;' }}</span>
            </td>
            <td class="btop brgt vtop">
            <span class="title">{{ mt._('_common.payment.cond') }}</span><br/>
            <span>{% if octest.tppaga == "payp" %}PayPal{% elseif octest.tppaga == "stri" %}Stripe{% elseif anagra.dspaga != '' %}{{ anagra.dspaga }}{% else %}&nbsp;{% endif %}</span>
            </td>
            <td class="btop brgt vtop" {% if label == 0 %}colspan="2"{% endif %}>
                <span class="title">{{ mt._('_common.shipping.cond') }}</span><br/>
                <span>{{ anagra.dstpor != '' ? anagra.dstpor : '&nbsp;' }}</span>
            </td>
            {% if label == 1 %}
                <td class="btop brgt vtop">
                    <span class="title">{{ mt._('_common.label') }}</span><br/>
                    <span>{{ octest.dsetic != '' ? octest.dsetic : '&nbsp;' }}</span>
                </td>
            {% endif %}
        </tr>
        <tr>
            <td class="notes" colspan="4">
                <div>
                    <span class="title">{{ mt._('_common.notes') }}</span><br/>
                    <span>{{ octest.notcli }}&nbsp;</span>
                </div>
            </td>
        </tr>
    </table>

    {# HEADER ORDER TABLE #}
    <table class="header-order-table" cellspacing="0" cellpadding="10">
        <tr>
            <td class="btop2 brgt2 bbtm2 blft2 vtop bg-gray">
                <span class="title">{{ mt._('_common.ordernumber') }}</span><br/>
                <span>{{ octest.nuordc }}&nbsp;</span>
            </td>
            <td class="btop2 brgt2 bbtm2 vtop bg-gray">
                <span class="title">{{ mt._('_common.date') }}</span><br/>
                <span>{{ octest.dtcrea }}&nbsp;</span>
            </td>
            <td class="btop2 brgt2 bbtm2 vtop bg-gray">
                <span class="title">{{ mt._('_common.delivery') }}</span><br/>
                <span>{{ octest.dtmcli }}&nbsp;</span>
            </td>
            <td class="btop2 brgt2 bbtm2 vtop bg-gray">
                <span class="title">{{ mt._('_common.catalog') }}</span><br/>
                <span>{{ octest.dscata }}&nbsp;</span>
            </td>
        </tr>
    </table>

    {% if articles|length > 0 %}
        {% set full_total_qty = 0 %}
        {% set full_total_prc = 0 %}

        {% set first_page = true %}
        {% set first_article_line = true %}

        {% set max_rows_first_page = orientation == 0 ? 11 : 23 %}
        {% set max_rows_other_page = orientation == 0 ? 20 : 33 %}
        {% set current_rows_page = 0 %}

        {% set curr_dstitl = articles[0].dstitl %}
        {% set curr_dslinm = articles[0].dslinm %}
        {% set curr_cdartn = articles[0].cdartn %}

        {% set total_qty_titlin = 0 %}
        {% set total_prc_titlin = 0 %}
        {% set total_qty_linmod = 0 %}
        {% set total_prc_linmod = 0 %}

        {% for article in articles %}
            {# PRICE SECTION #}
            {% set price_for_size = false %}
            {% set price = article.octagl[0].prezzo %}
            {% set total = 0 %}
            {% for size in article.octagl %}
                {% set total = total + (size.prezzo * size.quanti) %}
            {% endfor %}

            {% set prices = "" %}
            {% if article.prices|length > 1 %}
                {% set price_for_size = true %}
                {% set prices = mt._('quantity.priceforsize.short') %}
            {% endif %}

            {# HEADER - BRAND / LINE / ARTICLES #}
            {% if curr_cdartn != article.cdartn or loop.first %}
                {% if curr_dslinm != article.dslinm or loop.first %}

                    {% if not loop.first %}
                        <div class="summary-row">
                            <div class="fl lh20 orientation == 1 ? 'w36' : 'w50' }}">
                                <div class="sum-tot">{{ mt._('_common.total') }} {{ curr_dslinm }}</div>
                            </div>
                            <div class="fl lh20 orientation == 1 ? 'w12' : 'w10' }}">
                                <div class="sum-tot">{{ mt._('pdf.total.qty') }}</div>
                            </div>
                            <div class="fl lh20 btop brgt bbtm blft {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
                                <div class="glb">{{ total_qty_linmod }}</div>
                            </div>
                            <div class="fl lh20 {{ orientation == 1 ? 'w24' : 'w16' }}">
                                <div class="sum-tot">{{ mt._('pdf.total.taxable') }}</div>
                            </div>
                            <div class="fl lh20 btop brgt bbtm blft {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
                                <div class="sum-glb">{{ total_prc_linmod|currency }} {{ currency }}</div>
                            </div>
                        </div>
                    {% endif %}

                    {% if curr_dstitl != article.dstitl or loop.first %}

                        {% if not loop.first %}
                            <div class="summary-row">
                                <div class="fl lh20 {{ orientation == 1 ? 'w36' : 'w50' }}">
                                    <div class="sum-tot">{{ mt._('_common.total') }} {{ curr_dstitl }}</div>
                                </div>
                                <div class="fl lh20 {{ orientation == 1 ? 'w12' : 'w10' }}">
                                    <div class="sum-tot">{{ mt._('pdf.total.qty') }}</div>
                                </div>
                                <div class="fl lh20 btop brgt bbtm blft {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
                                    <div class="sum-glb">{{ total_qty_titlin }}</div>
                                </div>
                                <div class="fl lh20 orientation == 1 ? 'w24' : 'w16' }}">
                                    <div class="sum-tot">{{ mt._('pdf.total.taxable') }}</div>
                                </div>
                                <div class="fl lh20 btop brgt bbtm blft {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
                                    <div class="sum-glb">{{ total_prc_titlin|currency }} {{ currency }}</div>
                                </div>
                            </div>
                        {% endif %}

                        {% set curr_dstitl = article.dstitl %}

                        {% set total_qty_titlin = 0 %}
                        {% set total_prc_titlin = 0 %}
                        {% set total_qty_linmod = 0 %}
                        {% set total_prc_linmod = 0 %}

                        <div class="summary-tot-row">{{ curr_dstitl }}</div>
                    {% endif %}

                    {% set curr_dslinm = article.dslinm %}

                    {% set total_qty_linmod = 0 %}
                    {% set total_prc_linmod = 0 %}

                    {% set first_article_line = true %}

                    <div class="summary-tot-row">{{ curr_dslinm }}</div>
                {% else %}
                    {% set first_article_line = false %}
                {% endif %}

                {% set curr_cdartn = article.cdartn %}

                <div class="content {% if loop.first %}btop{% endif %}">
                    <div class="row-num">
                        <div class="padc">{{ mt._('pdf.row') }}</div>
                    </div>
                    <div class="row-cod">
                        <div class="padc">{{ mt._('_common.article.code.short') }}</div>
                    </div>
                    <div class="row-des">
                        <div class="padc">{{ mt._('_common.description') }}</div>
                    </div>
                    <div class="row-col">
                        <div class="padc">{{ mt._('_common.color') }}</div>
                    </div>
                    {% for size in article.octagl %}
                        <div class="fl lh20 center brgt" style="width:{{ 45 / article.octagl|length }}%">
                            <div class="padc">{{ size.taglia }}</div>
                        </div>
                    {% endfor %}
                    <div class="row-qty">
                        <div class="padc">{{ mt._('pdf.qty') }}</div>
                    </div>
                    <div class="row-prc">
                        <div class="padc">{{ mt._('_common.price') }}</div>
                    </div>
                    <div class="row-tot">
                        <div class="padc">{{ mt._('_common.total') }}</div>
                    </div>
                </div>
            {% endif %}

            <div class="content">
                <div class="row-num">
                    <div class="padc">{{ article.seqrap }}</div>
                </div>
                <div class="row-cod">
                    <div class="padc">{{ article.cdarti }}</div>
                </div>
                <div class="row-des">
                    <div class="padc">
                        {% if descr == 0 %}{{ article.cdarti }} - {{ article.dsarti }}
                        {% elseif descr == 1 %}{{ article.cdcolo }} - {{ article.dsarti }}
                        {% elseif descr == 2 %}{{ article.cdcolo }} - {{ article.dscolo }}
                        {% elseif descr == 3 %}{{ article.cdarti }} - {{ article.dscolo }}{% endif %}
                    </div>
                </div>
                <div class="row-col">
                    <div class="padc">{{ article.dscolo != '' ? article.dscolo : article.cdcolo }}</div>
                </div>
                {% set total_qty = 0 %}
                {% set total_prc = 0 %}
                {% for size in article.octagl %}
                    {% set total_qty = total_qty + size.quanti %}
                    {% if article.tppers != "PT" or article.cdvari is null or article.cdvari == "" %}
                        {% set total_prc = total_prc + (size.quanti * size.prezzo) %}
                    {% else %}
                        {% set total_prc = total_prc + (size.quanti * (size.prezzo + article.preagg)) %}
                    {% endif %}
                    <div class="fl lh20 center brgt" style="width:{{ 45 / article.octagl|length }}%">
                        <div class="padc">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                    </div>
                {% endfor %}
                <div class="row-qty">
                    <div class="padc">{{ total_qty }}</div>
                </div>
                <div class="row-prc">
                    <div class="padc">
                        {% if price_for_size %}{{ prices }}
                        {% elseif article.tppers != "PT" or article.cdvari is null or article.cdvari == "" %}{{ price|currency }}
                        {% else %}{{ (price + article.preagg)|currency }}{% endif %} {{ currency }}
                    </div>
                </div>
                <div class="row-tot">
                    <div class="padc">{{ total_prc|currency }} {{ currency }}</div>
                </div>
            </div>

            {% set total_qty_linmod = total_qty_linmod + total_qty %}
            {% set total_prc_linmod = total_prc_linmod + total_prc %}
            {% set total_qty_titlin = total_qty_titlin + total_qty %}
            {% set total_prc_titlin = total_prc_titlin + total_prc %}
            {% set full_total_qty = full_total_qty + total_qty %}
            {% set full_total_prc = full_total_prc + total_prc %}

        {% endfor %}
    {% endif %}

    <div class="summary-row">
        <div class="fl lh20 {{ orientation == 1 ? 'w36' : 'w50' }}">
            <div class="sum-tot">{{ mt._('_common.total') }} {{ curr_dslinm }}</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w12' : 'w10' }}">
            <div class="sum-tot">{{ mt._('pdf.total.qty') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ total_qty_linmod }}</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w24' : 'w16' }}">
            <div class="sum-tot">{{ mt._('pdf.total.taxable') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ total_prc_linmod|currency }} {{ currency }}</div>
        </div>
    </div>

    <div class="summary-row">
        <div class="fl lh20 {{ orientation == 1 ? 'w36' : 'w50' }}">
            <div class="sum-tot">{{ mt._('_common.total') }} {{ curr_dstitl }}</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w12' : 'w10' }}">
            <div class="sum-tot">{{ mt._('pdf.total.qty') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ total_qty_titlin }}</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w24' : 'w16' }}">
            <div class="sum-tot">{{ mt._('pdf.total.taxable') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ total_prc_titlin|currency }} {{ currency }}</div>
        </div>
    </div>

    <div class="summary-row">
        <div class="fl lh20 {{ orientation == 1 ? 'w36' : 'w50' }}">
            <div class="sum-tot">&nbsp;</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w12' : 'w10' }}">
            <div class="sum-tot">{{ mt._('pdf.total.qty') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ full_total_qty }}</div>
        </div>
        <div class="fl lh20 {{ orientation == 1 ? 'w24' : 'w16' }}">
            <div class="sum-tot">{{ mt._('pdf.total.taxable') }}</div>
        </div>
        <div class="btop brgt bbtm blft fl lh20 {{ orientation == 1 ? 'w14' : 'w12' }} pdr0">
            <div class="sum-glb">{{ full_total_prc|currency }} {{ currency }}</div>
        </div>
    </div>

    {% if note != '' %}
        <p>{{ note }}</p>
    {% endif %}

    </body>
{% endblock %}
