{% extends "base_pdf.volt" %}

{% block body %}

    {# SET BILLING INFO #}
    {% set billing_address = anagra.indiri ~ ' - ' ~ anagra.codcap ~ ' ' ~ anagra.ccitta %}
    {% if anagra.provin != '' %}{% set billing_address = billing_address ~ ' (' ~ anagra.provin ~ ')' %}{% endif %}
    {% if anagra.dsnazi != '' %}{% set billing_address = billing_address ~ ' - ' ~ anagra.dsnazi %}{% endif %}

    {# SET SHIPPING INFO #}
    {% set shipping_address = "" %}
    {% if (not(desmer is empty)) %}
        {% set shipping_address = desmer.indiri ~ ' - ' ~ desmer.codcap ~ ' ' ~ desmer.ccitta %}
        {% if desmer.provin != '' %}{% set shipping_address = shipping_address ~ ' (' ~ desmer.provin ~ ')' %}{% endif %}
        {% if desmer.dsnazi != '' %}{% set shipping_address = shipping_address ~ ' - ' ~ desmer.dsnazi %}{% endif %}
    {% else %}
        {% set shipping_address = billing_address %}
    {% endif %}

    {# SET HEADER HTML #}
    {% set hdr_ord_ord = octest.nuordc ~ " - " ~ octest.dtcrea %}
    {% set hdr_ord_typ = octest.tpordc == 0 ? mt._('order.availability') : mt._('order.reservation') %}
    {% set hdr_ord_del = octest.dtmcli %}
    {% if config.release.user === 'bed' %}
        {% set hdr_ord_del = utility.recuperaDescrizioneConsegnaBed(octest) %}
    {% endif %}
    {% set hdr_ord_cat = octest.dscata != '' ? octest.dscata : octest.cdcata %}
    {% set hdr_ord_pay = "" %}
    {% if octest.tppaga == "payp" %}{% set hdr_ord_pay = "PayPal" %}
    {% elseif octest.tppaga == "stri" %}{% set hdr_ord_pay = "Stripe" %}
    {% elseif octest.dspaga != '' %}{% set hdr_ord_pay = octest.dspaga %}
    {% else %}{% set hdr_ord_pay = "&nbsp;" %}{% endif %}
    {% set hdr_ord_shi = octest.dstpor %}

    {% set imgurl = 'img/' ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    {% set hdr_logo = exist_logo
        ? "<div class='w100 logo'><img src='" ~ url(imgurl) ~ "'/></div><hr/>"
        : "<div class='w100 logo'><br/></div><hr/>" %}

  {% set hdr_cust = "<div class='w100 cust'><span class='bold'>" ~ mt._('_common.customer') ~ ":</span> " ~ anagra.cdanag ~ " - " ~ anagra.descri ~ "</div>" %}
  {% set hdr_note = "<div class='w100 note'>
                      <div><span class='bold'>" ~ mt._('_common.notes.general') ~ ":</span> " ~ octest.notcli ~ "</div>
                      <div><span class='bold'>" ~ mt._('_common.notes.order') ~ ":</span> " ~  note ~ "</div>
                    </div>" %}

  {% set hdr_ordr = "<div class='w100'>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.order') ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.order') ~ ": " ~ hdr_ord_ord ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.type') ~ ": " ~ hdr_ord_typ ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.delivery') ~ ": " ~ hdr_ord_del ~ "</div>
                        <div class='capitalize'>" ~ mt._('_common.catalog') ~ ": " ~ hdr_ord_cat ~ "</div>
                        <div>" ~ mt._('_common.payment.cond') ~ ": " ~ hdr_ord_pay ~ "</div>
                        <div>" ~ mt._('_common.shipping.cond') ~ ": " ~ hdr_ord_shi ~ "</div>
                      </div>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.billing') ~ "</div>
                        <div>" ~ mt._('account.customer.address') ~ ": " ~ billing_address ~ "</div>
                        <div>" ~ mt._('account.customer.vatcode.short') ~ ": " ~ anagra.pariva ~ "</div>
                        <div>" ~ mt._('account.customer.taxcode.short') ~ ": " ~ anagra.codfis ~ "</div>
                      </div>
                      <div class='hdr_col'>
                        <div class='bold fs11'>" ~ mt._('pdf.info.shipping') ~ "</div>
                        <div>" ~ mt._('account.customer.address') ~ ": " ~ shipping_address ~ "</div>
                      </div>
                    </div>" %}

  {% set header = "<header class='pb_before'>" ~ hdr_logo ~ hdr_cust ~ hdr_ordr ~ hdr_note ~ "</header>" %}

  {# SET  HTML #}
  {% set footer = "<div class='" ~ (orientation == 0 ? 'footer-h' : 'footer-v') ~ " pb_after'>
      <span>" ~ (ftr_row_1 != '' ? ftr_row_1 : '&nbsp;') ~ "</span><br/>
      <span>" ~ (ftr_row_2 != '' ? ftr_row_2 : '&nbsp;') ~ "</span><br/>
      <span>" ~ (ftr_row_3 != '' ? ftr_row_3 : '&nbsp;') ~ "</span>
    </div>" %}

  {# First page will be
    VERTICAL
    - Row 1 starts at top:243px
    - Row 2 starts at top:385px
    - Row 3 starts at top:527px
    - Row 4 starts at top:669px
    - Row 5 starts at top:811px
    - Row 6 starts at top:953px
    - Row 7 starts at top:1095px
    - Row 7 ends at top:1237px
    - Footer starts at top:1267px
    HORIZONTAL
    - Row 1 starts at top:225px
    - Row 2 starts at top:327px
    - Row 3 starts at top:429px
    - Row 4 starts at top:531px
    - Row 5 starts at top:633px
    - Row 6 starts at top:735px
    - Row 6 ends at top:837px
    - Footer starts at top:859px
  #}
  {% set max_rows_page = orientation == 0 ? 6 : 7 %}
  {% set full_total_qty = 0 %}
  {% set full_total_prc = 0 %}

    <body id="pdf0">
    {% if articles|length > 0 %}
        {% for article in articles %}
            {# SET IMAGES #}
            {% set imgurl_n = "img/temp/resize/model/" ~ article.flimag_n %}
            {% set imgurl_i = "img/temp/resize/model/" ~ article.flimag_i %}
            {% set imgurl_c = "img/temp/resize/model/" ~ article.flimag_c %}
            <?php $exist_n = $article->flimag_n != '' && file_exists($imgurl_n); ?>
            <?php $exist_i = $article->flimag_i != '' && file_exists($imgurl_i); ?>
            <?php $exist_c = $article->flimag_c != '' && file_exists($imgurl_c); ?>

            {% if not exist_n and article.flimag_n != '' %}
                {% set imgurl_n = "img/model/" ~ article.flimag_n %}
                <?php $exist_n = file_exists($imgurl_n); ?>
            {% endif %}
            {% if not exist_i and article.flimag_i != '' %}
                {% set imgurl_i = "img/model/" ~ article.flimag_i %}
                <?php $exist_i = file_exists($imgurl_i); ?>
            {% endif %}
            {% if not exist_c and article.flimag_c != '' %}
                {% set imgurl_c = "img/model/" ~ article.flimag_c %}
                <?php $exist_c = file_exists($imgurl_c); ?>
            {% endif %}

            {# SET PRICE #}
            {% set prc_rows = 1 %}
            {% set qty_rows = 2 + (article.ocasso is defined ? article.ocasso|length : 0) + (orientation == 1 ? 2 : 0) %}
            {% set price_for_size = false %}
            {% set basePrice = article.octagl[0].prezzo %}
            {% set baseDiscount = article.octagl[0].scont1 %}
            {# TODO gli altri sconti? #}
            {% set total = 0 %}

            {% for size in article.octagl %}
                {% set total = total + (size.prezzo * size.quanti) %}
                {% if basePrice != size.prezzo %}
                    {% set price_for_size = true %}
                {% endif %}
            {% endfor %}

            {% set prices = "" %}
            {% if article.prices|length > 1 %}
                {% set prc_rows = 0 %}
                {% set first_section_size = article.prices[0].taglia %}
                {% set last_section_size = article.prices[0].taglia %}
                {% set last_price = article.prices[0].prezzo %}
                {% set cdvalu = article.prices[0].cdvalu %}
                {% for price in article.prices %}
                    {% if loop.first %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia %}
                    {% elseif loop.last and price == last_price %}
                        {% set prices = prices ~ " / " ~ price.taglia ~ ": " ~ price ~ " " ~ cdvalu ~ "</div>" %}
                    {% elseif loop.last and price != last_price %}
                        {% if first_section_size == last_section_size %}
                            {% set prices = prices ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% else %}
                            {% set prices = prices ~ " / " ~ last_section_size ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% endif %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia ~ ": " ~ price ~ " " ~ cdvalu ~ "</div>" %}
                    {% elseif price == last_price %}
                        {% set last_section_size = price.taglia %}
                    {% elseif price != last_price %}
                        {% if first_section_size == last_section_size %}
                            {% set prices = prices ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% else %}
                            {% set prices = prices ~ " / " ~ last_section_size ~ ": " ~ last_price ~ " " ~ cdvalu ~ "</div>" %}
                        {% endif %}
                        {% set first_section_size = price.taglia %}
                        {% set last_section_size = price.taglia %}
                        {% set last_price = price %}
                        {% set prc_rows = prc_rows + 1 %}
                        {% set prices = prices ~ "<div class='pad'>" ~ price.taglia %}
                    {% endif %}
                {% endfor %}
            {% else %}
                {% set basePriceValue = (article.tppers != "PT" or article.cdvari is null or article.cdvari == "" ? basePrice : (basePrice + article.preagg)) %}
                {% set discountedPriceValue = basePriceValue - (basePriceValue * ( baseDiscount / 100 )) %}
                {% set prices = "<div class='pad'>" ~ (baseDiscount > 0 ? '<del>' ~ basePriceValue|currency ~ '</del> ' ~ discountedPriceValue|currency  ~ " " ~ currency : basePriceValue ~ " " ~ currency)  ~ "</div>" %}
            {% endif %}
            {% if prc_rows < qty_rows %}
                {% for i in 0..(qty_rows - prc_rows - 1) %}{% set prices = prices ~ "<div class='pad'>&nbsp;</div>" %}{% endfor %}
            {% endif %}

            {# SET ARTICLE DESCRIPTION #}
            {% set article_description = "" %}
            {% if descr == 0 %}{% set article_description = article.cdarti ~ " - " ~ article.dsarti %}
            {% elseif descr == 1 %}{% set article_description = article.cdcolo ~ " - " ~ article.dsarti %}
            {% elseif descr == 2 %}{% set article_description = article.cdcolo ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 3 %}{% set article_description = article.cdarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}
            {% elseif descr == 4 %}{% set article_description = article.dsarti ~ " - " ~ (article.dscolo != '' ? article.dscolo : article.cdcolo) %}{% endif %}

            {# SET WIDTHS #}
            {% set width_row = orientation == 1 ? 6    : 4 %}
            {% set width_cod = orientation == 1 ? 18.5 : 12 %}
            {% set width_des = orientation == 1 ? 55.5 : 52 %}
            {% set width_del = orientation == 1 ? 20   : 6 %}
            {% set width_not = orientation == 1 ? 75.5 : 25 %}
            {% set width_img = orientation == 1 ? 15   : 10 %}
            {% set width_ass = orientation == 1 ? 10   : 4.75 %}
            {% set width_tro = orientation == 1 ? 12.5 : 6 %}
            {% set exist_del = true %}
            {% if article.dtmcli == '00/00/0000' or article.dtmcli == octest.dtmcli %}
                {% set exist_del = false %}
                {% if orientation == 1 %}
                    {% set width_des = width_des + width_del %}
                {% endif %}
                {% set width_not = width_not + (orientation == 0 ? width_del : width_img) %}
            {% endif %}
            {% set width_tax = orientation == 1 ? width_tro : width_del %}
            {% set width_siz = orientation == 1 ? 35 : width_des %}

            {% if loop.index % max_rows_page == 1 %}{{ header }}{% endif %}

            <div class="w100 row-pdf {% if loop.index % max_rows_page == 1 %}{{ orientation == 1 ? 'mt30' : 'mt12' }}{% endif %} {% if loop.index % max_rows_page == 0 or loop.last %}bbb{% endif %}">
                <div class="fl" style="width:{{ 100 - width_img }}%">
                    {# FIRST ROW #}
                    <div style="width:{{ width_row }}%" class="fl lh20">
                        <div class="title-row">{{ mt._('pdf.row') }}</div>
                        <div class="pad">{{ loop.index }}</div>
                    </div>
                    <div style="width:{{ width_cod }}%" class="fl lh20 bg-gray">
                        <div class="title-row">{{ mt._('_common.article.code.short') }}</div>
                        <div class="pad">{{ article.cdarti }}</div>
                    </div>
                    <div style="width:{{ width_des }}%" class="fl lh20">
                        <div class="title-row">{{ mt._('_common.description') }}</div>
                        <div class="pad">{{ article_description }}</div>
                    </div>
                    {% if orientation == 0 %}{# if horizontal put "notes" in first row, else add it in second row with price #}
                        <div style="width:{{ width_not }}%" class="fl lh20">
                            <div class="title-row">{{ mt._('_common.notes') }}</div>
                            <div class="pad">{{ article.dsnoco != '' ? article.dsnoco : '&nbsp;' }}</div>
                        </div>
                    {% endif %}
                    {% if exist_del %}
                        <div style="width:{{ width_del }}%" class="fl lh20">
                            <div class="title-row">{{ mt._('_common.delivery') }}</div>
                            <div class="pad">{{ article.dtmcli }}</div>
                        </div>
                    {% endif %}

                    {# SECOND ROW #}
                    <div style="width:{{ width_row + width_cod }}%" class="fl lh20" colspan="2">
                        <div class="title-row">{{ mt._('_common.price') }}</div>
                        {{ prices }}
                    </div>
                    {% if orientation == 1 %}{# if vertical put "notes" in second row with price #}
                    <div style="width:{{ 100 - (width_row + width_cod) }}%" class="fl lh20 fs9">
                        <div class="w100 fl" style="margin-bottom:-1px">
                            <div class="title-row">{{ mt._('_common.notes') }}</div>
                            <div class="pad">{{ article.dsnoco != '' ? article.dsnoco : '&nbsp;' }}</div>
                        </div>
                        {% endif %}
                        <div style="width:{{ width_siz }}%" class="fl lh20">
                            {% set total_prc = 0 %}
                            {% for size in article.octagl %}
                                {% set baseRowPrice = size.prezzo %}
                                {% if not (article.tppers != 'PT' or article.cdvari is null or article.cdvari == '') %}
                                    {% set baseRowPrice = (size.prezzo + article.preagg) %}
                                {% endif %}
                                {#  TODO gli altri sconti? #}
                                {% if size.scont1 is not empty %}
                                    {% set discountedRowPrice = baseRowPrice - (baseRowPrice * ( size.scont1 / 100 )) %}
                                {% endif %}

                                {% set total_prc = total_prc + (size.quanti * (discountedRowPrice is defined ? discountedRowPrice : baseRowPrice)) %}
                                <div style="width:{{ 100 / article.octagl|length }}%" class="fl center">
                                    <div class="pad bold">{{ size.taglia }}</div>
                                    <div class="pad">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                                    {% if article.ocasso is defined %}
                                        {% for asso in article.ocasso %}
                                            <div class="pad">{{ asso.defini[0].ascorp[size.taglia] is defined ? asso.defini[0].ascorp[size.taglia] : '&nbsp;' }}</div>
                                        {% endfor %}
                                    {% endif %}
                                    <div class="pad bold">{{ article.totals[size.taglia] > 0 ? article.totals[size.taglia] : '&nbsp;' }}</div>
                                    {% if qty_rows < prc_rows %}
                                        {% for i in 0..(prc_rows - qty_rows - 1) %}
                                            <div class="pad">&nbsp;</div>
                                        {% endfor %}
                                    {% endif %}
                                </div>
                            {% endfor %}
                        </div>
                        <div style="width:{{ width_ass }}%" class="fl lh20 fs9 center">
                            <div class="pad bold">{{ mt._('pdf.ass.type')|uppercase }}</div>
                            <div class="pad">{{ mt._('pdf.loose')|uppercase }}</div>
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    <div class="pad">{{ asso.cdasso|uppercase }}</div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">{{ mt._('pdf.tot')|uppercase }}</div>
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        <div style="width:{{ width_ass }}%" class="fl lh20 fs9 center">
                            <div class="pad bold">{{ mt._('pdf.ass.tot')|uppercase }}</div>
                            <div class="pad">&nbsp;</div>
                            {% set tot_prc_asso = 0 %}
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    {% set tot_asso = 0 %}
                                    {% for key, asso_qty in asso.defini[0].ascorp %}
                                        {% set tot_asso = tot_asso + asso_qty %}
                                        {% set asso_qty_price = basePrice %}
                                        {% for price in article.prices %}
                                            {# me sembra na cazzata dato che 'price' e' un oggetto #}
                                            {#{% if price.taglia == key %}{% set asso_qty_price = price %}{% endif %}#}
                                            {% if price.taglia == key %}{% set asso_qty_price = price.prezzo %}{% endif %}
                                        {% endfor %}
                                        {% set tot_prc_asso = tot_prc_asso + (asso_qty * asso_qty_price * asso.quanti) %}
                                    {% endfor %}

                                    <div class="pad">{{ tot_asso }}</div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">&nbsp;</div>
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        <div class="fl lh20 fs9 center" style="width:{{ width_ass }}%">
                            <div class="pad bold">{{ mt._('pdf.qty')|uppercase }}</div>
                            <div class="pad">&nbsp;</div>
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    <div class="pad">{{ asso.quanti }}</div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">&nbsp;</div>
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        <div class="fl lh20 fs9 center" style="width:{{ width_ass }}%">
                            <div class="pad bold">{{ mt._('pdf.qty.total')|uppercase }}</div>
                            <div class="pad">
                                {% set total_qty = 0 %}
                                {% set tot_sizes = 0 %}
                                {% for size in article.octagl %}{% set tot_sizes = tot_sizes + size.quanti %}{% endfor %}
                                {{ tot_sizes }}
                                {% set total_qty = total_qty + tot_sizes %}
                            </div>
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    {% set tot_asso = 0 %}
                                    <div class="pad">
                                        {% for asso_qty in asso.defini[0].ascorp %}{% set tot_asso = tot_asso + asso_qty %}{% endfor %}
                                        {{ tot_asso * asso.quanti }}
                                        {% set total_qty = total_qty + (tot_asso * asso.quanti) %}
                                    </div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">&nbsp;</div>
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        <div class="fl lh20 fs9 center bg-gray" style="width:{{ width_tro }}%">
                            <div class="pad bold">{{ mt._('pdf.qty.totrow')|uppercase }}</div>
                            <div class="pad mtm">&nbsp;</div>
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">{{ total_qty }}</div>
                            {% set full_total_qty = full_total_qty + total_qty %}
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        <div class="fl lh20 fs9 center bg-gray" style="width:{{ width_tax }}%">
                            <div class="pad bold">{{ mt._('pdf.taxable')|uppercase }}</div>
                            <div class="pad mtm">&nbsp;</div>
                            {% if article.ocasso is defined %}
                                {% for asso in article.ocasso %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                            <div class="pad bold">{{ (total_prc + tot_prc_asso)|currency }} {{ currency }}</div>
                            {% set full_total_prc = full_total_prc + (total_prc + tot_prc_asso) %}
                            {% if qty_rows < prc_rows %}
                                {% for i in 0..(prc_rows - qty_rows - 1) %}
                                    <div class="pad">&nbsp;</div>
                                {% endfor %}
                            {% endif %}
                        </div>
                        {% if orientation == 1 %}
                    </div>
                    {% endif %}
                </div>
                <div style="width:{{ width_img }}%" class="fl center">
                    {% if article.tppers != "PT" %}
                        {{ exist_i ? "<img src='" ~ url(imgurl_i) ~ "' class='img-sm'/>" : "<br/>" }}
                    {% endif %}
                    {% if article.tppers == "PT" %}
                        {{ exist_n ? "<img src='" ~ url(imgurl_n) ~ "' class='img-sm'/>" : "<br/>" }}
                        {{ exist_c ? "<img src='" ~ url(imgurl_c) ~ "' class='img-sm'/>" : "<br/>" }}
                    {% endif %}
                </div>
            </div>

            {% if not loop.last and loop.index % max_rows_page == 0 %}{{ footer }}{% endif %}

            {% if loop.last and loop.index % max_rows_page == 0 %}{{ header }}
                <div class="w100 row-pdf {{ orientation == 1 ? 'mt30' : 'mt12' }}"></div>{% endif %}

        {% endfor %}
    {% endif %}

    {# CALCULATE TOTAL WITH TAXES #}
    {% set shipmentAdditionalCost = (additionalCosts['addspe'] is not empty ? additionalCosts['addspe'] : 0) %}
    {% set paymentAdditionalCost = (additionalCosts['addpag'] is not empty ? additionalCosts['addpag'] : 0) %}
    {% set tax = 0 %}
    {% set imponibile = full_total_prc + shipmentAdditionalCost + paymentAdditionalCost %}
    {% if anagra.aliquo > 0 or anagra.dsaiva != '' %}
        {% set tax = (imponibile * anagra.aliquo) / 100 %}
    {% endif %}
    {% set total = imponibile + tax %}

    {# PRICES FOOTER #}
    <div class="{{ orientation == 0 ? 'prices-footer-h' : 'prices-footer-v' }}">
        <div class="fl" style="width:{{ orientation == 0 ? '62.8' : '26' }}%;">&nbsp;</div>
        <div class="ftr-totals" style="width:{{ orientation == 0 ? '6.4' : '14' }}%">
            <div class="title-row">{{ mt._('pdf.total.qty') }}</div>
            <div class="pad">{{ full_total_qty }}</div>
        </div>
        {% if shipmentAdditionalCost > 0 or paymentAdditionalCost > 0 %}
            <div class="ftr-totals" style="width:{{ orientation == 0 ? '6.4' : '14' }}%">
                <div class="title-row">{{ mt._('_common.additionalcosts.abbr') }}</div>
                <div class="pad">{{ (shipmentAdditionalCost + paymentAdditionalCost)|currency ~ ' ' ~ currency }}</div>
            </div>
        {% endif %}
        <div class="ftr-totals" style="width:{{ orientation == 0 ? '9' : '16' }}%">
            <div class="title-row">{{ mt._('pdf.total.taxable') }}</div>
            <div class="pad">{{ imponibile|currency }} {{ currency }}</div>
        </div>
        <div class="ftr-totals" style="width:{{ orientation == 0 ? '6.4' : '14' }}%">
            <div class="title-row">{{ mt._('_common.tax') }}</div>
            <div class="pad">{{ tax > 0 ? tax|currency ~ ' ' ~ currency : '&nbsp;' }}</div>
        </div>
        <div class="ftr-totals" style="width:{{ orientation == 0 ? '9' : '16' }}%">
            <div class="title-row">{{ mt._('_common.total') }}</div>
            <div class="pad">{{ total|currency }} {{ currency }}</div>
        </div>
    </div>

    {# Price Footer needs 55px less than pdf row, then we have to add heights of empty rows #}
    {% if orientation == 1 %}
        {% set offset = 19 + 142 * (max_rows_page - (1 + articles|length % max_rows_page)) %}
    {% else %}
        {% set offset = 98 * (max_rows_page - (1 + articles|length % max_rows_page)) %}
    {% endif %}

    <div style="clear:both;width:100%;height:{{ offset }}px">&nbsp;</div>
    {# ALWAYS PRINT FOOTER IN THE END #}
    {{ footer }}

    </body>

{% endblock %}
