
{% if common['isOrder'] %}
<div class="row model-info model-wizard pt-0">
  <div class="col-5 main-step step-header-color" data-step="1" data-target="color">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.v', ['i': 1]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.v.descr2') }}</span>
  </div>
  <div class="col-5 main-step step-header-feature" data-step="2" data-target="feature" style="display:none">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.ft', ['i': 2]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.ft.descr') }}</span>
  </div>
  <div class="col-5 main-step step-header-size" data-step="3" data-target="size" style="display:none">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.s', ['i': 3]) }}</span><br/>
  </div>
  <div class="col-5">
    <span class="step-header font-weight-bold">{{ mt._('model.currentconfiguration') }}</span><br/>
    <span class="step-header" id="current-configuration"></span>
    <input type="hidden" id="current-color"/>
  </div>
  <div class="col-2">
    <a href="#" id="create-anaart" class="font-weight-bold text-capitalize" {# style="display:none" #}>{{ mt._('model.wizard.customize') }}</a>
  </div>
  <div class="col-12">
    <div class="row">
      <div class="col-12" id="selected-color-box">
        <!-- Standard items thumbnails -->
      {% for color in model.colors %}
        <div id="little-{{ color['cdcolo'] }}" class="little-color-box disabled" {{ color.presence < 0 ? 'style="display:none"' : '' }}
          data-id="{{ color['cdcolo'] }}" data-cdcolo="{{ color['cdcolo'] }}" data-cdarti="{{ color['cdarti'] }}">
          {{ elements.getModelImgOrDefault(color['flimag'], color['dscolo'], ['title': (color['dscolo'] != '' ? color['dscolo'] : color['cdcolo']), 'style': 'margin:0' ], false, true) }}
        </div>
      {% endfor %}
      {% if customs|length > 0 %}
        <!-- Custom items thumbnails -->
        {% for custom in customs if custom.presence >= 0 %}
        <div id='little-{{ custom.cdarti }}' class='little-color-box no-img disabled' {{ custom.presence < 0 ? 'style="display:none"' : '' }}
          data-id='{{ custom.cdarti }}' data-cdcolo='{{ custom.cdcolo }}' data-dsarti='{{ mt._("_common.variant") }} {{ custom.dsarti }}'
          data-cdarti='{{ custom.cdarti }}'>
          {{ custom.dsarti }}
        </div>
        {% endfor %}
      {% endif %}
      </div>
    </div>
  </div>
</div>
{% endif %}

<div class="row wizard-selector-box">
  <div class="col-12">
    <div class="box-container" id="color-selector">
      <div class="font-weight-bold title w-100">{{ mt._('model.available.variants') }}</div>
      <div class="row m-0" id="all-variants-container">
        <!-- Standard items -->
        {% for color in model.colors %}
          {% set title = '' %}
          {% set searchable = '' %}
          {% if color.features|length > 0 %}
            {% for feature in color.features %}
              {% set title = title ~ '<b>' ~ feature.tpcomp ~ ':</b> ' ~ feature.valore|escape ~ (not loop.last ? '<br/>' : '') %}
              {% set searchable = searchable ~ feature.valore|escape ~ ' ' %}
            {% endfor %}
          {% else %}
            {% set title = color['dscolo'] != '' ? color['dscolo'] : color['cdcolo'] %}
          {% endif %}
          {% if common['isOrder'] %}
            {% set title = title ~ '<br/><b>' ~ mt._('_common.price')|upper ~ ':</b> ' ~ color['prezzo']|currency ~ ' ' ~ common['currency'] %}
          {% endif %}
        <div class="color-box {{ color.presence < 0 ? '' : 'selected ask-delete' }}"
          data-searchable="{{ searchable|lower }}"
          data-id="{{ color['cdcolo'] }}" data-cdcolo="{{ color['cdcolo'] }}" data-cdarti="{{ color['cdarti'] }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getModelImgOrDefault(color['flimag'], color['dscolo'], ['data-toggle': 'tooltip', 'data-placement': 'top', 'title': title], false, true) }}</div>
          {% set description = color['cdcolo'] != color['dscolo'] and color['dscolo'] != '' ? color['cdcolo'] ~ ' - ' ~ color['dscolo'] : color['cdcolo'] %}
          <div class="description" title="{{ description }}">
            {{ color['hasAvailabilityFlag'] is defined and color['hasAvailabilityFlag'] > 0 ? '<span class="model-code {{ elements.getHighlightClass() }}">': '' }}
            {{ description }}
            {{ color['hasAvailabilityFlag'] is defined and color['hasAvailabilityFlag'] > 0 ? '</span">': '' }}
          </div>
        </div>
        {% endfor %}
        <!-- Custom items -->
        {% for custom in customs if custom.presence >= 0 %}
          {% set title = '' %}
          {% set searchable = '' %}
          {% if custom.features|length > 0 %}
            {% for feature in custom.features %}
              {% set title = title ~ '<b>' ~ feature.tpcomp ~ ':</b> ' ~ feature.valore|escape ~ (not loop.last ? '<br/>' : '') %}
              {% set searchable = searchable ~ feature.valore|escape ~ ' ' %}
            {% endfor %}
          {% endif %}
        <div class="color-box {{ custom.presence < 0 ? '' : 'selected ask-delete' }}"
          data-searchable="{{ searchable|lower }}"
          data-id="{{ custom.cdarti }}" data-cdcolo="{{ custom.cdcolo }}" data-cdarti="{{ custom.cdarti }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getModelImgOrDefault(model.flimag, title, ['data-toggle': 'tooltip', 'data-placement': 'top', 'title': title], false, true) }}</div>
          {#
          <div class="no-img" data-toggle="tooltip" data-placement="top" title="{{ title }}"><div>{{ custom.dsarti }}</div></div>
          #}
          {% set description = mt._("_common.variant") ~ ' ' ~ custom.dsarti %}
          <div class="description" title="{{ description }}">{{ description }}</div>
        </div>
        {% endfor %}
      </div>

      <div id="feature-custom" class="color-features" style="display:none">
        <div class="row m-0">
          <div class="col-12 text-center font-weight-bold">{{ mt._('_common.custom') }}</div>
        </div>
        <div id="custom-form">
          {% for feature in features %}
          <div class="row" style="margin:2px 0">
            <div class="col-3 text-right">{{ feature.dscomp }}</div>
            <div class="col-9 font-weight-bold form-element m-0">
              <input type="text" data-tpcomp="{{ feature.tpcomp }}" data-dscomp="{{ feature.dscomp }}" class="form-control custom-feature">
            </div>
          </div>
          {% endfor %}
        </div>
        <div class="row wizard-tools" style="border:0">
          <div class="col-6 tool-button text-right pr-15x">
            <span id="cancel-custom">{{ mt._('_common.cancel') }}</span>
          </div>
          <div class="col-3 tool-button pl-15x">
            <span id="save-custom">{{ mt._('_common.save') }}</span>
          </div>
          <div class='col-3 msg-success custom-feature-result text-center'>{{ mt._('_common.generic.db.success') }}</div>
          <div class='col-3 msg-error custom-feature-result text-center'>{{ mt._('_common.generic.db.error') }}</div>
        </div>
      </div>

    </div>
    <div class="box-container" id="feature-selector" style="display:none">
      {% for color in model.colors %}
      <div id="feature-{{ color['cdcolo'] }}" class="color-features" style="display:none">
        <div class="row m-0">
          <div class="col-12 text-center font-weight-bold">{{ color['dscolo'] != '' ? color['dscolo'] : color['cdcolo'] }}</div>
        </div>
        {% for feature in color.features %}
        <div class="row m-0">
          <div class="col-3 text-right">{{ feature.dscomp }}</div>
          <div class="col-9 font-weight-bold">{{ feature.valore }}</div>
        </div>
        {% endfor %}
      </div>
      {% endfor %}

      {% for custom in customs %}
      <div id='feature-{{ custom.cdarti }}' class='color-features' style="display:none">
        <div class='row m-0'>
          <div class='col-12 text-center font-weight-bold'>{{ mt._('_common.variant') }} {{ custom.dsarti }}</div>
        </div>
        {% for feature in custom.features %}
        <div class="row m-0">
          <div class="col-3 text-right">{{ feature.dscomp }}</div>
          <div class="col-9 font-weight-bold">{{ feature.valore }}</div>
        </div>
        {% endfor %}
      </div>
      {% endfor %}
    </div>
    <div class="box-container" id="size-selector" style="display:none">
      <div class="font-weight-bold title w-100">{{ mt._('model.size.selector') }}</div>
      <div class="caption w-100">{{ mt._('model.size.caption3') }}</div>
      <div class="row m-0" id="size-content" style="overflow-x:auto">

      </div>
    </div>
  </div>
</div>
