<div class="modal fade" id="modal-new-ticket" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('support.menu.newticket') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }} *</div>
      </div>

      <div class="modal-body">
        <div class="form-group">
          <div class="row mt-3">
            {% if common['ticket_argument'] %}
              <div class="col-md-8">
                <label class="text-capitalize" for="dstitl">{{ mt._('support.header.title') }} *</label>
                <input type="text" class="form-control" id="dstitl" name="dstitl" required />
              </div>
              <div class="col-md-4">
                <label class="text-capitalize" for="cdargo">{{ mt._('support.header.topic') }} *</label>
                <select class="form-control" id="cdargo" name="cdargo" required>
                  <option value="" disabled selected hidden> - </option>
                  {% for topic in topics %}
                    <option value="{{ topic.cdargo }}">{{ mt._(topic.dsargo) }}</option>
                  {% endfor %}
                </select>
              </div>
            {% else %}
              <div class="col-md-12">
                <label class="text-capitalize" for="dstitl">{{ mt._('support.header.title') }} *</label>
                <input type="text" class="form-control" id="dstitl" name="dstitl" required />
                <input type="hidden" id="cdargo" name="cdargo" value="100">
              </div>
            {% endif %}
          </div>
          <div class="row mt-3">
            <div class="col-md-5">
              <label class="text-capitalize" for="numdoc">{{ mt._('_common.order') }} *</label>
              <select class="form-control" id="numdoc" name="numdoc" onchange="updateOrderRows()" required>
                <option value="" disabled selected hidden> - </option>
                {% for order in orders %}
                  <option value="{{ order.numdoc }}">{{ order.desord }}</option>
                {% endfor %}
              </select>
            </div>
            <div class="col-md-7">
              <label class="text-capitalize" for="codart">{{ mt._('_common.article') }}</label>
              <select class="form-control" id="codart" name="codart">
                <option value="" disabled selected hidden> - </option>
              </select>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-md-12">
              <label class="text-capitalize" for="inmail">{{ mt._('_common.email') }}</label>
              <input type="email" class="form-control" id="inmail" name="inmail" />
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-md-12">
              <label class="text-capitalize" for="tkcorp">{{ mt._('_common.description') }} *</label>
              <textarea class="form-control" id="tkcorp" name="tkcorp" rows="5" required></textarea>
            </div>
          </div>
        </div>

        <input type="hidden" id="numdoc_par" name="numdoc_par" value="" />
        <input type="hidden" id="codart_par" name="codart_par" value="" />
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-create-ticket" onclick="createTicket()">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
