<div class="modal fade modal-catalogs" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.catalog') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if catalogs|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-cat">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-cat">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="cat_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-2">{{ mt._('_common.code') }}</div>
              <div class="col-9">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for catalog in catalogs %}
            <div class="row catalog-row pb-10x">
              <div class="col-1">
                <input id="ctl-{{ catalog.cdcata }}" type="checkbox" class="checkbox-custom" name="catalog-checkbox[]"/>
                <label for="ctl-{{ catalog.cdcata }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-2 cdcata">{{ catalog.cdcata }}</div>
              <div class="col-9 dscata">{{ catalog.dscata }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-cat">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-customers" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.customer') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if customers|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-cus">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-cus">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="cus_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-2">{{ mt._('_common.code') }}</div>
              <div class="col-9">{{ mt._('account.customer.businessname') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for customer in customers %}
            <div class="row customer-row pb-10x">
              <div class="col-1">
                <input id="cus-{{ customer.codana }}" type="checkbox" class="checkbox-custom" name="customer-checkbox[]"/>
                <label for="cus-{{ customer.codana }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-2 codana">{{ customer.codana }}</div>
              <div class="col-9 ragsoc">{{ customer.ragsoc }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-cus">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-lines" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.line') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if lines|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-lin">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-lin">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="lin_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for line in lines %}
            <div class="row line-row pb-10x">
              <div class="col-1">
                <input id="lin-{{ line.lineam }}" type="checkbox" class="checkbox-custom" name="line-checkbox[]"/>
                <label for="lin-{{ line.lineam }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 lineam">{{ line.lineam }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-lin">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-countries" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.country') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if countries|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-cou">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-cou">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="cou_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for country in countries %}
            <div class="row country-row pb-10x">
              <div class="col-1">
                <input id="cou-{{ country.nazion }}" type="checkbox" class="checkbox-custom" name="country-checkbox[]"/>
                <label for="cou-{{ country.nazion }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 nazion">{{ country.nazion }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-cou">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

{% if series|length > 0 and series[0] != "" %}
<div class="modal fade modal-series" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.series') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-ser">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-ser">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="ser_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for serie in series %}
            <div class="row serie-row pb-10x">
              <div class="col-1">
                <input id="ser-{{ serie.seriem }}" type="checkbox" class="checkbox-custom" name="serie-checkbox[]"/>
                <label for="ser-{{ serie.seriem }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 seriem">{{ serie.seriem }}</div>
            </div>
        {% endfor %}
          </div>
        </div>

      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-ser">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
{% endif %}

<div class="modal fade modal-zones" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.zone') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if zones|length > 0 %}
        <div class="modal-section">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-zon">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-zon">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="zon_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for zone in zones %}
            <div class="row zone-row pb-10x">
              <div class="col-1">
                <input id="zon-{{ zone.zonage }}" type="checkbox" class="checkbox-custom" name="zone-checkbox[]"/>
                <label for="zon-{{ zone.zonage }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 zonage">{{ zone.zonage }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-zon">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-modeltypes" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.modeltype') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if modeltypes|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-mot">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-mot">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="mot_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for modeltype in modeltypes %}
            <div class="row modeltype-row pb-10x">
              <div class="col-1">
                <input id="ctl-{{ modeltype.tipmod }}" type="checkbox" class="checkbox-custom" name="modeltype-checkbox[]"/>
                <label for="ctl-{{ modeltype.tipmod }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 tipmod">{{ modeltype.tipmod }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-mot">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-ordertypes" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.ordertype') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if ordertypes|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-ort">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-ort">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="ort_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for ordertype in ordertypes %}
            <div class="row ordertype-row pb-10x">
              <div class="col-1">
                <input id="ord-{{ ordertype.tipord }}" type="checkbox" class="checkbox-custom" name="ordertype-checkbox[]"/>
                <label for="ord-{{ ordertype.tipord }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 tipord">{{ ordertype.tipord }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-ort">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-genres" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('statistics.select.genre') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
      {% if genres|length > 0 %}
        <div class="modal-section pb-10x">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-che-all-gen">{{ mt._('_common.all.check') }}</button></div>
              <div class="col-6 col-lg-3"><button type="button" class="btn btn-generic" id="btn-unc-all-gen">{{ mt._('_common.all.uncheck') }}</button></div>
              <div class="col-4 col-lg-2 text-right text-capitalize pt-25x">{{ mt._('_common.search') }}</div>
              <div class="col-8 col-lg-4"><input type="text" id="gen_search_field" class="p-5x mt-18x"/></div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-hdr">
          <div class="container">
            <div class="row">
              <div class="col-1">&nbsp;</div>
              <div class="col-11">{{ mt._('_common.description') }}</div>
            </div>
          </div>
        </div>

        <div class="modal-section mod-cnt">
          <div class="container">
        {% for genre in genres %}
            <div class="row genre-row pb-10x">
              <div class="col-1">
                <input id="gen-{{ genre.genere }}" type="checkbox" class="checkbox-custom" name="genre-checkbox[]"/>
                <label for="gen-{{ genre.genere }}" class="checkbox-custom-label mt-0"></label>
              </div>
              <div class="col-11 genere">{{ genre.genere }}</div>
            </div>
        {% endfor %}
          </div>
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-gen">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
