<div class="modal fade modal-product-details" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="max-width:1000px!important">
    <div class="modal-content preview-model">
      <div class="row mx-0 mb-30x">
        {% set imgurl = "img/model/" ~ model.flimag %}
        <?php $exist_img = $model->flimag != '' && file_exists($imgurl); ?>

        <div class="col-12">
          <div class="modal-close pt-20x" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
          <!-- Nav Tabs -->
          <div class="model-tabs pt-0">
            <ul class="nav nav-tabs nav-justified w-100 ml-0 d-sm-block" role="tablist">
              <li class="nav-item"><a class="active" href="#tab_des" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.classification') }}</a></li>
              <li class="nav-item"><a href="#tab_tec" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.details') }}</a></li>
              {% if showDownloadSection %}<li class="nav-item"><a href="#tab_dwn" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.downloadtechnicalfile') }}</a></li>{% endif %}
            </ul><!-- .nav-tabs -->

            <div class="tab-content account-info">
              <div id="tab_des" role="tabpanel" class="tab-pane fade show active">
                <div class="row">
                  <div class="col-6 model-single-info">{{ mt._('_common.code') }}: {{ model.cdartn }}</div>
                  <div class="col-6 model-single-info">{{ mt._('_common.brand') }}: {{ model.dstitl }}</div>
                  <div class="col-6 model-single-info">{{ mt._('_common.genre') }}: {{ model.dsgene }}</div>
                  <div class="col-6 model-single-info">{{ mt._('_common.line') }}: {{ model.dslinm }}</div>
                  <div class="col-6 model-single-info">{{ mt._('_common.modeltype') }}: {{ model.dstmod }}</div>
                  {% if model.dsserm != '' %}
                  <div class="col-6 model-single-info">{{ mt._('_common.series') }}: {{ model.dsserm }}</div>
                  {% endif %}
                  {% if (modinf != null and modinf.compos != '') or model.descmp != '' %}
                  <div class="col-6 model-single-info">{{ mt._('_common.composition') }}: {{ modinf != null and modinf.compos != '' ? modinf.compos : model.descmp }}</div>
                  {% endif %}
                  {% if (modinf != null and modinf.madein != '') or model.desmad != '' %}
                  <div class="col-6 model-single-info">{{ mt._('_common.madein') }} {{ modinf != null and modinf.madein != '' ? modinf.madein : model.desmad }}</div>
                  {% endif %}
                </div>
              </div>

              <div id="tab_tec" role="tabpanel" class="tab-pane fade">
              {% if common['modelDetailStyle'] == 3 %}
                  {{ tecn_description }}
              {% else %}
                {% if model.destec == "" and
                  (modinf == null or
                  (session.get('language') == 'it' and modinf.dettit == "") or
                  (session.get('language') == 'en' and modinf.detten == "") or
                  (session.get('language') == 'es' and modinf.dettes == "") or
                  (session.get('language') == 'de' and modinf.dettde == "") or
                  (session.get('language') == 'fr' and modinf.dettfr == "")) %}
                  {{ mt._('_common.descr.no') }}
                {% else %}
                  {{ model.destec != "" ? model.destec ~ '<br/>' : '' }}
                  {{ modinf != null and session.get('language') == 'it' ? modinf.dettit : '' }}
                  {{ modinf != null and session.get('language') == 'en' ? modinf.detten : '' }}
                  {{ modinf != null and session.get('language') == 'es' ? modinf.dettes : '' }}
                  {{ modinf != null and session.get('language') == 'de' ? modinf.dettde : '' }}
                  {{ modinf != null and session.get('language') == 'fr' ? modinf.dettfr : '' }}
                {% endif %}
              {% endif %}
              </div>

              <div id="tab_dwn" role="tabpanel" class="tab-pane fade">
              {% set pdfurl = "techfiles/" ~ model.cdartn ~ ".pdf" %}
              <?php $exist = file_exists($pdfurl); ?>
              {% if exist %}
                <a href="{{ pdfurl }}" class="btn btn-generic mr-0 mt-0" style="width:250px">DOWNLOAD</a>
              {% else %}
                {{ mt._('_common.downloadtechnicalfile.no') }}
              {% endif %}
              </div>
            </div><!-- .tab-content -->

          </div>
        </div>
      </div>

    </div>
  </div>
</div>

{% if common['modelDetailStyle'] == 2 or common['modelDetailStyle'] == 4 %}
<div class="modal fade modal-wizard-warning" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.warning') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <input type="hidden" id="warning-action">
        <div class="row mx-0 mb-30x">
          <div class="col-12">{{ mt._('_common.modifyorder.warning2') }}</div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-wizard">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

<div class="modal fade modal-wizard-regqtm" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.warning') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="row mx-0 mb-30x">
          <div class="col-12">{{ mt._('_common.regqtm.warning', ['qtamin': regqtm['qtamin'], 'qtamul': regqtm['qtamul']]) }}</div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

{% if exist_video %}
<div class="modal fade modal-watch-video" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="max-width:1400px!important">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('model.watchvideo') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body p-0">
        <video id="video-model" class="video-js video-wizard" preload="auto" poster="{{ url(imgurl) }}" data-setup="{}" controls style="max-height:calc(100vh - 180px);overflow-y:hidden">
          <source src="{{ url(vidurl) }}" type='video/mp4'>
          <p class="vjs-no-js">
            To view this video please enable JavaScript, and consider upgrading to a web browser that
            <a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
          </p>
        </video>
      </div>

      <div class="modal-footer">
        <div class="row w-100 m-0">
          <div class="col-6 col-lg-4 p-0"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% if common['modelDetailStyle'] == 3 or common['modelDetailStyle'] == 5 %}
<div class="modal fade modal-delete-order-row" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.warning') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="row mx-0 mb-30x">
          <input type="hidden" id="delete-row-cdarti"/>
          <input type="hidden" id="delete-row-iscustom"/>
          <div class="col-12">{{ mt._('model.wizard.warning.deleterow') }}</div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="btn-confirm-delete-row">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% if common['modelDetailStyle'] == 5 %}
<div class="modal fade modal-view-component" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="max-width:80%">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.view') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">

      </div>

      <div class="modal-footer">
        <div class="container w-100" style="max-width:none">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4 p-0"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.cancel') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}
