<div class="modal fade modal-cus-cat" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.analysis.selectcatalog') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section font-weight-bold">
          <div class="row pb-20x">
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-che-all-cus-cat">{{ mt._('_common.all.check') }}</button></div>
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-unc-all-cus-cat">{{ mt._('_common.all.uncheck') }}</button></div>
            <div class="col-md-2 right capitalize bold" style="padding-top:9px">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" style="line-height:28px;padding:0 5px" id="cus_cat_search_field"/></div>
          </div>
          {% if elements['catalogs']|length > 0 %}
          <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
          {% endif %}
        </div>
      {% if elements['catalogs']|length > 0 %}
        <div style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>
        {% for catalog in elements['catalogs'] %}
          <div class="row cus-cat-row" style="line-height:25px">
            <div class="col-md-1">
              <label class="checkbox-cus-cat checkbox-container">
                <input type="checkbox" name="cus-cat-checkbox[]" value="{{ catalog.cdcata }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 dscata">{{ catalog.dscata }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-cus-cat">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-cus-cus" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.analysis.selectcustomer') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section font-weight-bold">
          <div class="row pb-20x">
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-che-all-cus-cus">{{ mt._('_common.all.check') }}</button></div>
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-unc-all-cus-cus">{{ mt._('_common.all.uncheck') }}</button></div>
            <div class="col-md-2 right capitalize bold" style="padding-top:9px">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" style="line-height:28px;padding:0 5px" id="cus_cus_search_field"/></div>
          </div>
          {% if elements['customers']|length > 0 %}
          <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-3">{{ mt._('_common.code') }}</div>
            <div class="col-md-8">{{ mt._('account.customer.businessname') }}</div>
          </div>
          {% endif %}
        </div>
      {% if elements['customers']|length > 0 %}
        <div style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>
        {% for customer in elements['customers'] %}
          <div class="row cus-cus-row" style="line-height:25px">
            <div class="col-md-1">
              <label class="checkbox-cus-cus checkbox-container">
                <input type="checkbox" name="cus-cus-checkbox[]" value="{{ customer.cdanag }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-3 cdanag">{{ customer.cdanag }}</div>
            <div class="col-md-8 descri">{{ customer.descri }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-cus-cus">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-age-cat" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.analysis.selectcatalog') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section font-weight-bold">
          <div class="row pb-20x">
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-che-all-age-cat">{{ mt._('_common.all.check') }}</button></div>
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-unc-all-age-cat">{{ mt._('_common.all.uncheck') }}</button></div>
            <div class="col-md-2 right capitalize bold" style="padding-top:9px">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" style="line-height:28px;padding:0 5px" id="age_cat_search_field"/></div>
          </div>
          {% if elements['catalogs']|length > 0 %}
          <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
          {% endif %}
        </div>
      {% if elements['catalogs']|length > 0 %}
        <div style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>
        {% for catalog in elements['catalogs'] %}
          <div class="row age-cat-row" style="line-height:25px">
            <div class="col-md-1">
              <label class="checkbox-age-cat checkbox-container">
                <input type="checkbox" name="age-cat-checkbox[]" value="{{ catalog.cdcata }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 dscata">{{ catalog.dscata }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-age-cat">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-age-age" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.analysis.selectagent') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section font-weight-bold">
          <div class="row pb-20x">
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-che-all-age-age">{{ mt._('_common.all.check') }}</button></div>
            <div class="col-md-3"><button type="button" class="btn btn-default w-100" id="btn-unc-all-age-age">{{ mt._('_common.all.uncheck') }}</button></div>
            <div class="col-md-2 right capitalize bold" style="padding-top:9px">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" style="line-height:28px;padding:0 5px" id="age_age_search_field"/></div>
          </div>
          {% if elements['agents']|length > 0 %}
          <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
          {% endif %}
        </div>
      {% if elements['agents']|length > 0 %}
        <div style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>
        {% for agent in elements['agents'] %}
          <div class="row age-age-row" style="line-height:25px">
            <div class="col-md-1">
              <label class="checkbox-age-age checkbox-container">
                <input type="checkbox" name="age-age-checkbox[]" value="{{ agent.cdagen }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 dsagen">{{ agent.dsagen }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-age-age">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal fade modal-age" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="age">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.agent') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['agents']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all" data-type="age">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all" data-type="age">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field" data-type="age"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['agents'] %}
          <div class="row age-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="age-box[]" value="{{ el.cdagen }}" />
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dsagen }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="btn-confirm-age">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-brn" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="brn">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.brand') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['brands']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['brands'] %}
          <div class="row brn-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="brn-box[]" value="{{ el.cdtitl }}" />
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.cdtitl }} - {{ el.dstitl }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-cat" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="cat">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.catalog') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['catalogs']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-2">{{ mt._('_common.code') }}</div>
            <div class="col-md-9">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['catalogs'] %}
          <div class="row cat-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="cat-box[]" value="{{ el.cdcata }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-2 descri" style="line-height:20px;padding-top:3px">{{ el.cdcata }}</div>
            <div class="col-md-9 descri" style="line-height:20px;padding-top:3px">{{ el.dscata }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-cus" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="cus">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.customer') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['customers']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-2">{{ mt._('_common.code') }}</div>
            <div class="col-md-9">{{ mt._('account.customer.businessname') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['customers'] %}
          <div class="row cus-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="cus-box[]" data-tpanag="{{ el.tpanag }}" data-cdanag="{{ el.cdanag }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-2 descri" style="line-height:20px;padding-top:3px">{{ el.cdanag }}</div>
            <div class="col-md-9 descri" style="line-height:20px;padding-top:3px">{{ el.descri }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-lin" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="lin">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.line') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['lines']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['lines'] %}
          <div class="row lin-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="lin-box[]" value="{{ el.cdlinm }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dstitl }} - {{ el.dslinm }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-cou" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="cou">>
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.country') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['countries']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['countries'] %}
          <div class="row cou-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="cou-box[]" value="{{ el.cdnazi }}" />
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dsnazi }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

{% if elements['series']|length > 1 and elements['series'][0] != "" %}
<div class="modal fade modal-ser" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="ser">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.series') }}</h4>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['series'] %}
          <div class="row ser-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="ser-box[]" data-cdlinm="{{ el.cdlinm }}" data-cdserm="{{ el.cdserm }}" />
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dstitl }} - {{ el.dslinm }} - {{ el.dsserm }}</div>
          </div>
        {% endfor %}
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

<div class="modal fade modal-mot" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="mot">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.modeltype') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['modeltypes']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['modeltypes'] %}
          <div class="row mot-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="mot-box[]" value="{{ el.tpmode }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dstmod }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-ort" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="ort">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.ordertype') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['ordertypes']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['ordertypes'] %}
          <div class="row ort-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-0">
                <input type="checkbox" name="ort-box[]" value="{{ el['code'] }}" />
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el['value'] }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-gen" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="gen">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.select.genre') }}</h4>
      </div>
      <div class="modal-body">
      {% if elements['genres']|length > 0 %}
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-check-all">{{ mt._('_common.all.check') }}</button>
            </div>
            <div class="col-md-3">
              <button type="button" class="btn btn-default btn-uncheck-all">{{ mt._('_common.all.uncheck') }}</button>
            </div>
            <div class="col-md-2 right pt-8x capitalize">{{ mt._('_common.search') }}</div>
            <div class="col-md-4"><input type="text" class="p-5x search-field"/></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="row mt-10x">
            <div class="col-md-1"></div>
            <div class="col-md-11">{{ mt._('_common.description') }}</div>
          </div>
        </div>
        <div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">
        {% for el in elements['genres'] %}
          <div class="row gen-row pb-10x">
            <div class="col-md-1">
              <label class="checkbox-container mb-10x">
                <input type="checkbox" name="gen-box[]" value="{{ el.tpgene }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-11 descri" style="line-height:20px;padding-top:3px">{{ el.dsgene }}</div>
          </div>
        {% endfor %}
        </div>
      {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" data-dismiss="modal">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-info" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" >{{ mt._('statistics.info') }}</h4>
      </div>
      <div class="modal-body">
        <div class="modal-section" id="info_modal">

        </div>
      </div>
    </div>
  </div>
</div>

{% if enableSpecialStats %}
{{ elements.printModalWindowForSaleAnalysis('sps-ctg', mt._('admin.analysis.select.catalog'), spsCatalogs) }}
{{ elements.printModalWindowForSaleAnalysis('sps-ssn', mt._('admin.analysis.select.season'), spsSeasons) }}
{{ elements.printModalWindowForSaleAnalysis('sps-chn', mt._('admin.analysis.select.channel'), spsChannels) }}
{{ elements.printModalWindowForSaleAnalysis('sps-drp', mt._('admin.analysis.select.drop'), spsDrops) }}
{{ elements.printModalWindowForSaleAnalysis('sps-brn', mt._('admin.analysis.select.brand'), spsBrands) }}
{{ elements.printModalWindowForSaleAnalysis('sps-lin', mt._('admin.analysis.select.line'), spsLines) }}
{{ elements.printModalWindowForSaleAnalysis('sps-ser', mt._('admin.analysis.select.series'), spsSeries, true) }}
{{ elements.printModalWindowForSaleAnalysis('sps-mty', mt._('admin.analysis.select.modeltype'), spsModelTypes) }}
{% endif %}
