{% set neededByModel = router.getControllerName() == "model" and
  router.getActionName() != "fullscreen" and
  router.getActionName() != "fullscreenvar" and
  router.getActionName() != "img360"
%}

{% if (router.getControllerName() in ["account", "cart", "catalog", "info"]) and neededByModel and
  (common['isOrder'] and common['hideDeliveryDate'] != 1 and
    (
      (common['order_info'].dtmcli is null and
        (
          (common['order_info'].tpordc == 0 and (common['dateTypeAvaOrder'] == 0 or common['dateTypeAvaOrder'] == 2)) or
          (common['order_info'].tpordc == 1 and (common['dateTypeResOrder'] == 0 or common['dateTypeResOrder'] == 2))
        )
      ) or
      (common['order_info'].tpordc == 1 and (common['dateTypeResOrder'] == 4 and (common['order_info'].dtmcoi is null or common['order_info'].dtmcof is null)))
    )
  )
%}
{% include "modal/dtmcli_error.volt" %}
{% endif %}

{% if router.getControllerName() != "model" or (
  router.getActionName() != "fullscreen" and
  router.getActionName() != "fullscreenvar" and
  router.getActionName() != "img360") %}
  {% if not common['isOrder'] %}
  {% include "modal/new_order.volt" %}
  {% else %}
  {% include "modal/barcode.volt" %}
  {% endif %}
{% endif %}

{% if router.getControllerName() == "account" and router.getActionName() == 'info' %}
  {% include "modal/xls_order.volt" %}
  {% include "modal/support_new_ticket.volt" %}
{% elseif router.getControllerName() == "cart" and router.getActionName() == 'index' %}
  {% include "modal/cart_index.volt" %}
{% elseif router.getControllerName() == "catalog" %}
  {% if router.getActionName() in ['list', 'resultslist'] %}
    {% include "modal/catalog_list.volt" %}
  {% endif %}
  {% if (router.getActionName() == 'collection' or router.getActionName() == 'tag') and (common['modelDetailStyle'] == 2 or common['modelDetailStyle'] == 4) %}
    {% include "modal/catalog_modelpreview.volt" %}
  {% elseif (router.getActionName() in ['collection', 'results', 'sales', 'tag']) and
    common['isOrder'] and (common['modelDetailStyle'] in [1, 6, 7, 8, 9]) and common['catalogProductType'] == 0 %}
    {% include "modal/model_fastbuy.volt" %}
  {% endif %}
{% elseif router.getControllerName() == "model" %}
  {% if router.getActionName() == 'wizard' %}
    {% include "modal/model_wizard.volt" %}
  {% endif %}
  {% if common['isOrder'] and router.getActionName() != 'fullscreen' and router.getActionName() != 'fullscreenvar' and router.getActionName() != 'img360' %}
    {% if common['order_info'].tpordc == 0 and isDefault %}
      {% include "modal/model_notifyproduct.volt" %}
    {% endif %}
    {% if (common['modelDetailStyle'] in [1, 6, 7, 8, 9]) and common['catalogProductType'] == 0 %}
      {% include "modal/model_fastbuy.volt" %}
    {% endif %}
  {% endif %}
{% elseif router.getControllerName() == "statistics" %}
  {% if router.getActionName() == 'index' %}
    {% include "modal/statistics_index.volt" %}
  {% elseif router.getActionName() == 'detail' %}
    {% include "modal/statistics_detail.volt" %}
  {% endif %}
{% elseif router.getControllerName() == "support" %}
  {% if router.getActionName() == 'list' %}
    {% include "modal/support_new_ticket.volt" %}
  {% elseif router.getActionName() == 'chat' %}
    {% include "modal/support_close_ticket.volt" %}
  {% endif %}
{% endif %}
