{%- macro classificationLevel(list, lang, level = 0, disabled = false, selectedEl = null) %}
    {% set isBaseReadonly = router.getActionName() == 'classification' %}

    {% if list is defined and list is not empty %}
        <ul class="flt-b2bcla" data-level="{{ level }}">
    {% endif %}

    {% for _el in list if _el['element'].enabled == 1 %}
        {% set isReadonly = isBaseReadonly %}

        {# Presente nei filtri (checkato) #}
        {% set isChecked = selectedEl is not empty and _el['element'] is defined and (_el['element'].id in selectedEl) %}
        {% set isDisabled = disabled or not _el['element'].enabled %}
{#        Non si puo' fare da qui dobbiamo farlo con js a limite #}
{#        {% if not(isChecked) and (isReadonly and (_el['element'].parent_id in selectedEl)) %}#}
{#            {%  set isReadonly = false %}#}
{#        {% endif %}#}
        {% set labelEl = _el['element'].getLabel(lang) %}
        <li class="{{ isDisabled ? 'disabled' : '' }}" data-search="{{ _el['element'].slug|escape_attr|lower }} {{ labelEl|escape_attr|lower }}">
            <div>
                <input type="checkbox" id="b2bcla-{{ _el['element'].slug|escape_attr }}" {{ isReadonly ? 'readonly' : '' }}
                       class="flt-b2bcla checkbox-custom" {{ isDisabled ? 'disabled' : '' }} {{ (isChecked ? 'checked' : '') }}
                       data-id="{{ _el['element'].id|escape_attr }}" data-slug="{{ _el['element'].slug|escape_attr }}"
                       value="{{ _el['element'].id|escape_attr }}" />
                <label for="b2bcla-{{ _el['element'].slug|escape_attr }}" class="checkbox-custom-label" title="{{ _el['element'].slug|escape_attr }} - {{ labelEl|escape_attr }}">
                    {{ labelEl }}
                </label>
            </div>

            {% if _el['sub'] is defined and _el['sub'] is not empty %}
                {{ classificationLevel(_el['sub'], lang, level + 1, isDisabled, selectedEl) }}
            {% endif %}
        </li>

        {% if not loop.last and _el['element'].isRoot() %}
            <li role="separator" class="divider"></li>
        {% endif %}
    {% endfor %}

    {% if list is not empty %}
        </ul>
    {% endif %}
{%- endmacro -%}

<div id="filter-slider" class="ext-slider">
    <div class="row mb-40x">
        <div class="col-8 title-slider-rgt">{{ mt._('_common.filters') }}</div>
        <div class="col-4 slider-exit-rgt"><span
                    class="slider-exit">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</span>
        </div>
    </div>

    <div class="col-12 text-slider-rgt pl-20x mb-20x">
        <a class="slider-exit" id="reset-all-filters" href="#"
           style="text-decoration:none">{{ mt._('_common.filter.reset') }}</a>
    </div>

    <div id="all-filters-container">

        {% set structureFilterAvailable = router.getActionName() != 'fabric' and (
            (current['type'] == 'linmod' and (filters['sermod']|length > 1 or (filters['sermod']|length > 0 and filters['sermod'][0].cdserm != ''))) or
            (current['type'] == 'titlin' and (filters['linmod']|length > 1 or (filters['linmod']|length > 0 and filters['linmod'][0].cdlinm != ''))) or
            (current['type'] == 'all'    and (filters['titlin']|length > 1 or (filters['titlin']|length > 0 and filters['titlin'][0].cdtitl != '')))
            ) and common['paramStructFilter'] %}

        {% if structureFilterAvailable %}
            <div class="filter-container" data-index="-1" data-name="structure">
                <div class="row flt-header" data-target="flt-structure">
                    <div class="col-2 flt-selector">
                        <div class='opener'></div>
                    </div>
                    <div class="col-6 flt-selector">{{ mt._(common['modelDetailStyle'] != 3 ? '_common.filter.structure' : '_common.line') }}</div>
                    <div class="col-4">{{ image("assets/img/times.png", "class": "remove-flt", "id": "remove-flt-structure", "alt": mt._(common['modelDetailStyle'] != 3 ? '_common.filter.structure' : '_common.line')) }}</div>
                </div>
                <div class="row flt-content" id="flt-structure">

                    <div class="col-12">
                        {% if current['type'] == 'linmod' %}
                            <ul class="flt-sermod">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% set index = 0 %}
                                {% for series in filters['sermod'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                        {% for sermod in apply['sermod']['filter'] %}
                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                {% set ischecked = "checked" %}
                                            {% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox"
                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                   data-cdlinm="{{ series.cdlinm }}"
                                                   data-cdserm="{{ series.cdserm }}"
                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                            {% set index = index + 1 %}
                                        </div>
                                    </li>
                                {% endfor %}
                            </ul>
                        {% elseif current['type'] == 'titlin' %}
                            <ul class="flt-linmod">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% for line in filters['linmod'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['linmod'] is defined and apply['linmod']['filter'] is defined %}
                                        {% for cdlinm in apply['linmod']['filter'] %}
                                            {% if cdlinm == line.cdlinm %}{% set ischecked = "checked" %}{% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox" id="linm-{{ line.cdlinm }}"
                                                   data-cdlinm="{{ line.cdlinm }}"
                                                   class="flt-cdlinm checkbox-custom" {{ ischecked }}/>
                                            <label for="linm-{{ line.cdlinm }}"
                                                   class="checkbox-custom-label">{{ line.dslinm }}</label>
                                        </div>
                                        {% if line.sermod|length > 1 or (line.sermod|length > 0 and line.sermod[0].cdserm != '') %}
                                            <ul class="flt-sermod">
                                                {% for series in line.sermod %}
                                                    {% set ischecked = "" %}
                                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                                        {% for sermod in apply['sermod']['filter'] %}
                                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                                {% set ischecked = "checked" %}
                                                            {% endif %}
                                                        {% endfor %}
                                                    {% endif %}
                                                    <li>
                                                        <div>
                                                            <input type="checkbox"
                                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                   data-cdlinm="{{ series.cdlinm }}"
                                                                   data-cdserm="{{ series.cdserm }}"
                                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                                        </div>
                                                    </li>
                                                {% endfor %}
                                            </ul>
                                        {% endif %}
                                    </li>
                                {% endfor %}
                            </ul>
                        {% elseif current['type'] == 'all' %}
                            <ul class="flt-titlin">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% for brand in filters['titlin'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['titlin'] is defined and apply['titlin']['filter'] is defined %}
                                        {% for cdtitl in apply['titlin']['filter'] %}
                                            {% if cdtitl == brand.cdtitl %}{% set ischecked = "checked" %}{% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox" id="titl-{{ brand.cdtitl }}"
                                                   data-cdtitl="{{ brand.cdtitl }}"
                                                   class="flt-cdtitl checkbox-custom" {{ ischecked }}/>
                                            <label for="titl-{{ brand.cdtitl }}"
                                                   class="checkbox-custom-label">{{ brand.dstitl }}</label>
                                        </div>
                                        {% if brand.linmod|length > 1 or (brand.linmod|length > 0 and brand.linmod[0].cdlinm != '') %}
                                            <ul class="flt-linmod">
                                                {% for line in brand.linmod %}
                                                    {% set ischecked = "" %}
                                                    {% if apply['linmod'] is defined and apply['linmod']['filter'] is defined %}
                                                        {% for cdlinm in apply['linmod']['filter'] %}
                                                            {% if cdlinm == line.cdlinm %}{% set ischecked = "checked" %}{% endif %}
                                                        {% endfor %}
                                                    {% endif %}
                                                    <li>
                                                        <div>
                                                            <input type="checkbox" id="linm-{{ line.cdlinm }}"
                                                                   data-cdlinm="{{ line.cdlinm }}"
                                                                   class="flt-cdlinm checkbox-custom" {{ ischecked }}/>
                                                            <label for="linm-{{ line.cdlinm }}"
                                                                   class="checkbox-custom-label">{{ line.dslinm }}</label>
                                                        </div>
                                                        {% if line.sermod|length > 1 or (line.sermod|length > 0 and line.sermod[0].cdserm != '') %}
                                                            <ul class="flt-sermod">
                                                                {% for series in line.sermod %}
                                                                    {% set ischecked = "" %}
                                                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                                                        {% for sermod in apply['sermod']['filter'] %}
                                                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                                                {% set ischecked = "checked" %}
                                                                            {% endif %}
                                                                        {% endfor %}
                                                                    {% endif %}
                                                                    <li>
                                                                        <div>
                                                                            <input type="checkbox"
                                                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                                   data-cdlinm="{{ series.cdlinm }}"
                                                                                   data-cdserm="{{ series.cdserm }}"
                                                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                                                        </div>
                                                                    </li>
                                                                {% endfor %}
                                                            </ul>
                                                        {% endif %}
                                                    </li>
                                                {% endfor %}
                                            </ul>
                                        {% endif %}
                                    </li>
                                {% endfor %}
                            </ul>
                        {% endif %}
                    </div>
                </div>
            </div>
        {% endif %}

        {% set classificationsFilterAvailable = router.getActionName() != 'fabric' and (router.getActionName() == 'classification' or common['paramClassificationFilter'])%}

        {% if classificationsFilterAvailable %}
            {% set lang = session.get('language') %}
            <div class="filter-container" data-index="-1" data-name="b2bcla">
                <div class="row flt-header" data-target="flt-b2bcla">
                    <div class="col-2 flt-selector">
                        <div class='opener'></div>
                    </div>
                    <div class="col-6 flt-selector">{{ mt._('_common.classifications') }}</div>
                    <div class="col-4">{{ image("assets/img/times.png", "class": "remove-flt", "id": "remove-flt-structure", "alt": mt._('_common.classifications')) }}</div>
                </div>
                <div class="row flt-content" id="flt-b2bcla">

                    <div class="col-12">
                        <div class="mx-2">
                            <input type="search" id="flt-b2bcla-text" class="form-control form-control-sm" />
                        </div>
                        {% if apply['b2bcla'] is defined and apply['b2bcla']['filter'] is not empty %}
                            {{ classificationLevel(common['classifications'], lang, 0, false, apply['b2bcla']['filter']) }}
                        {% else %}
                            {{ classificationLevel(common['classifications'], lang) }}
                        {% endif %}
                    </div>

                    {#<div class="col-12">
                        {% if current['type'] == 'linmod' %}
                            <ul class="flt-sermod">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% set index = 0 %}
                                {% for series in filters['sermod'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                        {% for sermod in apply['sermod']['filter'] %}
                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                {% set ischecked = "checked" %}
                                            {% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox"
                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                   data-cdlinm="{{ series.cdlinm }}"
                                                   data-cdserm="{{ series.cdserm }}"
                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                            {% set index = index + 1 %}
                                        </div>
                                    </li>
                                {% endfor %}
                            </ul>
                        {% elseif current['type'] == 'titlin' %}
                            <ul class="flt-linmod">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% for line in filters['linmod'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['linmod'] is defined and apply['linmod']['filter'] is defined %}
                                        {% for cdlinm in apply['linmod']['filter'] %}
                                            {% if cdlinm == line.cdlinm %}{% set ischecked = "checked" %}{% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox" id="linm-{{ line.cdlinm }}"
                                                   data-cdlinm="{{ line.cdlinm }}"
                                                   class="flt-cdlinm checkbox-custom" {{ ischecked }}/>
                                            <label for="linm-{{ line.cdlinm }}"
                                                   class="checkbox-custom-label">{{ line.dslinm }}</label>
                                        </div>
                                        {% if line.sermod|length > 1 or (line.sermod|length > 0 and line.sermod[0].cdserm != '') %}
                                            <ul class="flt-sermod">
                                                {% for series in line.sermod %}
                                                    {% set ischecked = "" %}
                                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                                        {% for sermod in apply['sermod']['filter'] %}
                                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                                {% set ischecked = "checked" %}
                                                            {% endif %}
                                                        {% endfor %}
                                                    {% endif %}
                                                    <li>
                                                        <div>
                                                            <input type="checkbox"
                                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                   data-cdlinm="{{ series.cdlinm }}"
                                                                   data-cdserm="{{ series.cdserm }}"
                                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                                        </div>
                                                    </li>
                                                {% endfor %}
                                            </ul>
                                        {% endif %}
                                    </li>
                                {% endfor %}
                            </ul>
                        {% elseif current['type'] == 'all' %}
                            <ul class="flt-titlin">
                                <li><input type="text" id="flt-structure-text"/></li>
                                {% for brand in filters['titlin'] %}
                                    {% set ischecked = "" %}
                                    {% if apply['titlin'] is defined and apply['titlin']['filter'] is defined %}
                                        {% for cdtitl in apply['titlin']['filter'] %}
                                            {% if cdtitl == brand.cdtitl %}{% set ischecked = "checked" %}{% endif %}
                                        {% endfor %}
                                    {% endif %}
                                    <li>
                                        <div>
                                            <input type="checkbox" id="titl-{{ brand.cdtitl }}"
                                                   data-cdtitl="{{ brand.cdtitl }}"
                                                   class="flt-cdtitl checkbox-custom" {{ ischecked }}/>
                                            <label for="titl-{{ brand.cdtitl }}"
                                                   class="checkbox-custom-label">{{ brand.dstitl }}</label>
                                        </div>
                                        {% if brand.linmod|length > 1 or (brand.linmod|length > 0 and brand.linmod[0].cdlinm != '') %}
                                            <ul class="flt-linmod">
                                                {% for line in brand.linmod %}
                                                    {% set ischecked = "" %}
                                                    {% if apply['linmod'] is defined and apply['linmod']['filter'] is defined %}
                                                        {% for cdlinm in apply['linmod']['filter'] %}
                                                            {% if cdlinm == line.cdlinm %}{% set ischecked = "checked" %}{% endif %}
                                                        {% endfor %}
                                                    {% endif %}
                                                    <li>
                                                        <div>
                                                            <input type="checkbox" id="linm-{{ line.cdlinm }}"
                                                                   data-cdlinm="{{ line.cdlinm }}"
                                                                   class="flt-cdlinm checkbox-custom" {{ ischecked }}/>
                                                            <label for="linm-{{ line.cdlinm }}"
                                                                   class="checkbox-custom-label">{{ line.dslinm }}</label>
                                                        </div>
                                                        {% if line.sermod|length > 1 or (line.sermod|length > 0 and line.sermod[0].cdserm != '') %}
                                                            <ul class="flt-sermod">
                                                                {% for series in line.sermod %}
                                                                    {% set ischecked = "" %}
                                                                    {% if apply['sermod'] is defined and apply['sermod']['filter'] is defined %}
                                                                        {% for sermod in apply['sermod']['filter'] %}
                                                                            {% if sermod[0] == series.cdlinm and sermod[1] == series.cdserm %}
                                                                                {% set ischecked = "checked" %}
                                                                            {% endif %}
                                                                        {% endfor %}
                                                                    {% endif %}
                                                                    <li>
                                                                        <div>
                                                                            <input type="checkbox"
                                                                                   id="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                                   data-cdlinm="{{ series.cdlinm }}"
                                                                                   data-cdserm="{{ series.cdserm }}"
                                                                                   class="flt-cdserm checkbox-custom" {{ ischecked }}/>
                                                                            <label for="linmserm-{{ series.cdlinm }}-{{ series.cdserm }}"
                                                                                   class="checkbox-custom-label">{{ series.dsserm }}</label>
                                                                        </div>
                                                                    </li>
                                                                {% endfor %}
                                                            </ul>
                                                        {% endif %}
                                                    </li>
                                                {% endfor %}
                                            </ul>
                                        {% endif %}
                                    </li>
                                {% endfor %}
                            </ul>
                        {% endif %}
                    </div>#}
                </div>
            </div>
        {% endif %}

        {% if common['paramBrandsFilter'] %}
            <div class="filter-container" data-index="-1" data-name="brands">
                <div class="row flt-header" data-target="flt-brands">
                    <div class="col-2 flt-selector">
                        <div class='opener' style="background-position: -26px center;"></div>
                    </div>
                    <div class="col-6 flt-selector">{{ mt._('_common.brands') }}</div>
                </div>
                <div class="row flt-content" id="flt-brands" style="display:block;font-size:15px;">

                    <div class="col-12">
                        {% if current['type'] == 'all' %}
                            {% for brand in filters['titlin'] %}
                                {% if brand.linmod|length > 1 or (brand.linmod|length > 0 and brand.linmod[0].cdlinm != '') %}
                                    <ul class="flt-linmod" style="line-height:1.5;">
                                        {% for line in brand.linmod %}
                                            <li>
                                                <div>
                                                    <a href="/catalog/setFilterFromHomepage/LI/{{ line.cdlinm }}"
                                                       class="checkbox-custom-label"
                                                       style="text-decoration:none;">{{ line.dslinm }}</a>
                                                </div>
                                            </li>
                                        {% endfor %}
                                    </ul>
                                {% endif %}
                            {% endfor %}
                        {% endif %}
                    </div>
                </div>
            </div>
        {% endif %}

        {% for key, currentFilter in filters %}
            {% if key not in ['sermod', 'linmod', 'titlin'] and
                currentFilter['hidden'] is defined and currentFilter['hidden'] == 0 and
                ((currentFilter['custom'] is defined and currentFilter['custom']|length > 0) or (currentFilter['default'] is defined and currentFilter['default']|length > 0)) and
                (router.getActionName() != 'fabric' or currentFilter['name'] not in ['dscolo', 'cdpers', 'taglia', 'prezzo']) and
                (router.getActionName() != 'fabricDetail' or currentFilter['name'] != 'cdpers') %}
                <!-- {{ currentFilter['name'] }} filter -->
                <div class="filter-container" data-index="{{ currentFilter['index'] }}"
                     data-name="{{ currentFilter['name'] }}" data-context="{{ currentFilter['context'] }}"
                     data-type="{{ currentFilter['type'] }}"
                     data-custom="{{ currentFilter['custom'] is defined and currentFilter['custom']|length > 0 ? 1 : 0 }}">
                    <div class="row flt-header" data-target="flt-{{ currentFilter['name'] }}">
                        <div class="col-2 flt-selector">
                            <div class='opener'></div>
                        </div>
                        <div class="col-6 flt-selector">{{ currentFilter['description'] }}</div>
                    </div>
                    <div class="row flt-content" id="flt-{{ currentFilter['name'] }}">
                        <div class="col-12">
                            {% if currentFilter['name'] == 'prezzo' %}
                                <div class="col-2 h30 float-left" style="padding-top:3px"><label for="pric-min">Min
                                        ({{ common['currency'] }})</label></div>
                                <div class="col-10 h30 float-left">
                                    {% set minValue = apply["prezzo"] is defined and apply["prezzo"]["filter"] is defined and apply["prezzo"]["filter"]["min"] is defined and apply["prezzo"]["filter"]["min"] > -1 ? apply["prezzo"]["filter"]["min"] : '' %}
                                    <input type="number" class="flt-price" name="pric-min" id='pric-min' min='0'
                                           step='.01' value='{{ minValue }}'>
                                </div>
                                <div class="col-2 h30 float-left" style="padding-top:3px"><label for="pric-max">Max
                                        ({{ common['currency'] }})</label></div>
                                <div class="col-10 h30 float-left">
                                    {% set maxValue = apply["prezzo"] is defined and apply["prezzo"]["filter"] is defined and apply["prezzo"]["filter"]["max"] is defined and apply["prezzo"]["filter"]["max"] > -1 ? apply["prezzo"]["filter"]["max"] : '' %}
                                    <input type="number" class="flt-price" name="pric-max" id='pric-max' min='0'
                                           step='.01' value='{{ maxValue }}'>
                                </div>
                            {% else %}
                                <ul>
                                    {% if currentFilter['type'] == 0 and currentFilter['custom']|length > 0 %}
                                        {% for el in currentFilter['custom'] %}{{ elements.getFilterLi(el, apply[currentFilter['name']] is defined ? apply[currentFilter['name']] : [], true) }}{% endfor %}
                                    {% else %}
                                        {% for el in currentFilter['default'] %}{{ elements.getFilterLi(el, apply[currentFilter['name']] is defined ? apply[currentFilter['name']] : []) }}{% endfor %}
                                    {% endif %}
                                </ul>
                            {% endif %}
                        </div>
                    </div>
                </div>
            {% endif %}
        {% endfor %}
    </div>

</div>
