{% if router.getControllerName() != "pdf" %}
  <!-- jQuery UI -->
  {{ stylesheet_link("vendors/jquery-ui-1.12.1.custom/jquery-ui.min.css") }}
  <!-- FontAwesome -->
  {{ stylesheet_link("vendors/font-awesome/css/font-awesome.min.css") }}
  <!-- Material Icons -->
  {{ stylesheet_link("css/material-icons.min.css") }}
{% endif %}

  <!-- BootStrap -->
{% if (router.getControllerName() in ["admin", "gomanagement"]) or (router.getControllerName() == "support" and (router.getActionName() == "listAdmin" or  router.getActionName() == "chatAdmin")) %}
  {{ stylesheet_link("vendors/bootstrap/dist/css/bootstrap.min.css") }}
{% else %}
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/css/bootstrap.min.css" integrity="sha384-9gVQ4dYFwwWSjIDZnLEWnxCjeSWFphJiwGPXr1jddIhOegiu1FwO5qRGvFXOdJZ4" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/css/bootstrap-select.min.css">
{% endif %}

<!-- AlpineJS -->
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.9/dist/cdn.min.js"></script>

{% if router.getRewriteUri() == "/session/start" or router.getRewriteUri() == "/admin/agents" or
  (router.getRewriteUri() == "/" and session.get('auth')['role'] == 'Admin') %}

  <!-- DataTable -->
  {{ stylesheet_link("vendors/datatables.net-bs/css/dataTables.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css") }}

  <!-- Latest compiled and minified CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/css/bootstrap-select.min.css">

{% elseif router.getControllerName() == "admin" %}

  {% if router.getActionName() in ["admin", "users", "analysis", "blockedItems", "checkPrices",
    "customdiscountlist", "customers", "customfamily", "customflt",
    "customgroup", "customvar", "customVariants", "customVariantsSpecial",
    "editCustomDiscount", "filterVisibility", "linkcatalogs", "newCustomers",
    "orders", "productinfo", "quantityrules", "shippings", "specialSelections", 'classifications'] %}
  <!-- DataTable -->
  {{ stylesheet_link("vendors/datatables.net-bs/css/dataTables.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css") }}
  {% endif %}

  {% if router.getActionName() == "analysis" %}
  <!-- JQVMap -->
  {{ stylesheet_link("vendors/jqvmap/dist/jqvmap.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["bannereditor", "noteseditor", "shipmentnoteseditor", "categoryBanner", "modifyModelInfo"] %}
  <!-- jQuery TE -->
  {{ stylesheet_link("css/jquery-te-1.4.0.css") }}
  {% endif %}

  {% if router.getActionName() in ["analysis", "checkPrices", "coupon", "dashboard",
    "defaultConditions", "editCustomDiscount", "modifyModelInfo", "orders"] %}
  {{ stylesheet_link("vendors/bootstrap-daterangepicker/daterangepicker.css") }}
  {% endif %}

  {% if router.getActionName() == "coupon" %}
  <!-- Bootstrap Multiselect -->
  {{ stylesheet_link("css/bootstrap-multiselect.css") }}
  {% endif %}

  {% if router.getActionName() in ["catalogspage", "categoryBanner",
    "featured", "galleries", "lookbookManager", "params", "settings",
    "specialSelectionDetail"] %}
  {{ stylesheet_link("vendors/dropzone/dist/min/dropzone.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["customflt", "colorpicker"] %}
  {{ stylesheet_link("vendors/mjolnic-bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["budget", "editCustomDiscount",
    "gallery", "orders", "quantityrules", "specialSelectionDetail"] %}
  <!-- Latest compiled and minified CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/css/bootstrap-select.min.css">
  {% endif %}

{% elseif router.getControllerName() == "gomanagement" %}

  {% if router.getActionName() in ["agentsList", "availability", "brands",
    "catalogDetail", "catalogManager", "conditions", "devices", "expirations",
    "lines", "lookbookManager", "promo", "series", "sizes"] %}
  <!-- DataTable -->
  {{ stylesheet_link("vendors/datatables.net-bs/css/dataTables.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css") }}
  {{ stylesheet_link("vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["catalogDetail", "createCatalog", "editPromo"] %}
  {{ stylesheet_link("vendors/bootstrap-daterangepicker/daterangepicker.css") }}
  {% endif %}

  {% if router.getActionName() in ["catalogDetail", "editLookbook",
    "lookbookManager"] %}
  {{ stylesheet_link("vendors/dropzone/dist/min/dropzone.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["catalogDetail", "createCatalog"] %}
  <!-- BootStrapTable -->
  {{ stylesheet_link("https://cdnjs.cloudflare.com/ajax/libs/bootstrap-table/1.10.0/bootstrap-table.min.css") }}
  {{ stylesheet_link("https://rawgit.com/vitalets/x-editable/master/dist/bootstrap3-editable/css/bootstrap-editable.css") }}
  {% endif %}

  {% if router.getActionName() in ["catalogDetail", "conditions",
    "createCatalog", "editLookbook", "expirations"] %}
  <!-- Select2 -->
  {{ stylesheet_link("vendors/select2/dist/css/select2.min.css") }}
  {% endif %}

  {% if router.getActionName() in ["availability"] %}
  <!-- Latest compiled and minified CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/css/bootstrap-select.min.css">
  {% endif %}

{% elseif router.getControllerName() == "pdf" %}
  <!-- Pdf -->
  <link href='../css/pdf.min.css' rel='stylesheet' type='text/css' />
{% elseif router.getControllerName() == "model" %}
  {{ stylesheet_link("css/superslides.css") }}
  {{ stylesheet_link("css/flickity.css") }}
  {{ stylesheet_link("https://vjs.zencdn.net/6.4.0/video-js.css", false) }}
{% elseif router.getControllerName() == "support" %}
  {% if router.getActionName() == "listAdmin" %}
    <!-- DataTable -->
    {{ stylesheet_link("vendors/datatables.net-bs/css/dataTables.bootstrap.min.css") }}
    {{ stylesheet_link("vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css") }}
    {{ stylesheet_link("vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css") }}
    {{ stylesheet_link("vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css") }}
    {{ stylesheet_link("vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css") }}
  {% endif %}
{% endif %}

{% if router.getControllerName() in ["account", "cart", "catalog", "info", "model", "statistics", "support"] %}
<!-- DateRangePicker -->
{{ stylesheet_link("vendors/bootstrap-daterangepicker/daterangepicker.css") }}
{% endif %}

{% if (router.getControllerName() in ["admin", "gomanagement", "session"]) or (router.getControllerName() == "support" and (router.getActionName() == "listAdmin" or  router.getActionName() == "chatAdmin")) %}
  {{ stylesheet_link("css/custom.css") }}
{% else %}
  {{ stylesheet_link("css/theme.css") }}
{% endif %}

{% if router.getControllerName() == "cart" %}
  <script src="https://www.paypalobjects.com/api/checkout.js"></script>
{% elseif router.getControllerName() == "catalog" %}
  {{ javascript_include("js/tinysort.min.js") }}
  {{ javascript_include("js/tinysort.charorder.min.js") }}
{% elseif router.getControllerName() == "model" %}
  {{ javascript_include("js/flickity.pkgd.min.js") }}
{% endif %}

{% if router.getControllerName() != "session" %}
  {{ javascript_include("vendors/page-preloading.js") }}
  {{ javascript_include("vendors/modernizr.custom.js") }}
{% endif %}

{{ stylesheet_link("vendors/toastify-js/toastify.css") }}
