<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('_common.series') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
				<button type="button" class="btn btn-primary waves-effect waves-light left-btn" data-toggle='modal' data-target='#modal-insert-series'>
					{{ mt._('admin.series.new') }}
				</button>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if series|length > 0 %}
  			<table id="table-series" class="table table-striped table-bordered">
  				<thead>
  					<tr>
  						<th>{{ mt._('_common.code') }}</th>
  						<th>{{ mt._('_common.code.line') }}</th>
  						<th>{{ mt._('_common.description') }}</th>
  						<th>{{ mt._('admin.seqrap') }}</th>
  						<th></th>
  					</tr>
  				</thead>
  				<tbody>
					{% for ser in series %}
						<tr data-cdserm="{{ ser.cdserm }}" data-dsserm="{{ ser.dsserm }}" data-cdlinm="{{ ser.cdlinm }}" data-seqrap="{{ ser.seqrap }}">
							<td>{{ ser.cdserm }}</td>
							<td>{{ ser.cdlinm }}</td>
							<td>{{ ser.dsserm }}</td>
							<td>{{ ser.seqrap }}</td>
							<td class="center" style="vertical-align:middle">
								<a href="#" class="open-edit-series" title="{{ mt._('admin.series.edit') }}"
									data-toggle='modal' data-target='#modal-edit-series'>
									<span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
								</a>
								<a href="#" class="open-delete-series pl-10x" title="{{ mt._('admin.series.delete') }}"
									data-toggle='modal' data-target='#modal-delete-series'>
									<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
								</a>
							</td>
						</tr>
					{% endfor %}
					</tbody>
				</table>
			{% else %}
			{{ mt._('admin.series.no') }}
			{% endif %}
			</div>
		</div>
	</div>
</div>

<!-- Modal for insert line -->
<div class="modal fade" id="modal-insert-series" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.series.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<div class="msg-error"></div>
				<div class="msg-success"></div>
				<div class="py-10x">
					<label for="cdserm" class="control-label">{{ mt._('_common.code.series') }}</label>
					<input type="text" maxlength="10" id="cdserm" class="form-control" title="{{ mt._('_common.code') }}">
				</div>
				<div class="py-10x">
					<label for="dsserm" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="dsserm" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="cdlinm" class="control-label">{{mt._('_common.line')}}</label>
					<select id="cdlinm" class="form-control" title="{{ mt._('_common.line') }}">
						{% for lin in lines %}
							<option value="{{ lin.cdlinm }}">
								{{ lin.dslinm }}
							</option>
						{% endfor %}
					</select>
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="seqrap" class="form-control" min="0" value="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="insert-series" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for edit series -->
<div class="modal fade" id="modal-edit-series" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.series.edit') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body px-20x">
				<input type="hidden" id="edit-cdserm">
				<input type="hidden" id="edit-cdlinm">
				<div class="py-10x">
					<label for="edit-dsserm" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="edit-dsserm" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="edit-seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="edit-seqrap" class="form-control" min="0" value="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="edit-series" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for delete series -->
<div class="modal fade" id="modal-delete-series" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.series.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="delete-cdlinm">
				<input type="hidden" id="delete-cdserm">
				<div class="py-10x">{{ mt._('admin.series.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-series" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
