<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('_common.lines') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
				<button type="button" class="btn btn-primary waves-effect waves-light left-btn" data-toggle='modal' data-target='#modal-insert-line'>
					{{ mt._('admin.lines.new') }}
				</button>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if lines|length > 0 %}
			  <table id="table-lines" class="table table-striped table-bordered">
			  	<thead>
			  		<tr>
			  			<th>{{ mt._('_common.code') }}</th>
			  			<th>{{ mt._('_common.code.brand') }}</th>
			  			<th>{{ mt._('_common.description') }}</th>
			  			<th>{{ mt._('admin.seqrap') }}</th>
			  			<th></th>
			  		</tr>
			  	</thead>
			  	<tbody>
			  		{% for line in lines %}
			  			<tr data-cdlinm="{{ line.cdlinm }}" data-dslinm="{{ line.dslinm }}" data-cdtitl="{{ line.cdtitl }}" data-seqrap="{{ line.seqrap }}">
			  				<td>{{ line.cdlinm }}</td>
			  				<td>{{ line.cdtitl }}</td>
			  				<td>{{ line.dslinm }}</td>
			  				<td>{{ line.seqrap }}</td>
								<td class="center" style="vertical-align:middle">
									<a href="#" class="open-edit-line" title="{{ mt._('admin.lines.edit') }}"
										data-toggle='modal' data-target='#modal-edit-line'>
										<span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
									</a>
									<a href="#" class="open-delete-line pl-10x" title="{{ mt._('admin.lines.delete') }}"
										data-toggle='modal' data-target='#modal-delete-line'>
										<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
									</a>
								</td>
			  			</tr>
			  		{% endfor %}
			  	</tbody>
			  </table>
			{% else %}
			{{ mt._('admin.lines.no') }}
			{% endif %}
			</div>
		</div>
	</div>
</div>

<!-- Modal for insert line -->
<div id="modal-insert-line" class="modal fade" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.lines.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>

			<div class="modal-body">
				<div class="msg-error"></div>
				<div class="py-10x">
					<label for="cdlinm" class="control-label">{{ mt._('_common.code.line') }}</label>
					<input type="text" id="cdlinm" name="cdlinm" class="form-control" maxlength="10" title="{{ mt._('_common.code') }}">
				</div>
				<div class="py-10x">
					<label for="dslinm" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="dslinm" name="dslinm" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="cdtitl" class="control-label">{{mt._('_common.brand')}}</label>
					<select id="cdtitl" name="cdtitl" class="form-control" title="{{ mt._('_common.brand') }}">
						{% for brand in brands %}
						<option value="{{ brand.cdtitl }}">
							{{ brand.dstitl }}
						</option>
						{% endfor %}
					</select>
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="seqrap" name="seqrap" class="form-control" value="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="insert-line" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>

		</div>
	</div>
</div>

<!-- Modal for edit line -->
<div id="modal-edit-line" class="modal fade" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.lines.edit') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body px-20x">
				<input type="hidden" id="edit-cdlinm">
				<div class="py-10x">
					<label for="dslinm" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="edit-dslinm" name="dslinm" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="edit-cdtitl" class="control-label">{{mt._('_common.brand')}}</label>
					<select id="edit-cdtitl" name="cdtitl" class="form-control" title="{{ mt._('_common.brand') }}">
					{% for brand in brands %}
						<option value="{{ brand.cdtitl }}">
							{{ brand.dstitl }}
						</option>
					{% endfor %}
					</select>
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="edit-seqrap" name="seqrap" class="form-control" value="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="edit-line" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for delete line -->
<div class="modal fade" id="modal-delete-line" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.lines.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="delete-cdlinm">
				<div class="py-10x">{{ mt._('admin.lines.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-line" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
