<div class="x_panel">

  <div class="x_content">
    <div class="row">
      <div class="col-xs-6">
        <a href="{{ url('gomanagement/devices') }}" class="btn btn-default waves-effect waves-light left-btn">{{ mt._('_common.close') }}</a>
      </div>
      <div class="col-xs-6">
	  	  <button type="button" class="btn btn-primary waves-effect waves-light right-btn save-device">
          {{ mt._('_common.save') }}
        </button>
      </div>
      <div class="col-md-12">
        <div class="msg-error py-10x">{{ mt._('_common.generic.db.error') }}</div>
        <div class="msg-success py-10x">{{ mt._('_common.generic.db.success') }}</div>
      </div>
    </div>
  </div>

  <div class="x_title mt-30x">
    <h2>{{ cdagen != "" ? mt._('admin.devices.edit') : mt._('admin.devices.new.s') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content mt-20x">
    <div class="row">
      <div class="form-group col-md-8">
      {% if cdagen != "" %}
        <div class="col-md-3 col-sm-3 col-xs-12 text-right">{{ mt._("_common.agent") }}</div>
        <div class="col-md-9 col-sm-9 col-xs-12">{{ anaage.cdagen }} - {{ anaage.dsagen }}</div>
      {% else %}
        <label for="cdagen" class="control-label col-md-3 col-sm-3 col-xs-12 text-right" style="line-height:34px">
          {{ mt._('statistics.select.agent') }}
        </label>
        <div class="col-md-9 col-sm-9 col-xs-12">
          <select id="cdagen" class="select2_single form-control" tabindex="-1">
            {% for agent in agents %}
            <option value="{{ agent.cdagen }}">{{ agent.cdagen }} - {{ agent.dsagen }}</option>
            {% endfor %}
          </select>
        </div>
      {% endif %}
      </div>
    </div>

  </div>

  <div class="x_title mt-30x">
    <h2>{{ mt._('_common.generalinfo') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content mt-20x">
    <div class="row">
      <div class="form-group col-md-8">
        <label for="tpcond" class="control-label col-md-3 col-sm-3 col-xs-12 text-right" style="text-align:right;margin-top:10px">
          {{ mt._('_common.condition.select') }}
        </label>
        <div class="col-md-9 col-sm-9 col-xs-12">
          <select id="tpcond" class="select2_single form-control" tabindex="-1">
            <option value="">&nbsp;</option>
          {% for condition in conditions %}
            <option value="{{ condition.tpcond }}" {% if abagen is defined and condition.tpcond == abagen.tpcond %}selected{% endif %}>{{ condition.dscond }}</option>
          {% endfor %}
          </select>
        </div>
      </div>
      <div class="form-group col-md-2" style="line-height:34px">
        <label class="checkbox-container fl">
          <input type="checkbox" id="fllist" name="fllist" class="form-control m-0 mt-5x fl" style="height:16px;width:16px"
          {% if abagen is defined and abagen.fllist == 1 %}checked{% endif %}>
          <span class="checkbox-checkmark mt-5x"></span>
        </label>
        {{ mt._('admin.devices.pricelistflag') }}
      </div>
      <div class="form-group col-md-2" style="line-height:34px">
        <label class="checkbox-container fl">
          <input type="checkbox" id="fltota" name="fltota" class="form-control m-0 mt-5x fl" style="height:16px;width:16px"
          {% if abagen is defined and abagen.fltota == 1 %}checked{% endif %}>
          <span class="checkbox-checkmark mt-5x"></span>
        </label>
        {{ mt._('statistics.selected.cus.all') }}
      </div>
    </div>
    <div class="row mt-10x">
      <div class="col-sm-6"></div>
      <div class="col-sm-6">
        <button type="button" id="new-device" class="btn btn-primary right-btn">{{ mt._('admin.devices.new.s') }}</button>
      </div>
    </div>
  </div>

  <div class="x_title mt-30x">
    <h2>{{ mt._('_common.device') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content mt-20x" id="devices">
    <div class="row" id="header-devices" style="margin-bottom:10px">
      <div class="dev-hd-sml">{{ mt._('admin.seqrap.short') }}</div>
      <div class="dev-hd-big">{{ mt._('_common.description') }}</div>
      <div class="dev-hd-big">{{ mt._('_common.device') }}</div>
      <div class="dev-hd-sml">&nbsp;</div>
    </div>

  {% if psagen is not defined %}
    <div class="row device" id="device-1" data-index="1">
      <div class="dev-hd-sml dev-index right">1</div>
      <div class="dev-hd-big"><input type="text" name="dspost[]" class="form-control"></div>
      <div class="dev-hd-big"><input type="number" min='0' step='1' name="egoapp[]" class="form-control"></div>
      <div class="dev-hd-sml">&nbsp;</div>
    </div>
  {% else %}
    {% set index = 1 %}
    {% for row in psagen %}
    <div class="row device" id="device-{{ row.cdpost }}" data-index="{{ row.cdpost }}">
      <div class="dev-hd-sml dev-index right">{{ row.cdpost }}</div>
      <div class="dev-hd-big"><input type="text" name="dspost[]" class="form-control" value="{{ row.dspost }}"></div>
      <div class="dev-hd-big"><input type="number" min='0' step='1' name="egoapp[]" class="form-control" value="{{ row.egoapp }}"></div>
      <div class="dev-hd-sml">{% if index > 1 %}<i class='fa fa-close dev-remove' aria-hidden='true'></i>{% else %}&nbsp;{% endif %}</div>
    </div>
      {% set index = index + 1 %}
    {% endfor %}
  {% endif %}
  </div>

  <div class="x_content mt-40x mb-20x">
    <div class="row">
      <div class="col-xs-6">
        <a href="{{ url('gomanagement/devices') }}" class="btn btn-default waves-effect waves-light left-btn">{{ mt._('_common.close') }}</a>
      </div>
      <div class="col-xs-6">
	  	  <button type="button" class="btn btn-primary waves-effect waves-light right-btn save-device">
          {{ mt._('_common.save') }}
        </button>
      </div>
      <div class="col-md-12">
        <div class="msg-error py-10x">{{ mt._('_common.generic.db.error') }}</div>
        <div class="msg-success py-10x">{{ mt._('_common.generic.db.success') }}</div>
      </div>
    </div>
  </div>

</div>
