<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.devices') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
        <a href="{{ url('gomanagement/editDevice') }}" class="btn btn-primary waves-effect waves-light left-btn">{{ mt._('admin.devices.new') }}</a>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if devices|length > 0 %}
        <table id="table-devices" class="table table-striped table-bordered">
          <thead class="text-capitalize">
            <tr>
              <th>{{ mt._('_common.device') }}</th>
              <th>{{ mt._('_common.name') }}</th>
              <th>{{ mt._('_common.agent') }}</th>
              <th>{{ mt._('_common.condition') }}</th>
              <th>{{ mt._('_common.agent.executive') }}</th>
              <th>{{ mt._('_common.pricelists.free') }}</th>
              <th>{{ mt._('_common.active') }}</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
          {% for device in devices %}
            <tr data-cdagen="{{ device.cdagen }}" data-cdpost="{{ device.cdpost }}" data-dsagen="{{ device.dsagen }}">
              <td><span>{{ device.egoapp }}</span></td>
              <td><span>{{ device.dspost }}</span></td>
              <td><span>{{ device.cdagen }} - {{ device.dsagen }}</span></td>
              <td><span>{{ device.dscond }}</span></td>
              <td class="center">{% if device.fltota == "S" %}<span style="display:none">S</span><span><i class="fa fa-check" aria-hidden="true"></i></span>{% endif %}</td>
              <td class="center">{% if device.fllist == "S" %}<span style="display:none">S</span><span><i class="fa fa-check" aria-hidden="true"></i></span>{% endif %}</td>
              <td class="center">{% if device.keylic == "S" %}<span style="display:none">S</span><span><i class="fa fa-check" aria-hidden="true"></i></span>{% endif %}</td>
              <td class="center" style="vertical-align:middle">
                <a href="{{ url('gomanagement/editDevice/' ~ device.cdagen) }}" title="{{ mt._('admin.devices.edit') }}">
                  <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                </a>
                <a href="#" class="open-delete-device pl-10x" title="{{ mt._('admin.devices.delete') }}"
                  data-toggle='modal' data-target='#modal-delete-device'>
                  <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                </a>
              </td>
            </tr>
          {% endfor %}
          </tbody>
        </table>
			{% else %}
			{{ mt._('admin.devices.no') }}
			{% endif %}
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete device -->
<div class="modal fade" id="modal-delete-device" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.devices.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
        <input type="hidden" id="delete-cdagen">
				<input type="hidden" id="delete-cdpost">
				<div class="py-10x">{{ mt._('admin.devices.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-device" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
