<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.catalogmanager') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="col-xs-6 col-sm-6 col-md-6">
        <a href="{{ url('gomanagement/createCatalog') }}" class="btn btn-primary waves-effect waves-light left-btn">{{ mt._('admin.catalog.create') }}</a>
      </div>
      <div class="col-xs-6 col-sm-6 col-md-6">
        <button type="button" disabled="disabled" class="btn btn-default waves-effect waves-light right-btn" id="btn-delete"
          data-toggle="modal" data-target="#modal-delete-catalogs">
          {{ mt._('admin.catalog.delete') }}
        </button>
      </div>
    </div>
    <div class="row py-10x">
      <div class="col-sm-12 col-xs-12 col-md-12 card-box table-responsive" style="overflow-x:hidden">
      {% if catalogs|length > 0 %}
        <table id="table-catalogs" class="table table-striped table-bordered">
          <thead>
            <tr>
              <th class="no-sort"></th>
              <th>{{ mt._('_common.code') }}</th>
              <th>{{ mt._('_common.description') }}</th>
              <th>{{ mt._('admin.validfrom') }}</th>
              <th>{{ mt._('admin.validto') }}</th>
              <th></th>
            </tr>
          </thead>

          <tbody>
            {% for catalog in catalogs %}
            <tr>
              <td class="text-center">
                <label class="checkbox-container">
                  <input type="checkbox" data-id="{{ catalog.cdcata }}">
                  <span class="checkbox-checkmark"></span>
                </label>
              </td>
              <td><span>{{ catalog.cdcata }}</span></td>
              <td><span>{{ catalog.dscata }}</span></td>
              <td><span>{{ catalog.dtiniz }}</span></td>
              <td><span>{{ catalog.dtfine }}</span></td>
              <td class="text-center">
                <span>
                  <a href="{{ url('gomanagement/catalogDetail/' ~ catalog.cdcata) }}" title="{{ mt._('_common.edit') }}">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>
            {% endfor %}
          </tbody>
        </table>
        {% else %}
          {{ mt._('admin.custommenu.warning') }}
        {% endif %}
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete catalogs -->
<div class="modal fade" id="modal-delete-catalogs" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.catalog.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>
			<div class="modal-body">
				<div class="py-10x">{{ mt._('admin.catalog.delete.confirm') }}</div>
			</div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-catalogs" type="button" class="btn btn-primary right-btn w-50 capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
    </div>
  </div>
</div>
